/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.util;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Consumer;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.ability.ArrowReflector;
import mods.flammpfeil.slashblade.ability.TNTExtinguisher;
import mods.flammpfeil.slashblade.capability.concentrationrank.ConcentrationRankCapabilityProvider;
import mods.flammpfeil.slashblade.capability.concentrationrank.IConcentrationRank;
import mods.flammpfeil.slashblade.entity.EntityAbstractSummonedSword;
import mods.flammpfeil.slashblade.entity.EntitySlashEffect;
import mods.flammpfeil.slashblade.entity.IShootable;
import mods.flammpfeil.slashblade.entity.Projectile;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.util.KnockBacks;
import mods.flammpfeil.slashblade.util.TargetSelector;
import mods.flammpfeil.slashblade.util.VectorHelper;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class AttackManager {
    public static void areaAttack(LivingEntity playerIn, Consumer<LivingEntity> beforeHit) {
        AttackManager.areaAttack(playerIn, beforeHit, 1.0f, true, true, false);
    }

    public static EntitySlashEffect doSlash(LivingEntity playerIn, float roll) {
        return AttackManager.doSlash(playerIn, roll, false);
    }

    public static EntitySlashEffect doSlash(LivingEntity playerIn, float roll, boolean mute) {
        return AttackManager.doSlash(playerIn, roll, mute, false);
    }

    public static EntitySlashEffect doSlash(LivingEntity playerIn, float roll, boolean mute, boolean critical) {
        return AttackManager.doSlash(playerIn, roll, mute, critical, 1.0);
    }

    public static EntitySlashEffect doSlash(LivingEntity playerIn, float roll, boolean mute, boolean critical, double damage) {
        return AttackManager.doSlash(playerIn, roll, Vec3.f_82478_, mute, critical, damage);
    }

    public static EntitySlashEffect doSlash(LivingEntity playerIn, float roll, Vec3 centerOffset, boolean mute, boolean critical, double damage) {
        return AttackManager.doSlash(playerIn, roll, centerOffset, mute, critical, damage, KnockBacks.cancel);
    }

    public static EntitySlashEffect doSlash(LivingEntity playerIn, float roll, Vec3 centerOffset, boolean mute, boolean critical, double damage, KnockBacks knockback) {
        int colorCode = playerIn.m_21205_().getCapability(ItemSlashBlade.BLADESTATE).map(state -> state.getColorCode()).orElseGet(() -> 0xFFFFFF);
        return AttackManager.doSlash(playerIn, roll, colorCode, centerOffset, mute, critical, damage, knockback);
    }

    public static EntitySlashEffect doSlash(LivingEntity playerIn, float roll, int colorCode, Vec3 centerOffset, boolean mute, boolean critical, double damage, KnockBacks knockback) {
        if (playerIn.m_9236_().f_46443_) {
            return null;
        }
        Vec3 pos = playerIn.m_20182_().m_82520_(0.0, (double)playerIn.m_20192_() * 0.75, 0.0).m_82549_(playerIn.m_20154_().m_82490_((double)0.3f));
        pos = pos.m_82549_(VectorHelper.getVectorForRotation(-90.0f, playerIn.m_5675_(0.0f)).m_82490_(centerOffset.f_82480_)).m_82549_(VectorHelper.getVectorForRotation(0.0f, playerIn.m_5675_(0.0f) + 90.0f).m_82490_(centerOffset.f_82481_)).m_82549_(playerIn.m_20154_().m_82490_(centerOffset.f_82481_));
        EntitySlashEffect jc = new EntitySlashEffect((EntityType<? extends Projectile>)SlashBlade.RegistryEvents.SlashEffect, playerIn.m_9236_());
        jc.m_6034_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        jc.m_5602_((Entity)playerIn);
        jc.setRotationRoll(roll);
        jc.m_146922_(playerIn.m_146908_());
        jc.m_146926_(0.0f);
        jc.setColor(colorCode);
        jc.setMute(mute);
        jc.setIsCritical(critical);
        jc.setDamage(damage);
        jc.setKnockBack(knockback);
        if (playerIn != null) {
            playerIn.getCapability(ConcentrationRankCapabilityProvider.RANK_POINT).ifPresent(rank -> jc.setRank(rank.getRankLevel(playerIn.m_9236_().m_46467_())));
        }
        playerIn.m_9236_().m_7967_((Entity)jc);
        return jc;
    }

    public static List<Entity> areaAttack(LivingEntity playerIn, Consumer<LivingEntity> beforeHit, float ratio, boolean forceHit, boolean resetHit, boolean mute) {
        return AttackManager.areaAttack(playerIn, beforeHit, ratio, forceHit, resetHit, mute, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Entity> areaAttack(LivingEntity playerIn, Consumer<LivingEntity> beforeHit, float ratio, boolean forceHit, boolean resetHit, boolean mute, List<Entity> exclude) {
        List<Object> founds = Lists.newArrayList();
        float modifiedRatio = (1.0f + EnchantmentHelper.m_44821_((LivingEntity)playerIn) * 0.5f) * ratio;
        AttributeModifier am = new AttributeModifier("SweepingDamageRatio", (double)modifiedRatio, AttributeModifier.Operation.MULTIPLY_BASE);
        if (!playerIn.m_9236_().m_5776_()) {
            try {
                playerIn.m_21051_(Attributes.f_22281_).m_22118_(am);
                founds = TargetSelector.getTargettableEntitiesWithinAABB(playerIn.m_9236_(), playerIn);
                if (exclude != null) {
                    founds.removeAll(exclude);
                }
                for (Entity entity : founds) {
                    if (entity instanceof LivingEntity) {
                        beforeHit.accept((LivingEntity)entity);
                    }
                    AttackManager.doMeleeAttack(playerIn, entity, forceHit, resetHit);
                }
            }
            finally {
                playerIn.m_21051_(Attributes.f_22281_).m_22130_(am);
            }
        }
        if (!mute) {
            playerIn.m_9236_().m_6263_((Player)null, playerIn.m_20185_(), playerIn.m_20186_(), playerIn.m_20189_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 0.5f, 0.4f / (playerIn.m_217043_().m_188501_() * 0.4f + 0.8f));
        }
        return founds;
    }

    public static <E extends Entity> List<Entity> areaAttack(E owner, Consumer<LivingEntity> beforeHit, double reach, boolean forceHit, boolean resetHit) {
        return AttackManager.areaAttack(owner, beforeHit, reach, forceHit, resetHit, null);
    }

    public static <E extends Entity> List<Entity> areaAttack(E owner, Consumer<LivingEntity> beforeHit, double reach, boolean forceHit, boolean resetHit, List<Entity> exclude) {
        List<Object> founds = Lists.newArrayList();
        AABB bb = owner.m_20191_();
        if (!owner.m_9236_().m_5776_()) {
            founds = TargetSelector.getTargettableEntitiesWithinAABB(owner.m_9236_(), reach, owner);
            if (exclude != null) {
                founds.removeAll(exclude);
            }
            for (Entity entity : founds) {
                if (entity instanceof LivingEntity) {
                    beforeHit.accept((LivingEntity)entity);
                }
                float baseAmount = (float)((IShootable)owner).getDamage();
                AttackManager.doAttackWith(owner.m_269291_().m_269104_(owner, ((IShootable)owner).getShooter()), baseAmount, entity, forceHit, resetHit);
            }
        }
        return founds;
    }

    public static void doManagedAttack(Consumer<Entity> attack, Entity target, boolean forceHit, boolean resetHit) {
        if (forceHit) {
            target.f_19802_ = 0;
        }
        attack.accept(target);
        if (resetHit) {
            target.f_19802_ = 0;
        }
    }

    public static void doAttackWith(DamageSource src, float amount, Entity target, boolean forceHit, boolean resetHit) {
        if (target instanceof EntityAbstractSummonedSword) {
            return;
        }
        AttackManager.doManagedAttack(t -> t.m_6469_(src, amount), target, forceHit, resetHit);
    }

    public static void doMeleeAttack(LivingEntity attacker, Entity target, boolean forceHit, boolean resetHit) {
        if (attacker instanceof Player) {
            AttackManager.doManagedAttack(t -> attacker.m_21205_().getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> {
                IConcentrationRank.ConcentrationRanks rankBonus = attacker.getCapability(ConcentrationRankCapabilityProvider.RANK_POINT).map(rp -> rp.getRank(attacker.m_20193_().m_46467_())).orElse(IConcentrationRank.ConcentrationRanks.NONE);
                float modifiedRatio = (float)rankBonus.level / 2.0f;
                if (attacker instanceof Player && IConcentrationRank.ConcentrationRanks.S.level <= rankBonus.level) {
                    int level = ((Player)attacker).f_36078_;
                    modifiedRatio = Math.max(modifiedRatio, (float)Math.min(level, state.getRefine()));
                }
                AttributeModifier am = new AttributeModifier("RankDamageBonus", (double)modifiedRatio, AttributeModifier.Operation.ADDITION);
                try {
                    state.setOnClick(true);
                    attacker.m_21051_(Attributes.f_22281_).m_22118_(am);
                    ((Player)attacker).m_5706_(t);
                }
                finally {
                    attacker.m_21051_(Attributes.f_22281_).m_22130_(am);
                    state.setOnClick(false);
                }
            }), target, forceHit, resetHit);
        } else {
            float baseAmount = (float)attacker.m_21051_(Attributes.f_22281_).m_22135_();
            AttackManager.doAttackWith(attacker.m_269291_().m_269333_(attacker), baseAmount, target, forceHit, resetHit);
        }
        ArrowReflector.doReflect(target, (Entity)attacker);
        TNTExtinguisher.doExtinguishing(target, attacker);
    }
}

