/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.specialattack;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Function;
import mods.flammpfeil.slashblade.capability.slashblade.ComboState;
import mods.flammpfeil.slashblade.capability.slashblade.combo.Extra;
import mods.flammpfeil.slashblade.util.RegistryBase;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;

public class SlashArts
extends RegistryBase<SlashArts> {
    static Map<ResourceLocation, SlashArts> registry = Maps.newHashMap();
    public static final int ChargeTicks = 9;
    public static final int ChargeJustTicks = 3;
    public static final int ChargeJustTicksMax = 5;
    public static final SlashArts NONE = new SlashArts(BaseInstanceName, e -> ComboState.NONE);
    public static final SlashArts JUDGEMENT_CUT = new SlashArts("judgement_cut", e -> e.m_20096_() ? Extra.EX_JUDGEMENT_CUT : Extra.EX_JUDGEMENT_CUT_SLASH_AIR).setComboStateJust(e -> Extra.EX_JUDGEMENT_CUT_SLASH_JUST).setComboStateBroken(e -> Extra.EX_VOID_SLASH);
    private Function<LivingEntity, ComboState> comboState;
    private Function<LivingEntity, ComboState> comboStateJust;
    private Function<LivingEntity, ComboState> comboStateBroken;

    @Override
    public Map<ResourceLocation, SlashArts> getRegistry() {
        return registry;
    }

    public static int getJustReceptionSpan(LivingEntity user) {
        return Math.min(5, 3 + EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44976_, (LivingEntity)user));
    }

    public ComboState doArts(ArtsType type, LivingEntity user) {
        switch (type) {
            case Jackpot: {
                return this.getComboStateJust(user);
            }
            case Success: {
                return this.getComboState(user);
            }
            case Broken: {
                return this.getComboStateBroken(user);
            }
        }
        return ComboState.NONE;
    }

    public SlashArts(String name, Function<LivingEntity, ComboState> state) {
        super(name);
        this.comboState = state;
        this.comboStateJust = state;
        this.comboStateBroken = state;
    }

    @Override
    public String getPath() {
        return "slasharts";
    }

    @Override
    public SlashArts getNone() {
        return NONE;
    }

    public ComboState getComboState(LivingEntity user) {
        return this.comboState.apply(user);
    }

    public ComboState getComboStateJust(LivingEntity user) {
        return this.comboStateJust.apply(user);
    }

    public SlashArts setComboStateJust(Function<LivingEntity, ComboState> state) {
        this.comboStateJust = state;
        return this;
    }

    public ComboState getComboStateBroken(LivingEntity user) {
        return this.comboStateBroken.apply(user);
    }

    public SlashArts setComboStateBroken(Function<LivingEntity, ComboState> state) {
        this.comboStateBroken = state;
        return this;
    }

    public static enum ArtsType {
        Fail,
        Success,
        Jackpot,
        Broken;

    }
}

