/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.optional.playerAnim;

import com.google.common.collect.Maps;
import dev.kosmx.playerAnim.api.layered.AnimationStack;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationAccess;
import java.util.HashMap;
import java.util.Map;
import mods.flammpfeil.slashblade.capability.slashblade.combo.Extra;
import mods.flammpfeil.slashblade.event.BladeMotionEvent;
import mods.flammpfeil.slashblade.optional.playerAnim.VmdAnimation;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class PlayerAnimationOverrider {
    static final ResourceLocation MotionLocation = new ResourceLocation("slashblade", "model/pa/player_motion.vmd");
    Map<String, VmdAnimation> animation = this.initAnimations();

    public static PlayerAnimationOverrider getInstance() {
        return SingletonHolder.instance;
    }

    private PlayerAnimationOverrider() {
    }

    public void register() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onBladeAnimationStart(BladeMotionEvent event) {
        if (!(event.getEntity() instanceof AbstractClientPlayer)) {
            return;
        }
        AbstractClientPlayer player = (AbstractClientPlayer)event.getEntity();
        AnimationStack animationStack = PlayerAnimationAccess.getPlayerAnimLayer((AbstractClientPlayer)player);
        VmdAnimation animation = this.animation.get(event.getCombo().getName());
        if (animation != null) {
            animationStack.removeLayer(0);
            animation.play();
            animationStack.addAnimLayer(0, (IAnimation)animation.getClone());
        }
    }

    private Map<String, VmdAnimation> initAnimations() {
        HashMap map = Maps.newHashMap();
        map.put(Extra.EX_COMBO_A1_END2.getName(), new VmdAnimation(MotionLocation, 21.0, 41.0, false));
        map.put(Extra.EX_COMBO_A1.getName(), new VmdAnimation(MotionLocation, 1.0, 41.0, false));
        map.put(Extra.EX_COMBO_A2.getName(), new VmdAnimation(MotionLocation, 100.0, 151.0, false));
        map.put(Extra.EX_COMBO_C.getName(), new VmdAnimation(MotionLocation, 400.0, 488.0, false));
        map.put(Extra.EX_COMBO_A3.getName(), new VmdAnimation(MotionLocation, 200.0, 314.0, false));
        map.put(Extra.EX_COMBO_A4.getName(), new VmdAnimation(MotionLocation, 500.0, 608.0, false));
        map.put(Extra.EX_COMBO_A4EX.getName(), new VmdAnimation(MotionLocation, 800.0, 894.0, false));
        map.put(Extra.EX_COMBO_A5EX.getName(), new VmdAnimation(MotionLocation, 900.0, 1061.0, false));
        map.put(Extra.EX_COMBO_B1.getName(), new VmdAnimation(MotionLocation, 700.0, 787.0, false));
        map.put(Extra.EX_COMBO_B2.getName(), new VmdAnimation(MotionLocation, 710.0, 787.0, false));
        map.put(Extra.EX_COMBO_B3.getName(), new VmdAnimation(MotionLocation, 710.0, 787.0, false));
        map.put(Extra.EX_COMBO_B4.getName(), new VmdAnimation(MotionLocation, 710.0, 787.0, false));
        map.put(Extra.EX_COMBO_B5.getName(), new VmdAnimation(MotionLocation, 710.0, 787.0, false));
        map.put(Extra.EX_COMBO_B6.getName(), new VmdAnimation(MotionLocation, 710.0, 787.0, false));
        map.put(Extra.EX_COMBO_B7.getName(), new VmdAnimation(MotionLocation, 710.0, 787.0, false));
        map.put(Extra.EX_AERIAL_RAVE_A1.getName(), new VmdAnimation(MotionLocation, 1100.0, 1132.0, false).setBlendLegs(false));
        map.put(Extra.EX_AERIAL_RAVE_A2.getName(), new VmdAnimation(MotionLocation, 1200.0, 1241.0, false).setBlendLegs(false));
        map.put(Extra.EX_AERIAL_RAVE_A3.getName(), new VmdAnimation(MotionLocation, 1300.0, 1338.0, false).setBlendLegs(false));
        map.put(Extra.EX_AERIAL_RAVE_B3.getName(), new VmdAnimation(MotionLocation, 1400.0, 1443.0, false).setBlendLegs(false));
        map.put(Extra.EX_AERIAL_RAVE_B4.getName(), new VmdAnimation(MotionLocation, 1500.0, 1547.0, false).setBlendLegs(false));
        map.put(Extra.EX_UPPERSLASH.getName(), new VmdAnimation(MotionLocation, 1600.0, 1693.0, false));
        map.put(Extra.EX_UPPERSLASH_JUMP.getName(), new VmdAnimation(MotionLocation, 1700.0, 1717.0, false).setBlendLegs(false));
        map.put(Extra.EX_AERIAL_CLEAVE.getName(), new VmdAnimation(MotionLocation, 1800.0, 1817.0, false).setBlendLegs(false));
        map.put(Extra.EX_AERIAL_CLEAVE_LOOP.getName(), new VmdAnimation(MotionLocation, 1812.0, 1817.0, true).setBlendLegs(false));
        map.put(Extra.EX_AERIAL_CLEAVE_LANDING.getName(), new VmdAnimation(MotionLocation, 1816.0, 1886.0, false));
        map.put(Extra.EX_RAPID_SLASH.getName(), new VmdAnimation(MotionLocation, 2000.0, 2073.0, false).setBlendLegs(false));
        map.put(Extra.EX_RAPID_SLASH_QUICK.getName(), new VmdAnimation(MotionLocation, 2000.0, 2073.0, false).setBlendLegs(false));
        map.put(Extra.EX_RISING_STAR.getName(), new VmdAnimation(MotionLocation, 2100.0, 2147.0, false).setBlendLegs(false));
        map.put(Extra.EX_JUDGEMENT_CUT.getName(), new VmdAnimation(MotionLocation, 1900.0, 1963.0, false).setBlendLegs(false));
        map.put(Extra.EX_JUDGEMENT_CUT_SLASH_AIR.getName(), new VmdAnimation(MotionLocation, 1923.0, 1963.0, false).setBlendLegs(false));
        map.put(Extra.EX_JUDGEMENT_CUT_SLASH_JUST.getName(), new VmdAnimation(MotionLocation, 1923.0, 1963.0, false).setBlendLegs(false));
        map.put(Extra.EX_VOID_SLASH.getName(), new VmdAnimation(MotionLocation, 2200.0, 2299.0, false).setBlendLegs(false));
        return map;
    }

    private static final class SingletonHolder {
        private static final PlayerAnimationOverrider instance = new PlayerAnimationOverrider();

        private SingletonHolder() {
        }
    }
}

