/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.item;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableRangeMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.capability.inputstate.IInputState;
import mods.flammpfeil.slashblade.capability.slashblade.ComboState;
import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import mods.flammpfeil.slashblade.client.renderer.SlashBladeTEISR;
import mods.flammpfeil.slashblade.entity.BladeItemEntity;
import mods.flammpfeil.slashblade.event.AnvilCraftingRecipe;
import mods.flammpfeil.slashblade.init.SBItems;
import mods.flammpfeil.slashblade.item.ReachModifier;
import mods.flammpfeil.slashblade.util.InputCommand;
import mods.flammpfeil.slashblade.util.NBTHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.server.ServerLifecycleHooks;

public class ItemSlashBlade
extends SwordItem {
    protected static final UUID ATTACK_DAMAGE_AMPLIFIER = UUID.fromString("2D988C13-595B-4E58-B254-39BB6FA077FD");
    protected static final UUID PLAYER_REACH_AMPLIFIER = UUID.fromString("2D988C13-595B-4E58-B254-39BB6FA077FE");
    public static final Capability<ISlashBladeState> BLADESTATE = CapabilityManager.get((CapabilityToken)new CapabilityToken<ISlashBladeState>(){});
    public static final Capability<IInputState> INPUT_STATE = CapabilityManager.get((CapabilityToken)new CapabilityToken<IInputState>(){});
    public static final String BREAK_ACTION_TIMEOUT = "BreakActionTimeout";
    public static final String ICON_TAG_KEY = "SlashBladeIcon";
    RangeMap refineColor = ImmutableRangeMap.builder().put(Range.lessThan((Comparable)Integer.valueOf(10)), (Object)ChatFormatting.WHITE).put(Range.closedOpen((Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(50)), (Object)ChatFormatting.YELLOW).put(Range.closedOpen((Comparable)Integer.valueOf(50), (Comparable)Integer.valueOf(100)), (Object)ChatFormatting.GREEN).put(Range.closedOpen((Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(150)), (Object)ChatFormatting.AQUA).put(Range.closedOpen((Comparable)Integer.valueOf(150), (Comparable)Integer.valueOf(200)), (Object)ChatFormatting.BLUE).put(Range.atLeast((Comparable)Integer.valueOf(200)), (Object)ChatFormatting.LIGHT_PURPLE).build();

    public ItemSlashBlade(Tier tier, int attackDamageIn, float attackSpeedIn, Item.Properties builder) {
        super(tier, attackDamageIn, attackSpeedIn, builder);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        Multimap def = super.getAttributeModifiers(slot, stack);
        ArrayListMultimap result = ArrayListMultimap.create();
        result.putAll((Object)Attributes.f_22281_, (Iterable)def.get((Object)Attributes.f_22281_));
        result.putAll((Object)Attributes.f_22283_, (Iterable)def.get((Object)Attributes.f_22283_));
        if (slot == EquipmentSlot.MAINHAND) {
            LazyOptional state = stack.getCapability(BLADESTATE);
            state.ifPresent(arg_0 -> ItemSlashBlade.lambda$getAttributeModifiers$0((Multimap)result, arg_0));
        }
        return result;
    }

    public Rarity m_41460_(ItemStack stack) {
        LazyOptional state = stack.getCapability(BLADESTATE);
        return state.filter(s -> s.getRarity() != Rarity.COMMON).map(s -> s.getRarity()).orElseGet(() -> super.m_41460_(stack));
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.m_21120_(handIn);
        boolean result = itemstack.getCapability(BLADESTATE).map(state -> {
            playerIn.getCapability(INPUT_STATE).ifPresent(s -> s.getCommands().add(InputCommand.R_CLICK));
            ComboState combo = state.progressCombo((LivingEntity)playerIn);
            playerIn.getCapability(INPUT_STATE).ifPresent(s -> s.getCommands().remove((Object)InputCommand.R_CLICK));
            if (combo != ComboState.NONE) {
                playerIn.m_6674_(handIn);
            }
            return true;
        }).orElse(false);
        playerIn.m_6672_(handIn);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemstack);
    }

    public boolean onLeftClickEntity(ItemStack itemstack, Player playerIn, Entity entity) {
        Level worldIn = playerIn.m_9236_();
        Optional stateHolder = itemstack.getCapability(BLADESTATE).filter(state -> !state.onClick());
        stateHolder.ifPresent(state -> {
            playerIn.getCapability(INPUT_STATE).ifPresent(s -> s.getCommands().add(InputCommand.L_CLICK));
            ComboState combo = state.progressCombo((LivingEntity)playerIn);
            playerIn.getCapability(INPUT_STATE).ifPresent(s -> s.getCommands().remove((Object)InputCommand.L_CLICK));
        });
        return stateHolder.isPresent();
    }

    public static Consumer<LivingEntity> getOnBroken(ItemStack stack) {
        return user -> {
            user.m_21190_(user.m_7655_());
            ItemStack soul = new ItemStack((ItemLike)SBItems.proudsoul);
            CompoundTag blade = stack.m_41739_(new CompoundTag());
            soul.m_41700_("BladeData", (Tag)blade);
            stack.getCapability(BLADESTATE).ifPresent(s -> {
                s.getTexture().ifPresent(r -> soul.m_41700_("Texture", (Tag)StringTag.m_129297_((String)r.toString())));
                s.getModel().ifPresent(r -> soul.m_41700_("Model", (Tag)StringTag.m_129297_((String)r.toString())));
            });
            ItemStack cpBlade = stack.m_41777_();
            cpBlade.getCapability(BLADESTATE).ifPresent(s -> {
                s.setDamage(0.0f);
                s.setOwner(null);
                s.setRefine(0);
                s.setKillCount(0);
            });
            cpBlade.m_41785_().clear();
            AnvilCraftingRecipe recipe = new AnvilCraftingRecipe();
            recipe.setLevel(10);
            recipe.setKillcount(0);
            recipe.setRefine(0);
            recipe.setBroken(false);
            recipe.setNoScabbard(false);
            recipe.setTranslationKey("item.slashblade.slashblade");
            recipe.setResultWithNBT(cpBlade.m_41739_(new CompoundTag()));
            recipe.setOverwriteTag(null);
            soul.m_41700_("RequiredBlade", recipe.writeNBT());
            ItemEntity itementity = new ItemEntity(user.m_9236_(), user.m_20185_(), user.m_20186_(), user.m_20189_(), soul);
            BladeItemEntity e = new BladeItemEntity((EntityType)SlashBlade.RegistryEvents.BladeItem, user.m_9236_()){
                static final String isReleased = "isReleased";

                @Override
                public boolean m_142535_(float distance, float damageMultiplier, DamageSource ds) {
                    CompoundTag tag = this.getPersistentData();
                    if (!tag.m_128471_(isReleased)) {
                        Entity thrower;
                        this.getPersistentData().m_128379_(isReleased, true);
                        if (this.m_9236_() instanceof ServerLevel && (thrower = this.m_19749_()) != null) {
                            thrower.getPersistentData().m_128473_(ItemSlashBlade.BREAK_ACTION_TIMEOUT);
                        }
                    }
                    return super.m_142535_(distance, damageMultiplier, ds);
                }
            };
            e.m_20361_((Entity)itementity);
            e.init();
            e.m_5997_(0.0, 0.4, 0.0);
            e.m_32010_(40);
            e.m_146915_(true);
            e.m_20301_(-1);
            e.m_32052_(user.m_20148_());
            user.m_9236_().m_7967_((Entity)e);
            user.getPersistentData().m_128356_(BREAK_ACTION_TIMEOUT, user.m_9236_().m_46467_() + 100L);
            stack.getCapability(BLADESTATE).ifPresent(state -> {
                if (0 < state.getRefine()) {
                    state.setRefine(state.getRefine() - 1);
                    state.doBrokenAction((LivingEntity)user);
                }
            });
        };
    }

    public boolean m_7579_(ItemStack stackF, LivingEntity target, LivingEntity attacker) {
        ItemStack stack = attacker.m_21205_();
        stack.getCapability(BLADESTATE).ifPresent(state -> {
            state.resolvCurrentComboState(attacker).hitEffect(target, attacker);
            state.damageBlade(stack, 1, attacker, ItemSlashBlade.getOnBroken(stack));
        });
        return true;
    }

    public boolean m_6813_(ItemStack stack, Level worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (state.m_60800_((BlockGetter)worldIn, pos) != 0.0f) {
            stack.getCapability(BLADESTATE).ifPresent(s -> s.damageBlade(stack, 1, entityLiving, ItemSlashBlade.getOnBroken(stack)));
        }
        return true;
    }

    public void m_5551_(ItemStack stack, Level worldIn, LivingEntity entityLiving, int timeLeft) {
        int elapsed = this.m_8105_(stack) - timeLeft;
        if (!worldIn.f_46443_) {
            stack.getCapability(BLADESTATE).ifPresent(state -> {
                ComboState sa = state.doChargeAction(entityLiving, elapsed);
                if (sa != ComboState.NONE) {
                    state.damageBlade(stack, 1, entityLiving, ItemSlashBlade.getOnBroken(stack));
                    entityLiving.m_6674_(InteractionHand.MAIN_HAND);
                }
            });
        }
    }

    public void m_5929_(Level level, LivingEntity player, ItemStack stack, int count) {
        stack.getCapability(BLADESTATE).ifPresent(state -> {
            int ticks;
            state.getComboSeq().holdAction(player);
            if (!player.m_9236_().f_46443_ && 0 < (ticks = player.m_21252_()) && ticks == 20) {
                Vec3 pos = player.m_20299_(1.0f).m_82549_(player.m_20154_());
                ((ServerLevel)player.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123760_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 7, 0.7, 0.7, 0.7, 0.02);
            }
        });
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.m_6883_(stack, worldIn, entityIn, itemSlot, isSelected);
        if (!isSelected) {
            stack.getCapability(BLADESTATE).ifPresent(state -> {
                if (entityIn instanceof Player && ((Player)entityIn).m_21023_(MobEffects.f_19612_) && 0 < ((Player)entityIn).m_36324_().m_38702_()) {
                    int level = 1 + Math.abs(((LivingEntity)entityIn).m_21124_(MobEffects.f_19612_).m_19564_());
                    float amout = 4.0E-4f * (float)level;
                    ((Player)entityIn).m_36399_(0.005f * (float)level);
                    state.setDamage(state.getDamage() - amout);
                }
            });
            return;
        }
        if (stack == null) {
            return;
        }
        if (entityIn == null) {
            return;
        }
        stack.getCapability(BLADESTATE).ifPresent(state -> {
            if (entityIn instanceof LivingEntity) {
                entityIn.getCapability(INPUT_STATE).ifPresent(mInput -> mInput.getScheduler().onTick((LivingEntity)entityIn));
                state.resolvCurrentComboState((LivingEntity)entityIn).tickAction((LivingEntity)entityIn);
                state.sendChanges(entityIn);
            }
        });
    }

    @Nullable
    public CompoundTag getShareTag(ItemStack stack) {
        return stack.getCapability(BLADESTATE).filter(s -> s.getShareTag() != null).map(s -> {
            CompoundTag tag = s.getShareTag();
            tag.m_128359_("translationKey", s.getTranslationKey());
            if (tag.m_128471_("isBroken") != s.isBroken()) {
                tag.m_128359_("isBroken", Boolean.toString(s.isBroken()));
            }
            stack.m_41700_("ShareTag", (Tag)tag);
            return stack.m_41783_();
        }).orElseGet(() -> {
            CompoundTag tag = stack.getCapability(BLADESTATE).map(s -> NBTHelper.getNBTCoupler(stack.m_41784_()).getChild("ShareTag").put("translationKey", s.getTranslationKey()).put("isBroken", Boolean.toString(s.isBroken())).put("isNoScabbard", Boolean.toString(s.isNoScabbard())).getRawCompound()).orElseGet(() -> new CompoundTag());
            stack.getCapability(BLADESTATE).ifPresent(s -> s.setShareTag(tag));
            return stack.m_41783_();
        });
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundTag nbt) {
        super.readShareTag(stack, nbt);
        if (nbt == null) {
            return;
        }
        if (nbt.m_128441_(ICON_TAG_KEY)) {
            stack.deserializeNBT(nbt.m_128469_(ICON_TAG_KEY));
            return;
        }
    }

    int getHalfMaxdamage() {
        return this.m_41462_() / 2;
    }

    public int getDamage(ItemStack stack) {
        return this.getHalfMaxdamage();
    }

    public void setDamage(ItemStack stack, int damage) {
        if (damage == this.getHalfMaxdamage()) {
            return;
        }
        if (damage > stack.m_41776_()) {
            stack.m_41764_(2);
        }
        stack.getCapability(BLADESTATE).ifPresent(s -> {
            float amount = (float)(damage - this.getHalfMaxdamage()) / (float)this.m_41462_();
            s.setDamage(s.getDamage() + amount);
        });
    }

    public boolean isDamaged(ItemStack stack) {
        return stack.getCapability(BLADESTATE).map(s -> 0.0f < s.getDamage()).orElse(false);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return Math.min(amount, this.getHalfMaxdamage() / 2);
    }

    public boolean m_142522_(ItemStack stack) {
        return Minecraft.m_91087_().f_91074_.m_21205_() == stack;
    }

    public int m_142158_(ItemStack stack) {
        return Math.round(13.0f - 13.0f * stack.getCapability(BLADESTATE).map(s -> Float.valueOf(s.getDamage())).orElse(Float.valueOf(0.0f)).floatValue());
    }

    public int m_142159_(ItemStack stack) {
        boolean isBroken = stack.getCapability(BLADESTATE).filter(s -> s.isBroken()).isPresent();
        return isBroken ? 16737966 : 188654;
    }

    public String m_5671_(ItemStack stack) {
        return stack.getCapability(BLADESTATE).filter(s -> !s.getTranslationKey().isEmpty()).map(state -> state.getTranslationKey()).orElseGet(() -> super.m_5671_(stack));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static RecipeManager getClientRM() {
        ClientLevel cw = Minecraft.m_91087_().f_91073_;
        if (cw != null) {
            return cw.m_7465_();
        }
        return null;
    }

    public static RecipeManager getServerRM() {
        MinecraftServer sw = ServerLifecycleHooks.getCurrentServer();
        if (sw != null) {
            return sw.m_129894_();
        }
        return null;
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        if (Ingredient.m_204132_((TagKey)ItemTags.f_13165_).test(repair)) {
            return true;
        }
        return super.m_6832_(toRepair, repair);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        stack.getCapability(BLADESTATE).ifPresent(s -> {
            if (0 < s.getKillCount()) {
                tooltip.add((Component)Component.m_237110_((String)"slashblade.tooltip.killcount", (Object[])new Object[]{s.getKillCount()}));
            }
            if (0 < s.getRefine()) {
                tooltip.add((Component)Component.m_237110_((String)"slashblade.tooltip.refine", (Object[])new Object[]{s.getRefine()}).m_130940_((ChatFormatting)this.refineColor.get((Comparable)Integer.valueOf(s.getRefine()))));
            }
        });
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return !stack.getCapability(BLADESTATE).filter(s -> s.getLastActionTime() == entity.m_9236_().m_46467_()).isPresent();
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    @Nullable
    public Entity createEntity(Level world, Entity location, ItemStack itemstack) {
        BladeItemEntity e = new BladeItemEntity(SlashBlade.RegistryEvents.BladeItem, world);
        e.m_20361_(location);
        e.init();
        return e;
    }

    public int getEntityLifespan(ItemStack itemStack, Level world) {
        return super.getEntityLifespan(itemStack, world);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            BlockEntityWithoutLevelRenderer renderer = new SlashBladeTEISR(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_());

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return this.renderer;
            }
        });
        super.initializeClient(consumer);
    }

    private static /* synthetic */ void lambda$getAttributeModifiers$0(Multimap result, ISlashBladeState s) {
        float baseAttackModifier = s.getBaseAttackModifier();
        AttributeModifier base = new AttributeModifier(f_41374_, "Weapon modifier", (double)baseAttackModifier, AttributeModifier.Operation.ADDITION);
        result.remove((Object)Attributes.f_22281_, (Object)base);
        result.put((Object)Attributes.f_22281_, (Object)base);
        float rankAttackAmplifier = s.getAttackAmplifier();
        result.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(ATTACK_DAMAGE_AMPLIFIER, "Weapon amplifier", (double)rankAttackAmplifier, AttributeModifier.Operation.ADDITION));
        result.put((Object)((Attribute)ForgeMod.ENTITY_REACH.get()), (Object)new AttributeModifier(PLAYER_REACH_AMPLIFIER, "Reach amplifer", s.isBroken() ? ReachModifier.BrokendReach() : ReachModifier.BladeReach(), AttributeModifier.Operation.ADDITION));
    }
}

