/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.event.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class UserPoseOverrider {
    public static boolean UsePoseOverrider = false;
    private static final String TAG_ROT = "sb_yrot";
    private static final String TAG_ROT_PREV = "sb_yrot_prev";

    public static UserPoseOverrider getInstance() {
        return SingletonHolder.instance;
    }

    private UserPoseOverrider() {
    }

    public void register() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        UsePoseOverrider = true;
    }

    @SubscribeEvent
    public void onRenderPlayerEventPre(RenderLivingEvent.Pre event) {
        ItemStack stack = event.getEntity().m_21205_();
        if (stack.m_41619_()) {
            return;
        }
        if (!(stack.m_41720_() instanceof ItemSlashBlade)) {
            return;
        }
        float rot = event.getEntity().getPersistentData().m_128457_(TAG_ROT);
        float rotPrev = event.getEntity().getPersistentData().m_128457_(TAG_ROT_PREV);
        PoseStack matrixStackIn = event.getPoseStack();
        LivingEntity entityLiving = event.getEntity();
        float partialTicks = event.getPartialTick();
        float f = Mth.m_14189_((float)partialTicks, (float)entityLiving.f_20884_, (float)entityLiving.f_20883_);
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(180.0f - f));
        UserPoseOverrider.anotherPoseRotP(matrixStackIn, entityLiving, partialTicks);
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(Mth.m_14189_((float)partialTicks, (float)rot, (float)rotPrev)));
        UserPoseOverrider.anotherPoseRotN(matrixStackIn, entityLiving, partialTicks);
        matrixStackIn.m_252781_(Axis.f_252392_.m_252977_(180.0f - f));
    }

    public static void anotherPoseRotP(PoseStack matrixStackIn, LivingEntity entityLiving, float partialTicks) {
        boolean isPositive = true;
        float np = 1.0f;
        float f = entityLiving.m_20998_(partialTicks);
        if (entityLiving.m_21255_()) {
            float f1 = (float)entityLiving.m_21256_() + partialTicks;
            float f2 = Mth.m_14036_((float)(f1 * f1 / 100.0f), (float)0.0f, (float)1.0f);
            if (!entityLiving.m_21209_()) {
                matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(1.0f * f2 * (-90.0f - entityLiving.m_146909_())));
            }
            Vec3 vector3d = entityLiving.m_20252_(partialTicks);
            Vec3 vector3d1 = entityLiving.m_20184_();
            double d0 = vector3d1.m_165925_();
            double d1 = vector3d.m_165925_();
            if (d0 > 0.0 && d1 > 0.0) {
                double d2 = (vector3d1.f_82479_ * vector3d.f_82479_ + vector3d1.f_82481_ * vector3d.f_82481_) / Math.sqrt(d0 * d1);
                double d3 = vector3d1.f_82479_ * vector3d.f_82481_ - vector3d1.f_82481_ * vector3d.f_82479_;
                matrixStackIn.m_252781_(Axis.f_252436_.m_252961_((float)(1.0 * Math.signum(d3) * Math.acos(d2))));
            }
        } else if (f > 0.0f) {
            float f3 = entityLiving.m_20069_() ? -90.0f - entityLiving.m_146909_() : -90.0f;
            float f4 = Mth.m_14179_((float)f, (float)0.0f, (float)f3);
            matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(1.0f * f4));
            if (entityLiving.m_6067_()) {
                matrixStackIn.m_85837_(0.0, -1.0, (double)0.3f);
            }
        }
    }

    public static void anotherPoseRotN(PoseStack matrixStackIn, LivingEntity entityLiving, float partialTicks) {
        boolean isPositive = false;
        float np = -1.0f;
        float f = entityLiving.m_20998_(partialTicks);
        if (entityLiving.m_21255_()) {
            Vec3 vector3d = entityLiving.m_20252_(partialTicks);
            Vec3 vector3d1 = entityLiving.m_20184_();
            double d0 = vector3d1.m_165925_();
            double d1 = vector3d.m_165925_();
            if (d0 > 0.0 && d1 > 0.0) {
                double d2 = (vector3d1.f_82479_ * vector3d.f_82479_ + vector3d1.f_82481_ * vector3d.f_82481_) / Math.sqrt(d0 * d1);
                double d3 = vector3d1.f_82479_ * vector3d.f_82481_ - vector3d1.f_82481_ * vector3d.f_82479_;
                matrixStackIn.m_252781_(Axis.f_252436_.m_252961_((float)(-1.0 * Math.signum(d3) * Math.acos(d2))));
            }
            float f1 = (float)entityLiving.m_21256_() + partialTicks;
            float f2 = Mth.m_14036_((float)(f1 * f1 / 100.0f), (float)0.0f, (float)1.0f);
            if (!entityLiving.m_21209_()) {
                matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(-1.0f * f2 * (-90.0f - entityLiving.m_146909_())));
            }
        } else if (f > 0.0f) {
            if (entityLiving.m_6067_()) {
                matrixStackIn.m_85837_(0.0, 1.0, (double)-0.3f);
            }
            float f3 = entityLiving.m_20069_() ? -90.0f - entityLiving.m_146909_() : -90.0f;
            float f4 = Mth.m_14179_((float)f, (float)0.0f, (float)f3);
            matrixStackIn.m_252781_(Axis.f_252529_.m_252977_(-1.0f * f4));
        }
    }

    public static void setRot(Entity target, float rotYaw, boolean isOffset) {
        CompoundTag tag = target.getPersistentData();
        float prevRot = tag.m_128457_(TAG_ROT);
        tag.m_128350_(TAG_ROT_PREV, prevRot);
        if (isOffset) {
            rotYaw += prevRot;
        }
        tag.m_128350_(TAG_ROT, rotYaw);
    }

    public static void resetRot(Entity target) {
        CompoundTag tag = target.getPersistentData();
        tag.m_128350_(TAG_ROT_PREV, 0.0f);
        tag.m_128350_(TAG_ROT, 0.0f);
    }

    public static void invertRot(PoseStack matrixStack, Entity entity, float partialTicks) {
        float rot = entity.getPersistentData().m_128457_(TAG_ROT);
        float rotPrev = entity.getPersistentData().m_128457_(TAG_ROT_PREV);
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(Mth.m_14189_((float)partialTicks, (float)rot, (float)rotPrev)));
    }

    private static final class SingletonHolder {
        private static final UserPoseOverrider instance = new UserPoseOverrider();

        private SingletonHolder() {
        }
    }
}

