/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.event;

import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class KillCounter {
    public static KillCounter getInstance() {
        return SingletonHolder.instance;
    }

    private KillCounter() {
    }

    public void register() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingDeathEvent(LivingDeathEvent event) {
        Entity trueSource = event.getSource().m_7639_();
        if (!(trueSource instanceof LivingEntity)) {
            return;
        }
        ItemStack stack = ((LivingEntity)trueSource).m_21205_();
        if (stack.m_41619_()) {
            return;
        }
        if (!(stack.m_41720_() instanceof ItemSlashBlade)) {
            return;
        }
        stack.getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> state.setKillCount(state.getKillCount() + 1));
    }

    private static final class SingletonHolder {
        private static final KillCounter instance = new KillCounter();

        private SingletonHolder() {
        }
    }
}

