/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.event;

import mods.flammpfeil.slashblade.event.BladeMotionEvent;
import mods.flammpfeil.slashblade.network.MotionBroadcastMessage;
import mods.flammpfeil.slashblade.network.NetworkManager;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.PacketDistributor;

public class BladeMotionEventBroadcaster {
    public static BladeMotionEventBroadcaster getInstance() {
        return SingletonHolder.instance;
    }

    private BladeMotionEventBroadcaster() {
    }

    public void register() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onBladeMotion(BladeMotionEvent event) {
        if (!(event.getEntity() instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)event.getEntity();
        MotionBroadcastMessage msg = new MotionBroadcastMessage();
        msg.playerId = sp.m_20148_();
        msg.combo = event.getCombo().getName();
        NetworkManager.INSTANCE.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(sp.m_20185_(), sp.m_20186_(), sp.m_20189_(), 20.0, sp.m_284548_().m_46472_())), (Object)msg);
    }

    private static final class SingletonHolder {
        private static final BladeMotionEventBroadcaster instance = new BladeMotionEventBroadcaster();

        private SingletonHolder() {
        }
    }
}

