/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.event;

import java.util.List;
import java.util.Map;
import mods.flammpfeil.slashblade.event.AnvilCraftingRecipe;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class BladeComponentTooltips {
    public static BladeComponentTooltips getInstance() {
        return SingletonHolder.instance;
    }

    private BladeComponentTooltips() {
    }

    public void register() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onItemTooltipEvent(ItemTooltipEvent event) {
        List tooltip = event.getToolTip();
        ItemStack stack = event.getItemStack();
        AnvilCraftingRecipe recipe = AnvilCraftingRecipe.getRecipe(stack);
        if (recipe == null) {
            return;
        }
        ItemStack blade = ItemStack.f_41583_;
        boolean hasAnvil = false;
        if (event.getEntity() != null && event.getEntity().f_36096_ instanceof AnvilMenu) {
            hasAnvil = true;
            blade = event.getEntity().f_36096_.m_38853_(0).m_7993_();
        }
        tooltip.add(Component.m_237115_((String)"slashblade.tooltip.material").m_130940_(ChatFormatting.DARK_AQUA));
        tooltip.add(this.getRequirements("slashblade.tooltip.material.requiredobjects.anvil", hasAnvil, new Object[0]));
        tooltip.add(this.getRequirements(recipe.getTranslationKey(), recipe.getTranslationKey().equals(blade.m_41778_()), new Object[0]));
        if (0 < recipe.getKillcount()) {
            tooltip.add(this.getRequirements("slashblade.tooltip.material.killcount", blade.getCapability(ItemSlashBlade.BLADESTATE).filter(s -> recipe.getKillcount() <= s.getKillCount()).isPresent(), recipe.getKillcount()));
        }
        if (0 < recipe.getRefine()) {
            tooltip.add(this.getRequirements("slashblade.tooltip.material.refine", blade.getCapability(ItemSlashBlade.BLADESTATE).filter(s -> recipe.getRefine() <= s.getRefine()).isPresent(), recipe.getRefine()));
        }
        if (recipe.isBroken()) {
            tooltip.add(this.getRequirements("slashblade.tooltip.material.broken", blade.getCapability(ItemSlashBlade.BLADESTATE).filter(s -> s.isBroken()).isPresent(), new Object[0]));
        }
        if (recipe.isNoScabbard()) {
            tooltip.add(this.getRequirements("slashblade.tooltip.material.noscabbard", blade.getCapability(ItemSlashBlade.BLADESTATE).filter(s -> s.isNoScabbard()).isPresent(), new Object[0]));
        }
        if (0 < recipe.getEnchantments().size()) {
            tooltip.add(this.getRequirements("slashblade.tooltip.material.enchantments", this.checkEnchantments(recipe.getEnchantments(), blade), recipe.getLevel()));
        }
        if (0 < recipe.getLevel()) {
            tooltip.add(this.getRequirements("slashblade.tooltip.material.level", event.getEntity() != null && recipe.getLevel() <= event.getEntity().f_36078_, recipe.getLevel()));
        }
    }

    private boolean checkEnchantments(Map<Enchantment, Integer> requirements, ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        if (!stack.m_41793_()) {
            return false;
        }
        for (Map.Entry<Enchantment, Integer> entry : requirements.entrySet()) {
            if (entry.getValue() <= EnchantmentHelper.m_44843_((Enchantment)entry.getKey(), (ItemStack)stack)) continue;
            return false;
        }
        return true;
    }

    Component getRequirements(String key, boolean check, Object ... args) {
        MutableComponent tc = Component.m_237110_((String)key, (Object[])args);
        if (check) {
            tc = Component.m_237119_().m_7220_((Component)tc).m_130940_(ChatFormatting.GREEN);
        }
        return tc;
    }

    private static final class SingletonHolder {
        private static final BladeComponentTooltips instance = new BladeComponentTooltips();

        private SingletonHolder() {
        }
    }
}

