/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.event;

import com.google.common.collect.Maps;
import java.util.Map;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.util.NBTHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class AnvilCraftingRecipe {
    int level = 1;
    int killcount = 0;
    int refine = 0;
    boolean broken = false;
    boolean noScabbard = false;
    String translationKey = null;
    Map<Enchantment, Integer> Enchantments = Maps.newHashMap();
    ItemStack result = ItemStack.f_41583_;
    CompoundTag overwriteTag = null;

    public static AnvilCraftingRecipe getRecipe(ItemStack material) {
        if (!material.m_41782_()) {
            return null;
        }
        CompoundTag tag = material.m_41784_();
        if (!tag.m_128441_("RequiredBlade")) {
            return null;
        }
        AnvilCraftingRecipe recipe = new AnvilCraftingRecipe();
        recipe.readNBT(tag.m_128469_("RequiredBlade"));
        recipe.setEnchantments(EnchantmentHelper.m_44831_((ItemStack)material));
        return recipe;
    }

    public void readNBT(CompoundTag tag) {
        NBTHelper.getNBTCoupler(tag).get("level", this::setLevel, new Integer[0]).get("killCount", this::setKillcount, new Integer[0]).get("refine", this::setRefine, new Integer[0]).get("broken", this::setBroken, new Boolean[0]).get("noScabbard", this::setNoScabbard, new Boolean[0]).get("translationKey", this::setTranslationKey, new String[0]).get("result", this::setResultWithNBT, new CompoundTag[0]).get("overwriteTag", this::setOverwriteTag, new CompoundTag[0]);
    }

    public Tag writeNBT() {
        CompoundTag tag = new CompoundTag();
        NBTHelper.getNBTCoupler(tag).put("level", this.getLevel()).put("killCount", this.getKillcount()).put("refine", this.getRefine()).put("broken", this.isBroken()).put("noScabbard", this.isNoScabbard()).put("translationKey", this.getTranslationKey()).put("result", this.getResult().m_41739_(new CompoundTag())).put("overwriteTag", this.getOverwriteTag());
        return tag;
    }

    public boolean matches(ItemStack base) {
        if (base.m_41619_()) {
            return false;
        }
        if (!this.translationKey.isEmpty() && !base.m_41778_().equals(this.translationKey)) {
            return false;
        }
        if (this.needBlade()) {
            if (!(base.m_41720_() instanceof ItemSlashBlade)) {
                return false;
            }
            boolean stateMatches = base.getCapability(ItemSlashBlade.BLADESTATE).filter(state -> this.getKillcount() <= state.getKillCount() && this.getRefine() <= state.getRefine() && this.isNoScabbard() == state.isNoScabbard() && !((this.isBroken() ^ state.isBroken()) & this.isBroken())).isPresent();
            if (!stateMatches) {
                return false;
            }
        }
        if (!this.getEnchantments().isEmpty()) {
            for (Map.Entry<Enchantment, Integer> entry : this.getEnchantments().entrySet()) {
                if (EnchantmentHelper.m_44843_((Enchantment)entry.getKey(), (ItemStack)base) >= entry.getValue()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean needBlade() {
        return this.getKillcount() != 0 || this.getRefine() != 0 || this.broken || this.noScabbard;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public int getKillcount() {
        return this.killcount;
    }

    public void setKillcount(int killcount) {
        this.killcount = killcount;
    }

    public int getRefine() {
        return this.refine;
    }

    public void setRefine(int refine) {
        this.refine = refine;
    }

    public boolean isBroken() {
        return this.broken;
    }

    public void setBroken(boolean broken) {
        this.broken = broken;
    }

    public boolean isNoScabbard() {
        return this.noScabbard;
    }

    public void setNoScabbard(boolean noScabbard) {
        this.noScabbard = noScabbard;
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    public void setTranslationKey(String translationKey) {
        this.translationKey = translationKey;
    }

    public Map<Enchantment, Integer> getEnchantments() {
        return this.Enchantments;
    }

    public void setEnchantments(Map<Enchantment, Integer> enchantments) {
        this.Enchantments = enchantments;
    }

    public ItemStack getResult() {
        return this.result.m_41777_();
    }

    public ItemStack getResult(ItemStack base) {
        ItemStack result;
        if (this.isOnlyTagOverwrite()) {
            CompoundTag tag = base.m_41739_(new CompoundTag());
            tag.m_128391_(this.getOverwriteTag().m_6426_());
            result = ItemStack.m_41712_((CompoundTag)tag);
        } else {
            result = this.getResult();
            base.getCapability(ItemSlashBlade.BLADESTATE).ifPresent(oldState -> result.getCapability(ItemSlashBlade.BLADESTATE).ifPresent(newState -> {
                newState.setKillCount(oldState.getKillCount());
                newState.setRefine(oldState.getRefine());
            }));
            Map destMap = EnchantmentHelper.m_44831_((ItemStack)result);
            Map srcMap = EnchantmentHelper.m_44831_((ItemStack)base);
            for (Map.Entry srcEntry : srcMap.entrySet()) {
                Enchantment key = (Enchantment)srcEntry.getKey();
                int srcLevel = (Integer)srcEntry.getValue();
                if (destMap.containsKey(key)) {
                    int destLevel = (Integer)destMap.get(key);
                    if (destLevel >= srcLevel) continue;
                    destMap.put(key, srcLevel);
                    continue;
                }
                destMap.put(key, srcLevel);
            }
            EnchantmentHelper.m_44865_((Map)destMap, (ItemStack)result);
        }
        result.getShareTag();
        return result;
    }

    public void setResult(ItemStack result) {
        this.result = result;
    }

    public void setResultWithNBT(CompoundTag tag) {
        this.setResult(ItemStack.m_41712_((CompoundTag)tag));
    }

    public boolean isOnlyTagOverwrite() {
        return this.overwriteTag != null;
    }

    public CompoundTag getOverwriteTag() {
        return this.overwriteTag;
    }

    public void setOverwriteTag(CompoundTag overwriteTag) {
        this.overwriteTag = overwriteTag;
    }
}

