/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.entity;

import java.util.Optional;
import java.util.stream.Stream;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.ability.StunManager;
import mods.flammpfeil.slashblade.capability.inputstate.InputStateCapabilityProvider;
import mods.flammpfeil.slashblade.entity.EntityAbstractSummonedSword;
import mods.flammpfeil.slashblade.entity.IShootable;
import mods.flammpfeil.slashblade.entity.Projectile;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.util.InputCommand;
import mods.flammpfeil.slashblade.util.KnockBacks;
import mods.flammpfeil.slashblade.util.RayTraceHelper;
import mods.flammpfeil.slashblade.util.TargetSelector;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.PlayMessages;

public class EntityBlisteringSwords
extends EntityAbstractSummonedSword {
    private static final EntityDataAccessor<Boolean> IT_FIRED = SynchedEntityData.m_135353_(EntityBlisteringSwords.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    long fireTime = -1L;

    public EntityBlisteringSwords(EntityType<? extends Projectile> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
        this.setPierce((byte)5);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IT_FIRED, (Object)false);
    }

    public void doFire() {
        this.m_20088_().m_135381_(IT_FIRED, (Object)true);
    }

    public boolean itFired() {
        return (Boolean)this.m_20088_().m_135370_(IT_FIRED);
    }

    public static EntityBlisteringSwords createInstance(PlayMessages.SpawnEntity packet, Level worldIn) {
        return new EntityBlisteringSwords((EntityType<? extends Projectile>)SlashBlade.RegistryEvents.BlisteringSwords, worldIn);
    }

    @Override
    public void m_8119_() {
        if (!this.itFired() && this.m_9236_().f_46443_ && this.m_20202_() == null) {
            this.m_7998_(this.m_19749_(), true);
        }
        super.m_8119_();
    }

    public void m_6083_() {
        if (this.itFired() && this.fireTime <= (long)this.f_19797_) {
            this.faceEntityStandby();
            Entity vehicle = this.m_20202_();
            Vec3 dir = this.m_20252_(0.0f);
            if (!(vehicle instanceof LivingEntity)) {
                this.m_6686_(dir.f_82479_, dir.f_82480_, dir.f_82481_, 3.0f, 1.0f);
                return;
            }
            LivingEntity sender = (LivingEntity)this.m_20202_();
            this.m_8127_();
            this.f_19797_ = 0;
            Level worldIn = sender.m_9236_();
            Entity lockTarget = null;
            if (sender instanceof LivingEntity) {
                lockTarget = sender.m_21205_().getCapability(ItemSlashBlade.BLADESTATE).filter(state -> state.getTargetEntity(worldIn) != null).map(state -> state.getTargetEntity(worldIn)).orElse(null);
            }
            Optional<Entity> foundTarget = Stream.of(Optional.ofNullable(lockTarget), RayTraceHelper.rayTrace(sender.m_9236_(), (Entity)sender, sender.m_20299_(1.0f), sender.m_20154_(), 12.0, 12.0, e -> true).filter(r -> r.m_6662_() == HitResult.Type.ENTITY).filter(r -> {
                EntityHitResult er = (EntityHitResult)r;
                Entity target = ((EntityHitResult)r).m_82443_();
                boolean isMatch = true;
                if (target instanceof LivingEntity) {
                    isMatch = TargetSelector.lockon_focus.m_26885_(sender, (LivingEntity)target);
                }
                if (target instanceof IShootable) {
                    isMatch = ((IShootable)target).getShooter() != sender;
                }
                return isMatch;
            }).map(r -> ((EntityHitResult)r).m_82443_())).filter(Optional::isPresent).map(Optional::get).findFirst();
            Vec3 targetPos = foundTarget.map(e -> new Vec3(e.m_20185_(), e.m_20186_() + (double)e.m_20192_() * 0.5, e.m_20189_())).orElseGet(() -> {
                Vec3 start = sender.m_20299_(1.0f);
                Vec3 end = start.m_82549_(sender.m_20154_().m_82490_(40.0));
                BlockHitResult result = worldIn.m_45547_(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)sender));
                return result.m_82450_();
            });
            Vec3 pos = this.m_20318_(0.0f);
            dir = targetPos.m_82546_(pos).m_82541_();
            this.m_6686_(dir.f_82479_, dir.f_82480_, dir.f_82481_, 3.0f, 1.0f);
            if (sender instanceof ServerPlayer) {
                ((ServerPlayer)sender).m_6330_(SoundEvents.f_11893_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            return;
        }
        this.m_20256_(Vec3.f_82478_);
        if (this.canUpdate()) {
            this.m_6075_();
        }
        this.faceEntityStandby();
        if (!this.itFired() && this.m_20202_() instanceof LivingEntity) {
            LivingEntity owner = (LivingEntity)this.m_20202_();
            owner.getCapability(InputStateCapabilityProvider.INPUT_STATE).ifPresent(s -> {
                if (!s.getCommands().contains((Object)InputCommand.M_DOWN)) {
                    this.fireTime = this.f_19797_ + this.getDelay();
                    this.doFire();
                }
            });
        }
    }

    private void hitCheck() {
        Vec3 positionVec = this.m_20182_();
        Vec3 dirVec = this.m_20252_(1.0f);
        EntityHitResult raytraceresult = null;
        EntityHitResult entityraytraceresult = this.getRayTrace(positionVec, dirVec);
        if (entityraytraceresult != null) {
            raytraceresult = entityraytraceresult;
        }
        if (raytraceresult != null && raytraceresult.m_6662_() == HitResult.Type.ENTITY) {
            Entity entity = raytraceresult.m_82443_();
            Entity entity1 = this.getShooter();
            if (entity instanceof Player && entity1 instanceof Player && !((Player)entity1).m_7099_((Player)entity)) {
                raytraceresult = null;
                entityraytraceresult = null;
            }
        }
        if (raytraceresult != null && raytraceresult.m_6662_() == HitResult.Type.ENTITY && !ForgeEventFactory.onProjectileImpact((net.minecraft.world.entity.projectile.Projectile)this, (HitResult)raytraceresult)) {
            this.m_6532_((HitResult)raytraceresult);
            this.resetAlreadyHits();
            this.f_19812_ = true;
        }
    }

    private void faceEntityStandby() {
        int spawnNum = this.getDelay();
        boolean isRight = spawnNum % 2 == 0;
        int level = spawnNum / 2;
        Vec3 pos = new Vec3(0.0, 0.0, 0.0);
        if (this.m_20202_() == null) {
            this.doFire();
            return;
        }
        pos = pos.m_82549_(this.m_20202_().m_20182_()).m_82520_(0.0, (double)this.m_20202_().m_20192_() * 0.8, 0.0);
        double xOffset = (1.0 - 0.1 * (double)level) * (double)(isRight ? 1 : -1);
        double yOffset = 0.25 * (double)level;
        double zOffset = -0.1 * (double)level;
        Vec3 offset = new Vec3(xOffset, yOffset, zOffset);
        offset = offset.m_82496_((float)Math.toRadians(-this.m_20202_().m_146909_()));
        offset = offset.m_82524_((float)Math.toRadians(-this.m_20202_().m_146908_()));
        pos = pos.m_82549_(offset);
        this.f_19860_ = this.m_146909_();
        this.f_19859_ = this.m_146908_();
        this.m_146884_(pos);
        this.m_19915_(-this.m_20202_().m_146908_(), -this.m_20202_().m_146909_());
    }

    @Override
    protected void m_8060_(BlockHitResult blockraytraceresult) {
        this.burst();
    }

    @Override
    protected void m_5790_(EntityHitResult p_213868_1_) {
        Entity targetEntity = p_213868_1_.m_82443_();
        if (targetEntity instanceof LivingEntity) {
            KnockBacks.cancel.action.accept((LivingEntity)targetEntity);
            StunManager.setStun((LivingEntity)targetEntity);
        }
        super.m_5790_(p_213868_1_);
    }
}

