/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.client.renderer.model.obj;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import java.util.function.BiFunction;
import mods.flammpfeil.slashblade.client.renderer.model.obj.TextureCoordinate;
import mods.flammpfeil.slashblade.client.renderer.model.obj.Vertex;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.LazyLoadedValue;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class Face {
    public static boolean isSmoothShade = true;
    public static int lightmap = 15;
    public static final BiFunction<Vector4f, Integer, Integer> alphaNoOverride = (v, a) -> a;
    public static final BiFunction<Vector4f, Integer, Integer> alphaOverrideYZZ = (v, a) -> v.y() == 0.0f ? 0 : a;
    public static BiFunction<Vector4f, Integer, Integer> alphaOverride = alphaNoOverride;
    public static final Vector4f uvDefaultOperator;
    public static Vector4f uvOperator;
    public static Color col;
    private static final LazyLoadedValue<Matrix4f> defaultTransform;
    public static PoseStack matrix;
    public static boolean forceQuad;
    public Vertex[] vertices;
    public Vertex[] vertexNormals;
    public Vertex faceNormal;
    public TextureCoordinate[] textureCoordinates;

    public static void setLightMap(int value) {
        lightmap = value;
    }

    public static void resetLightMap() {
        lightmap = 15;
    }

    public static void setAlphaOverride(BiFunction<Vector4f, Integer, Integer> alphaOverride) {
        Face.alphaOverride = alphaOverride;
    }

    public static void resetAlphaOverride() {
        alphaOverride = alphaNoOverride;
    }

    public static void setUvOperator(float uScale, float vScale, float uOffset, float vOffset) {
        uvOperator = new Vector4f(uScale, vScale, uOffset, vOffset);
    }

    public static void resetUvOperator() {
        uvOperator = uvDefaultOperator;
    }

    public static void setCol(Color col) {
        Face.col = col;
    }

    public static void resetCol() {
        col = Color.white;
    }

    public static void setMatrix(PoseStack ms) {
        matrix = ms;
    }

    public static void resetMatrix() {
        matrix = null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addFaceForRender(VertexConsumer tessellator) {
        this.addFaceForRender(tessellator, 5.0E-4f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addFaceForRender(VertexConsumer tessellator, float textureOffset) {
        Matrix4f transform;
        if (this.faceNormal == null) {
            this.faceNormal = this.calculateFaceNormal();
        }
        float averageU = 0.0f;
        float averageV = 0.0f;
        if (this.textureCoordinates != null && this.textureCoordinates.length > 0) {
            for (int i = 0; i < this.textureCoordinates.length; ++i) {
                averageU += this.textureCoordinates[i].u * uvOperator.x() + uvOperator.z();
                averageV += this.textureCoordinates[i].v * uvOperator.y() + uvOperator.w();
            }
            averageU /= (float)this.textureCoordinates.length;
            averageV /= (float)this.textureCoordinates.length;
        }
        VertexConsumer wr = tessellator;
        if (matrix != null) {
            PoseStack.Pose me = matrix.m_85850_();
            transform = me.m_252922_();
        } else {
            transform = (Matrix4f)defaultTransform.m_13971_();
        }
        if (forceQuad) {
            this.putVertex(wr, 0, transform, textureOffset, averageU, averageV);
        }
        for (int i = 0; i < this.vertices.length; ++i) {
            this.putVertex(wr, i, transform, textureOffset, averageU, averageV);
        }
    }

    void putVertex(VertexConsumer wr, int i, Matrix4f transform, float textureOffset, float averageU, float averageV) {
        Vector3f vector3f;
        wr.m_252986_(transform, this.vertices[i].x, this.vertices[i].y, this.vertices[i].z);
        wr.m_6122_(col.getRed(), col.getGreen(), col.getBlue(), alphaOverride.apply(new Vector4f(this.vertices[i].x, this.vertices[i].y, this.vertices[i].z, 1.0f), col.getAlpha()).intValue());
        if (this.textureCoordinates != null && this.textureCoordinates.length > 0) {
            float offsetU = textureOffset;
            float offsetV = textureOffset;
            float textureU = this.textureCoordinates[i].u * uvOperator.x() + uvOperator.z();
            float textureV = this.textureCoordinates[i].v * uvOperator.y() + uvOperator.w();
            if (textureU > averageU) {
                offsetU = -offsetU;
            }
            if (textureV > averageV) {
                offsetV = -offsetV;
            }
            wr.m_7421_(textureU + offsetU, textureV + offsetV);
        } else {
            wr.m_7421_(0.0f, 0.0f);
        }
        wr.m_86008_(OverlayTexture.f_118083_);
        wr.m_85969_(lightmap);
        if (isSmoothShade && this.vertexNormals != null) {
            Vertex normal = this.vertexNormals[i];
            Vec3 nol = new Vec3((double)normal.x, (double)normal.y, (double)normal.z);
            vector3f = new Vector3f((float)nol.f_82479_, (float)nol.f_82480_, (float)nol.f_82481_);
        } else {
            vector3f = new Vector3f(this.faceNormal.x, this.faceNormal.y, this.faceNormal.z);
        }
        vector3f.mul((Matrix3fc)new Matrix3f((Matrix4fc)transform));
        vector3f.normalize();
        wr.m_5601_(vector3f.x(), vector3f.y(), vector3f.z());
        wr.m_5752_();
    }

    public Vertex calculateFaceNormal() {
        Vec3 v1 = new Vec3((double)(this.vertices[1].x - this.vertices[0].x), (double)(this.vertices[1].y - this.vertices[0].y), (double)(this.vertices[1].z - this.vertices[0].z));
        Vec3 v2 = new Vec3((double)(this.vertices[2].x - this.vertices[0].x), (double)(this.vertices[2].y - this.vertices[0].y), (double)(this.vertices[2].z - this.vertices[0].z));
        Vec3 normalVector = null;
        normalVector = v1.m_82537_(v2).m_82541_();
        return new Vertex((float)normalVector.f_82479_, (float)normalVector.f_82480_, (float)normalVector.f_82481_);
    }

    static {
        uvOperator = uvDefaultOperator = new Vector4f(1.0f, 1.0f, 0.0f, 0.0f);
        defaultTransform = new LazyLoadedValue(() -> {
            Matrix4f m = new Matrix4f();
            m.identity();
            return m;
        });
        matrix = null;
        forceQuad = false;
    }
}

