/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.capability.slashblade;

import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mods.flammpfeil.slashblade.capability.slashblade.ComboState;
import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import mods.flammpfeil.slashblade.capability.slashblade.RangeAttack;
import mods.flammpfeil.slashblade.capability.slashblade.SlashBladeState;
import mods.flammpfeil.slashblade.capability.slashblade.combo.Extra;
import mods.flammpfeil.slashblade.client.renderer.CarryType;
import mods.flammpfeil.slashblade.util.EnumSetConverter;
import mods.flammpfeil.slashblade.util.NBTHelper;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Rarity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;

public class BladeStateCapabilityProvider
implements ICapabilityProvider,
INBTSerializable<Tag> {
    public static final Capability<ISlashBladeState> CAP = CapabilityManager.get((CapabilityToken)new CapabilityToken<ISlashBladeState>(){});
    protected LazyOptional<ISlashBladeState> state = LazyOptional.of(SlashBladeState::new);
    @Deprecated
    private final String tagState = "State";

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return CAP.orEmpty(cap, this.state);
    }

    public Tag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        this.state.ifPresent(instance -> {
            tag.m_128356_("lastActionTime", instance.getLastActionTime());
            tag.m_128405_("TargetEntity", instance.getTargetEntityId());
            tag.m_128379_("_onClick", instance.onClick());
            tag.m_128350_("fallDecreaseRate", instance.getFallDecreaseRate());
            tag.m_128379_("isCharged", instance.isCharged());
            tag.m_128350_("AttackAmplifier", instance.getAttackAmplifier());
            tag.m_128359_("currentCombo", instance.getComboSeq().getName());
            tag.m_128359_("lastPosHash", instance.getLastPosHash());
            tag.m_128379_("HasShield", instance.hasShield());
            tag.m_128350_("Damage", instance.getDamage());
            tag.m_128379_("isBroken", instance.isBroken());
            tag.m_128379_("isNoScabbard", instance.isNoScabbard());
            tag.m_128379_("isSealed", instance.isSealed());
            tag.m_128350_("baseAttackModifier", instance.getBaseAttackModifier());
            tag.m_128405_("killCount", instance.getKillCount());
            tag.m_128405_("RepairCounter", instance.getRefine());
            UUID id = instance.getOwner();
            if (id != null) {
                tag.m_128362_("Owner", id);
            }
            UUID bladeId = instance.getUniqueId();
            tag.m_128362_("BladeUniqueId", bladeId);
            tag.m_128359_("RangeAttackType", instance.getRangeAttackType().getName());
            tag.m_128359_("SpecialAttackType", Optional.ofNullable(instance.getSlashArtsKey()).orElse("none"));
            tag.m_128379_("isDestructable", instance.isDestructable());
            tag.m_128379_("isDefaultBewitched", instance.isDefaultBewitched());
            tag.m_128344_("rarityType", (byte)instance.getRarity().ordinal());
            tag.m_128359_("translationKey", instance.getTranslationKey());
            tag.m_128344_("StandbyRenderType", (byte)instance.getCarryType().ordinal());
            tag.m_128405_("SummonedSwordColor", instance.getColorCode());
            tag.m_128379_("SummonedSwordColorInverse", instance.isEffectColorInverse());
            tag.m_128365_("adjustXYZ", (Tag)NBTHelper.newDoubleNBTList(instance.getAdjust()));
            instance.getTexture().ifPresent(loc -> tag.m_128359_("TextureName", loc.toString()));
            instance.getModel().ifPresent(loc -> tag.m_128359_("ModelName", loc.toString()));
            tag.m_128359_("ComboRoot", Optional.ofNullable(instance.getComboRoot()).map(c -> c.getName()).orElseGet(() -> Extra.STANDBY_EX.getName()));
            tag.m_128359_("ComboRootAir", Optional.ofNullable(instance.getComboRoot()).map(c -> c.getName()).orElseGet(() -> Extra.STANDBY_INAIR.getName()));
        });
        return tag;
    }

    public void deserializeNBT(Tag inTag) {
        Tag baseTag = inTag instanceof CompoundTag && ((CompoundTag)inTag).m_128441_("State") ? ((CompoundTag)inTag).m_128423_("State") : inTag;
        this.state.ifPresent(instance -> {
            CompoundTag tag = (CompoundTag)baseTag;
            instance.setLastActionTime(tag.m_128454_("lastActionTime"));
            instance.setTargetEntityId(tag.m_128451_("TargetEntity"));
            instance.setOnClick(tag.m_128471_("_onClick"));
            instance.setFallDecreaseRate(tag.m_128457_("fallDecreaseRate"));
            instance.setCharged(tag.m_128471_("isCharged"));
            instance.setAttackAmplifier(tag.m_128457_("AttackAmplifier"));
            instance.setComboSeq((ComboState)ComboState.NONE.valueOf(tag.m_128461_("currentCombo")));
            instance.setLastPosHash(tag.m_128461_("lastPosHash"));
            instance.setHasShield(tag.m_128471_("HasShield"));
            instance.setDamage(tag.m_128457_("Damage"));
            instance.setBroken(tag.m_128471_("isBroken"));
            instance.setHasChangedActiveState(true);
            instance.setNoScabbard(tag.m_128471_("isNoScabbard"));
            instance.setSealed(tag.m_128471_("isSealed"));
            instance.setBaseAttackModifier(tag.m_128457_("baseAttackModifier"));
            instance.setKillCount(tag.m_128451_("killCount"));
            instance.setRefine(tag.m_128451_("RepairCounter"));
            instance.setOwner(tag.m_128403_("Owner") ? tag.m_128342_("Owner") : null);
            instance.setUniqueId(tag.m_128403_("BladeUniqueId") ? tag.m_128342_("BladeUniqueId") : UUID.randomUUID());
            instance.setRangeAttackType((RangeAttack)RangeAttack.NONE.valueOf(tag.m_128461_("RangeAttackType")));
            instance.setSlashArtsKey(tag.m_128461_("SpecialAttackType"));
            instance.setDestructable(tag.m_128471_("isDestructable"));
            instance.setDefaultBewitched(tag.m_128471_("isDefaultBewitched"));
            instance.setRarity((Rarity)EnumSetConverter.fromOrdinal((Enum[])Rarity.values(), (int)tag.m_128445_("rarityType"), (Enum)Rarity.COMMON));
            instance.setTranslationKey(tag.m_128461_("translationKey"));
            instance.setCarryType((CarryType)EnumSetConverter.fromOrdinal((Enum[])CarryType.values(), (int)tag.m_128445_("StandbyRenderType"), (Enum)CarryType.DEFAULT));
            instance.setColorCode(tag.m_128451_("SummonedSwordColor"));
            instance.setEffectColorInverse(tag.m_128471_("SummonedSwordColorInverse"));
            instance.setAdjust(NBTHelper.getVector3d(tag, "adjustXYZ"));
            if (tag.m_128441_("TextureName")) {
                instance.setTexture(new ResourceLocation(tag.m_128461_("TextureName")));
            } else {
                instance.setTexture(null);
            }
            if (tag.m_128441_("ModelName")) {
                instance.setModel(new ResourceLocation(tag.m_128461_("ModelName")));
            } else {
                instance.setModel(null);
            }
            instance.setComboRootName(tag.m_128461_("ComboRoot"));
            instance.setComboRootAirName(tag.m_128461_("ComboRootAir"));
        });
    }
}

