/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.ability;

import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.capability.concentrationrank.CapabilityConcentrationRank;
import mods.flammpfeil.slashblade.capability.concentrationrank.IConcentrationRank;
import mods.flammpfeil.slashblade.capability.inputstate.CapabilityInputState;
import mods.flammpfeil.slashblade.entity.EntityAbstractSummonedSword;
import mods.flammpfeil.slashblade.entity.EntityBlisteringSwords;
import mods.flammpfeil.slashblade.entity.EntityHeavyRainSwords;
import mods.flammpfeil.slashblade.entity.EntitySpiralSwords;
import mods.flammpfeil.slashblade.entity.EntityStormSwords;
import mods.flammpfeil.slashblade.entity.IShootable;
import mods.flammpfeil.slashblade.entity.Projectile;
import mods.flammpfeil.slashblade.event.InputCommandEvent;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.util.AdvancementHelper;
import mods.flammpfeil.slashblade.util.InputCommand;
import mods.flammpfeil.slashblade.util.RayTraceHelper;
import mods.flammpfeil.slashblade.util.StatHelper;
import mods.flammpfeil.slashblade.util.TargetSelector;
import mods.flammpfeil.slashblade.util.VectorHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.timers.TimerCallback;
import net.minecraft.world.level.timers.TimerQueue;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class SummonedSwordArts {
    public static final ResourceLocation ADVANCEMENT_SUMMONEDSWORDS = new ResourceLocation("slashblade", "arts/shooting/summonedswords");
    public static final ResourceLocation ADVANCEMENT_SPIRAL_SWORDS = new ResourceLocation("slashblade", "arts/shooting/spiral_swords");
    public static final ResourceLocation ADVANCEMENT_STORM_SWORDS = new ResourceLocation("slashblade", "arts/shooting/storm_swords");
    public static final ResourceLocation ADVANCEMENT_BLISTERING_SWORDS = new ResourceLocation("slashblade", "arts/shooting/blistering_swords");
    public static final ResourceLocation ADVANCEMENT_HEAVY_RAIN_SWORDS = new ResourceLocation("slashblade", "arts/shooting/heavy_rain_swords");

    public static SummonedSwordArts getInstance() {
        return SingletonHolder.instance;
    }

    private SummonedSwordArts() {
    }

    public void register() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onInputChange(InputCommandEvent event) {
        EnumSet<InputCommand> old = event.getOld();
        EnumSet<InputCommand> current = event.getCurrent();
        ServerPlayer sender = event.getEntity();
        InputCommand targetCommnad = InputCommand.M_DOWN;
        boolean onDown = !old.contains((Object)targetCommnad) && current.contains((Object)targetCommnad);
        boolean onPress = current.contains((Object)targetCommnad);
        boolean onUp = old.contains((Object)targetCommnad) && !current.contains((Object)targetCommnad);
        final Long pressTime = event.getState().getLastPressTime(targetCommnad);
        if (onDown) {
            sender.getCapability(CapabilityInputState.INPUT_STATE).ifPresent(input -> {
                input.getScheduler().schedule("SpiralSwords", pressTime + 10L, new TimerCallback<LivingEntity>(){

                    public void handle(LivingEntity rawEntity, TimerQueue<LivingEntity> queue, long now) {
                        if (!(rawEntity instanceof ServerPlayer)) {
                            return;
                        }
                        ServerPlayer entity = (ServerPlayer)rawEntity;
                        InputCommand targetCommnad = InputCommand.M_DOWN;
                        boolean inputSucceed = entity.getCapability(CapabilityInputState.INPUT_STATE).filter(input -> input.getCommands().contains((Object)targetCommnad) && (!InputCommand.anyMatch(input.getCommands(), InputCommand.move) || !input.getCommands().contains((Object)InputCommand.SNEAK)) && input.getLastPressTime(targetCommnad) == pressTime.longValue()).isPresent();
                        if (!inputSucceed) {
                            return;
                        }
                        boolean alreadySummoned = entity.m_20197_().stream().anyMatch(e -> e instanceof EntitySpiralSwords);
                        if (alreadySummoned) {
                            List<Entity> list = entity.m_20197_().stream().filter(e -> e instanceof EntitySpiralSwords).toList();
                            list.stream().forEach(e -> ((EntitySpiralSwords)e).doFire());
                        } else {
                            entity.m_21205_().getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> {
                                if (entity.f_36078_ <= 0) {
                                    return;
                                }
                                entity.m_6756_(-5);
                                AdvancementHelper.grantCriterion(entity, ADVANCEMENT_SPIRAL_SWORDS);
                                Level worldIn = entity.m_9236_();
                                int rank = entity.getCapability(CapabilityConcentrationRank.RANK_POINT).map(r -> r.getRank((long)worldIn.m_46467_()).level).orElse(0);
                                int count = 6;
                                if (IConcentrationRank.ConcentrationRanks.S.level <= rank) {
                                    count = 8;
                                }
                                for (int i = 0; i < count; ++i) {
                                    EntitySpiralSwords ss = new EntitySpiralSwords((EntityType<? extends Projectile>)SlashBlade.RegistryEvents.SpiralSwords, worldIn);
                                    worldIn.m_7967_((Entity)ss);
                                    ss.m_5602_((Entity)entity);
                                    ss.setColor(state.getColorCode());
                                    ss.setRoll(0.0f);
                                    ss.m_7998_((Entity)entity, true);
                                    ss.setDelay(360 / count * i);
                                    entity.m_6330_(SoundEvents.f_11757_, SoundSource.PLAYERS, 0.2f, 1.45f);
                                }
                            });
                        }
                    }
                });
                input.getScheduler().schedule("StormSwords", pressTime + 10L, new TimerCallback<LivingEntity>(){

                    public void handle(LivingEntity rawEntity, TimerQueue<LivingEntity> queue, long now) {
                        if (!(rawEntity instanceof ServerPlayer)) {
                            return;
                        }
                        ServerPlayer entity = (ServerPlayer)rawEntity;
                        InputCommand targetCommnad = InputCommand.M_DOWN;
                        boolean inputSucceed = entity.getCapability(CapabilityInputState.INPUT_STATE).filter(input -> input.getCommands().contains((Object)targetCommnad) && input.getCommands().contains((Object)InputCommand.SNEAK) && input.getCommands().contains((Object)InputCommand.BACK) && !input.getCommands().contains((Object)InputCommand.FORWARD) && input.getLastPressTime(targetCommnad) == pressTime.longValue()).isPresent();
                        if (!inputSucceed) {
                            return;
                        }
                        entity.m_21205_().getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> {
                            Level worldIn = entity.m_9236_();
                            Entity target = state.getTargetEntity(worldIn);
                            if (target == null) {
                                return;
                            }
                            if (entity.f_36078_ <= 0) {
                                return;
                            }
                            entity.m_6756_(-5);
                            AdvancementHelper.grantCriterion(entity, ADVANCEMENT_STORM_SWORDS);
                            int rank = entity.getCapability(CapabilityConcentrationRank.RANK_POINT).map(r -> r.getRank((long)worldIn.m_46467_()).level).orElse(0);
                            int count = 6;
                            if (IConcentrationRank.ConcentrationRanks.S.level <= rank) {
                                count = 8;
                            }
                            for (int i = 0; i < count; ++i) {
                                EntityStormSwords ss = new EntityStormSwords((EntityType<? extends Projectile>)SlashBlade.RegistryEvents.StormSwords, worldIn);
                                worldIn.m_7967_((Entity)ss);
                                ss.m_5602_((Entity)entity);
                                ss.setColor(state.getColorCode());
                                ss.setRoll(0.0f);
                                ss.m_7998_(target, true);
                                ss.setDelay(360 / count * i);
                                entity.m_6330_(SoundEvents.f_11757_, SoundSource.PLAYERS, 0.2f, 1.45f);
                            }
                        });
                    }
                });
                input.getScheduler().schedule("BlisteringSwords", pressTime + 10L, new TimerCallback<LivingEntity>(){

                    public void handle(LivingEntity rawEntity, TimerQueue<LivingEntity> queue, long now) {
                        if (!(rawEntity instanceof ServerPlayer)) {
                            return;
                        }
                        ServerPlayer entity = (ServerPlayer)rawEntity;
                        InputCommand targetCommnad = InputCommand.M_DOWN;
                        boolean inputSucceed = entity.getCapability(CapabilityInputState.INPUT_STATE).filter(input -> input.getCommands().contains((Object)targetCommnad) && input.getCommands().contains((Object)InputCommand.SNEAK) && input.getCommands().contains((Object)InputCommand.FORWARD) && input.getLastPressTime(InputCommand.BACK) + 20L < now && input.getLastPressTime(targetCommnad) == pressTime.longValue()).isPresent();
                        if (!inputSucceed) {
                            return;
                        }
                        entity.m_21205_().getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> {
                            Level worldIn = entity.m_9236_();
                            if (entity.f_36078_ <= 0) {
                                return;
                            }
                            entity.m_6756_(-5);
                            AdvancementHelper.grantCriterion(entity, ADVANCEMENT_BLISTERING_SWORDS);
                            int rank = entity.getCapability(CapabilityConcentrationRank.RANK_POINT).map(r -> r.getRank((long)worldIn.m_46467_()).level).orElse(0);
                            int count = 6;
                            if (IConcentrationRank.ConcentrationRanks.S.level <= rank) {
                                count = 8;
                            }
                            for (int i = 0; i < count; ++i) {
                                EntityBlisteringSwords ss = new EntityBlisteringSwords((EntityType<? extends Projectile>)SlashBlade.RegistryEvents.BlisteringSwords, worldIn);
                                worldIn.m_7967_((Entity)ss);
                                ss.m_5602_((Entity)entity);
                                ss.setColor(state.getColorCode());
                                ss.setRoll(0.0f);
                                ss.m_7998_((Entity)entity, true);
                                ss.setDelay(i);
                                entity.m_6330_(SoundEvents.f_11757_, SoundSource.PLAYERS, 0.2f, 1.45f);
                            }
                        });
                    }
                });
                input.getScheduler().schedule("HeavyRainSwords", pressTime + 10L, new TimerCallback<LivingEntity>(){

                    public void handle(LivingEntity rawEntity, TimerQueue<LivingEntity> queue, long now) {
                        if (!(rawEntity instanceof ServerPlayer)) {
                            return;
                        }
                        ServerPlayer entity = (ServerPlayer)rawEntity;
                        InputCommand targetCommnad = InputCommand.M_DOWN;
                        boolean inputSucceed = entity.getCapability(CapabilityInputState.INPUT_STATE).filter(input -> input.getCommands().contains((Object)targetCommnad) && input.getCommands().contains((Object)InputCommand.SNEAK) && input.getCommands().contains((Object)InputCommand.FORWARD) && input.getLastPressTime(InputCommand.BACK) + 30L > now && input.getLastPressTime(targetCommnad) == pressTime.longValue()).isPresent();
                        if (!inputSucceed) {
                            return;
                        }
                        entity.m_21205_().getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> {
                            Vec3 basePos;
                            Level worldIn = entity.m_9236_();
                            Entity target = state.getTargetEntity(worldIn);
                            if (entity.f_36078_ <= 0) {
                                return;
                            }
                            entity.m_6756_(-5);
                            AdvancementHelper.grantCriterion(entity, ADVANCEMENT_HEAVY_RAIN_SWORDS);
                            int rank = entity.getCapability(CapabilityConcentrationRank.RANK_POINT).map(r -> r.getRank((long)worldIn.m_46467_()).level).orElse(0);
                            if (target != null) {
                                basePos = target.m_20182_();
                            } else {
                                Vec3 forwardDir = SummonedSwordArts.this.calculateViewVector(0.0f, entity.m_146908_());
                                basePos = entity.m_20318_(0.0f).m_82549_(forwardDir.m_82490_(5.0));
                            }
                            float yOffset = 7.0f;
                            basePos = basePos.m_82520_(0.0, (double)yOffset, 0.0);
                            EntityHeavyRainSwords ss = new EntityHeavyRainSwords((EntityType<? extends Projectile>)SlashBlade.RegistryEvents.HeavyRainSwords, worldIn);
                            worldIn.m_7967_((Entity)ss);
                            ss.m_5602_((Entity)entity);
                            ss.setColor(state.getColorCode());
                            ss.setRoll(0.0f);
                            ss.m_7998_((Entity)entity, true);
                            ss.setDelay(0);
                            ss.m_146884_(basePos);
                            ss.m_146926_(-90.0f);
                            int count = 9;
                            int multiplier = 2;
                            for (int i = 0; i < count; ++i) {
                                for (int l = 0; l < multiplier; ++l) {
                                    EntityHeavyRainSwords ss2 = new EntityHeavyRainSwords((EntityType<? extends Projectile>)SlashBlade.RegistryEvents.HeavyRainSwords, worldIn);
                                    worldIn.m_7967_((Entity)ss2);
                                    ss2.m_5602_((Entity)entity);
                                    ss2.setColor(state.getColorCode());
                                    ss2.setRoll(0.0f);
                                    ss2.m_7998_((Entity)entity, true);
                                    ss2.setDelay(i);
                                    ss2.setSpread(basePos);
                                    ss2.m_146926_(-90.0f);
                                    entity.m_6330_(SoundEvents.f_11757_, SoundSource.PLAYERS, 0.2f, 1.45f);
                                }
                            }
                        });
                    }
                });
            });
            sender.m_21205_().getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> {
                if (sender.f_36078_ <= 0) {
                    return;
                }
                sender.m_6756_(-1);
                AdvancementHelper.grantCriterion(sender, ADVANCEMENT_SUMMONEDSWORDS);
                Optional<Entity> foundTarget = Stream.of(Optional.ofNullable(state.getTargetEntity(sender.m_9236_())), RayTraceHelper.rayTrace(sender.m_9236_(), (Entity)sender, sender.m_20299_(1.0f), sender.m_20154_(), 12.0, 12.0, e -> true).filter(r -> r.m_6662_() == HitResult.Type.ENTITY).filter(r -> {
                    EntityHitResult er = (EntityHitResult)r;
                    Entity target = ((EntityHitResult)r).m_82443_();
                    boolean isMatch = true;
                    if (target instanceof LivingEntity) {
                        isMatch = TargetSelector.lockon_focus.m_26885_((LivingEntity)sender, (LivingEntity)target);
                    }
                    if (target instanceof IShootable) {
                        isMatch = ((IShootable)target).getShooter() != sender;
                    }
                    return isMatch;
                }).map(r -> ((EntityHitResult)r).m_82443_())).filter(Optional::isPresent).map(Optional::get).findFirst();
                Level worldIn = sender.m_9236_();
                Vec3 targetPos = foundTarget.map(e -> new Vec3(e.m_20185_(), e.m_20186_() + (double)e.m_20192_() * 0.5, e.m_20189_())).orElseGet(() -> {
                    Vec3 start = sender.m_20299_(1.0f);
                    Vec3 end = start.m_82549_(sender.m_20154_().m_82490_(40.0));
                    BlockHitResult result = worldIn.m_45547_(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)sender));
                    return result.m_82450_();
                });
                int counter = StatHelper.increase(sender, SlashBlade.RegistryEvents.SWORD_SUMMONED, 1);
                boolean sided = counter % 2 == 0;
                EntityAbstractSummonedSword ss = new EntityAbstractSummonedSword((EntityType<? extends Projectile>)SlashBlade.RegistryEvents.SummonedSword, worldIn);
                worldIn.m_7967_((Entity)ss);
                Vec3 pos = sender.m_20299_(1.0f).m_82549_(VectorHelper.getVectorForRotation(0.0f, sender.m_5675_(0.0f) + 90.0f).m_82490_(sided ? 1.0 : -1.0));
                ss.m_6034_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
                Vec3 dir = targetPos.m_82546_(pos).m_82541_();
                ss.m_6686_(dir.f_82479_, dir.f_82480_, dir.f_82481_, 3.0f, 0.0f);
                ss.m_5602_((Entity)sender);
                ss.setColor(state.getColorCode());
                ss.setRoll(sender.m_217043_().m_188501_() * 360.0f);
                sender.m_6330_(SoundEvents.f_11757_, SoundSource.PLAYERS, 0.2f, 1.45f);
            });
        }
    }

    Vec3 calculateViewVector(float x, float y) {
        float f = x * ((float)Math.PI / 180);
        float f1 = -y * ((float)Math.PI / 180);
        float f2 = Mth.m_14089_((float)f1);
        float f3 = Mth.m_14031_((float)f1);
        float f4 = Mth.m_14089_((float)f);
        float f5 = Mth.m_14031_((float)f);
        return new Vec3((double)(f3 * f4), (double)(-f5), (double)(f2 * f4));
    }

    private static final class SingletonHolder {
        private static final SummonedSwordArts instance = new SummonedSwordArts();

        private SingletonHolder() {
        }
    }
}

