/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade;

import com.google.common.base.CaseFormat;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import mods.flammpfeil.slashblade.ability.EnemyStep;
import mods.flammpfeil.slashblade.ability.Guard;
import mods.flammpfeil.slashblade.ability.KickJump;
import mods.flammpfeil.slashblade.ability.LockOnManager;
import mods.flammpfeil.slashblade.ability.SlayerStyleArts;
import mods.flammpfeil.slashblade.ability.StunManager;
import mods.flammpfeil.slashblade.ability.SummonedSwordArts;
import mods.flammpfeil.slashblade.ability.Untouchable;
import mods.flammpfeil.slashblade.capability.concentrationrank.CapabilityConcentrationRank;
import mods.flammpfeil.slashblade.capability.inputstate.CapabilityInputState;
import mods.flammpfeil.slashblade.capability.mobeffect.CapabilityMobEffect;
import mods.flammpfeil.slashblade.capability.slashblade.CapabilitySlashBlade;
import mods.flammpfeil.slashblade.client.renderer.LockonCircleRender;
import mods.flammpfeil.slashblade.client.renderer.entity.BladeItemEntityRenderer;
import mods.flammpfeil.slashblade.client.renderer.entity.BladeStandEntityRenderer;
import mods.flammpfeil.slashblade.client.renderer.entity.JudgementCutRenderer;
import mods.flammpfeil.slashblade.client.renderer.entity.PlacePreviewEntityRenderer;
import mods.flammpfeil.slashblade.client.renderer.entity.SlashEffectRenderer;
import mods.flammpfeil.slashblade.client.renderer.entity.SummonedSwordRenderer;
import mods.flammpfeil.slashblade.client.renderer.gui.RankRenderer;
import mods.flammpfeil.slashblade.client.renderer.model.BladeModel;
import mods.flammpfeil.slashblade.client.renderer.model.BladeModelManager;
import mods.flammpfeil.slashblade.client.renderer.model.BladeMotionManager;
import mods.flammpfeil.slashblade.entity.BladeItemEntity;
import mods.flammpfeil.slashblade.entity.BladeStandEntity;
import mods.flammpfeil.slashblade.entity.EntityAbstractSummonedSword;
import mods.flammpfeil.slashblade.entity.EntityBlisteringSwords;
import mods.flammpfeil.slashblade.entity.EntityHeavyRainSwords;
import mods.flammpfeil.slashblade.entity.EntityJudgementCut;
import mods.flammpfeil.slashblade.entity.EntitySlashEffect;
import mods.flammpfeil.slashblade.entity.EntitySpiralSwords;
import mods.flammpfeil.slashblade.entity.EntityStormSwords;
import mods.flammpfeil.slashblade.entity.PlacePreviewEntity;
import mods.flammpfeil.slashblade.event.AllowFlightOverrwrite;
import mods.flammpfeil.slashblade.event.AnvilCrafting;
import mods.flammpfeil.slashblade.event.BladeComponentTooltips;
import mods.flammpfeil.slashblade.event.BladeMaterialTooltips;
import mods.flammpfeil.slashblade.event.BladeMotionEventBroadcaster;
import mods.flammpfeil.slashblade.event.BlockPickCanceller;
import mods.flammpfeil.slashblade.event.CapabilityAttachHandler;
import mods.flammpfeil.slashblade.event.FallHandler;
import mods.flammpfeil.slashblade.event.KillCounter;
import mods.flammpfeil.slashblade.event.KnockBackHandler;
import mods.flammpfeil.slashblade.event.MoveInputHandler;
import mods.flammpfeil.slashblade.event.PlacePreviewEntryPoint;
import mods.flammpfeil.slashblade.event.RankPointHandler;
import mods.flammpfeil.slashblade.event.RefineHandler;
import mods.flammpfeil.slashblade.event.client.AdvancementsRecipeRenderer;
import mods.flammpfeil.slashblade.event.client.SneakingMotionCanceller;
import mods.flammpfeil.slashblade.event.client.UserPoseOverrider;
import mods.flammpfeil.slashblade.init.SBItems;
import mods.flammpfeil.slashblade.item.BladeStandItem;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.item.ItemSoulActivated;
import mods.flammpfeil.slashblade.item.ItemTierSlashBlade;
import mods.flammpfeil.slashblade.network.NetworkManager;
import mods.flammpfeil.slashblade.optional.playerAnim.PlayerAnimationOverrider;
import mods.flammpfeil.slashblade.util.TargetSelector;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.StatFormatter;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.LoaderUtil;
import org.jetbrains.annotations.Nullable;

@Mod(value="slashblade")
public class SlashBlade {
    public static final String modid = "slashblade";
    public static final CreativeModeTab SLASHBLADE = CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)"slashblade")).m_257737_(() -> {
        ItemStack stack = new ItemStack((ItemLike)SBItems.slashblade);
        stack.getCapability(ItemSlashBlade.BLADESTATE).ifPresent(s -> {
            s.setModel(new ResourceLocation(modid, "model/named/yamato.obj"));
            s.setTexture(new ResourceLocation(modid, "model/named/yamato.png"));
        });
        return stack;
    }).m_257501_(new CreativeModeTab.DisplayItemsGenerator(){

        public void m_257865_(CreativeModeTab.ItemDisplayParameters p_270258_, CreativeModeTab.Output p_259752_) {
            p_259752_.m_245282_((ItemLike)SBItems.slashblade, CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            p_259752_.m_245282_((ItemLike)SBItems.proudsoul, CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            p_259752_.m_245282_((ItemLike)SBItems.proudsoul_tiny, CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            p_259752_.m_245282_((ItemLike)SBItems.proudsoul_ingot, CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            p_259752_.m_245282_((ItemLike)SBItems.proudsoul_sphere, CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            p_259752_.m_245282_((ItemLike)SBItems.proudsoul_crystal, CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            p_259752_.m_245282_((ItemLike)SBItems.proudsoul_trapezohedron, CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            p_259752_.m_245282_((ItemLike)SBItems.proudsoul_activated, CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            p_259752_.m_245282_((ItemLike)SBItems.proudsoul_awakened, CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            p_259752_.m_245282_((ItemLike)SBItems.bladestand_1, CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            p_259752_.m_245282_((ItemLike)SBItems.bladestand_1w, CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            p_259752_.m_245282_((ItemLike)SBItems.bladestand_2, CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            p_259752_.m_245282_((ItemLike)SBItems.bladestand_2w, CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            p_259752_.m_245282_((ItemLike)SBItems.bladestand_s, CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            p_259752_.m_245282_((ItemLike)SBItems.bladestand_v, CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
            RecipeManager rm = (RecipeManager)DistExecutor.runForDist(() -> ItemSlashBlade::getClientRM, () -> ItemSlashBlade::getServerRM);
            if (rm == null) {
                return;
            }
            Set keys = rm.m_44073_().filter(loc -> loc.m_135827_().equals(SlashBlade.modid) && !loc.m_135815_().startsWith("material") && !loc.m_135815_().startsWith("bladestand") && !loc.m_135815_().startsWith("simple_slashblade")).collect(Collectors.toSet());
            List allItems = keys.stream().map(key -> rm.m_44043_(key).map(r -> {
                ItemStack stack = r.m_8043_(Minecraft.m_91087_().f_91073_.m_9598_()).m_41777_();
                stack.readShareTag(stack.getShareTag());
                return stack;
            }).orElseGet(() -> ItemStack.f_41583_)).sorted(Comparator.comparing(s -> ((ItemStack)s).m_41778_()).reversed()).collect(Collectors.toList());
            p_259752_.m_246233_(allItems, CreativeModeTab.TabVisibility.PARENT_TAB_ONLY);
        }
    }).m_257652_();
    public static final Logger LOGGER = LogManager.getLogger();

    public SlashBlade() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::Baked);
            MinecraftForge.EVENT_BUS.addListener(MoveInputHandler::onPlayerPostTick);
        });
        MinecraftForge.EVENT_BUS.register((Object)this);
        NetworkManager.register();
    }

    private void setup(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.addListener(KnockBackHandler::onLivingKnockBack);
        FallHandler.getInstance().register();
        LockOnManager.getInstance().register();
        Guard.getInstance().register();
        MinecraftForge.EVENT_BUS.register((Object)new CapabilityAttachHandler());
        MinecraftForge.EVENT_BUS.register((Object)new StunManager());
        AnvilCrafting.getInstance().register();
        RefineHandler.getInstance().register();
        KillCounter.getInstance().register();
        RankPointHandler.getInstance().register();
        AllowFlightOverrwrite.getInstance().register();
        BlockPickCanceller.getInstance().register();
        MinecraftForge.EVENT_BUS.addListener(TargetSelector::onInputChange);
        SummonedSwordArts.getInstance().register();
        SlayerStyleArts.getInstance().register();
        Untouchable.getInstance().register();
        EnemyStep.getInstance().register();
        KickJump.getInstance().register();
        PlacePreviewEntryPoint.getInstance().register();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void doClientStuff(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)BladeModelManager.getInstance());
        MinecraftForge.EVENT_BUS.register((Object)BladeMotionManager.getInstance());
        SneakingMotionCanceller.getInstance().register();
        if (LoaderUtil.isClassAvailable((String)"dev.kosmx.playerAnim.api.layered.AnimationStack")) {
            PlayerAnimationOverrider.getInstance().register();
        } else {
            UserPoseOverrider.getInstance().register();
        }
        LockonCircleRender.getInstance().register();
        BladeComponentTooltips.getInstance().register();
        BladeMaterialTooltips.getInstance().register();
        AdvancementsRecipeRenderer.getInstance().register();
        BladeMotionEventBroadcaster.getInstance().register();
        RankRenderer.getInstance().register();
        ItemProperties.register((Item)SBItems.slashblade, (ResourceLocation)new ResourceLocation("slashblade:user"), (ItemPropertyFunction)new ClampedItemPropertyFunction(){

            public float m_142187_(ItemStack p_174564_, @Nullable ClientLevel p_174565_, @Nullable LivingEntity p_174566_, int p_174567_) {
                BladeModel.user = p_174566_;
                return 0.0f;
            }
        });
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"examplemod", (String)"helloworld", () -> {
            LOGGER.info("Hello world from the MDK");
            return "Hello world";
        });
    }

    private void processIMC(InterModProcessEvent event) {
        LOGGER.info("Got IMC {}", event.getIMCStream().map(m -> m.getMessageSupplier().get()).collect(Collectors.toList()));
    }

    @OnlyIn(value=Dist.CLIENT)
    private void Baked(ModelEvent.ModifyBakingResult event) {
        ModelResourceLocation loc = new ModelResourceLocation(ForgeRegistries.ITEMS.getKey((Object)SBItems.slashblade), "inventory");
        BladeModel model = new BladeModel((BakedModel)event.getModels().get(loc), event.getModelBakery());
        event.getModels().put(loc, model);
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        public static final ResourceLocation BladeItemEntityLoc = new ResourceLocation("slashblade", RegistryEvents.classToString(BladeItemEntity.class));
        public static EntityType<BladeItemEntity> BladeItem;
        public static final ResourceLocation BladeStandEntityLoc;
        public static EntityType<BladeStandEntity> BladeStand;
        public static final ResourceLocation SummonedSwordLoc;
        public static EntityType<EntityAbstractSummonedSword> SummonedSword;
        public static final ResourceLocation SpiralSwordsLoc;
        public static EntityType<EntitySpiralSwords> SpiralSwords;
        public static final ResourceLocation StormSwordsLoc;
        public static EntityType<EntityStormSwords> StormSwords;
        public static final ResourceLocation BlisteringSwordsLoc;
        public static EntityType<EntityBlisteringSwords> BlisteringSwords;
        public static final ResourceLocation HeavyRainSwordsLoc;
        public static EntityType<EntityHeavyRainSwords> HeavyRainSwords;
        public static final ResourceLocation JudgementCutLoc;
        public static EntityType<EntityJudgementCut> JudgementCut;
        public static final ResourceLocation SlashEffectLoc;
        public static EntityType<EntitySlashEffect> SlashEffect;
        public static final ResourceLocation PlacePreviewEntityLoc;
        public static EntityType<PlacePreviewEntity> PlacePreview;
        public static ResourceLocation SWORD_SUMMONED;

        @SubscribeEvent
        public static void register(RegisterEvent event) {
            event.register(ForgeRegistries.Keys.ITEMS, helper -> {
                helper.register(new ResourceLocation(SlashBlade.modid, SlashBlade.modid), (Object)new ItemSlashBlade(new ItemTierSlashBlade(() -> {
                    TagKey tags = ItemTags.create((ResourceLocation)new ResourceLocation(SlashBlade.modid, "proudsouls"));
                    return Ingredient.m_204132_((TagKey)tags);
                }), 1, -2.4f, new Item.Properties()));
                helper.register(new ResourceLocation(SlashBlade.modid, "proudsoul"), (Object)new Item(new Item.Properties()){

                    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
                        if (entity instanceof BladeItemEntity) {
                            return false;
                        }
                        CompoundTag tag = entity.serializeNBT();
                        tag.m_128405_("Health", 50);
                        short age = tag.m_128448_("Age");
                        entity.deserializeNBT(tag);
                        if (entity.m_142038_()) {
                            entity.m_20256_(entity.m_20184_().m_82542_(0.8, 0.0, 0.8).m_82520_(0.0, 0.04, 0.0));
                        } else if (entity.m_6060_()) {
                            entity.m_20256_(entity.m_20184_().m_82542_(0.8, 0.5, 0.8).m_82520_(0.0, 0.04, 0.0));
                        }
                        return false;
                    }

                    public boolean m_5812_(ItemStack stack) {
                        return true;
                    }

                    public int getEnchantmentValue(ItemStack stack) {
                        return 50;
                    }
                });
                helper.register(new ResourceLocation(SlashBlade.modid, "proudsoul_ingot"), (Object)new Item(new Item.Properties()){

                    public boolean m_5812_(ItemStack stack) {
                        return true;
                    }

                    public int getEnchantmentValue(ItemStack stack) {
                        return 100;
                    }
                });
                helper.register(new ResourceLocation(SlashBlade.modid, "proudsoul_tiny"), (Object)new Item(new Item.Properties()){

                    public boolean m_5812_(ItemStack stack) {
                        return true;
                    }

                    public int getEnchantmentValue(ItemStack stack) {
                        return 10;
                    }
                });
                helper.register(new ResourceLocation(SlashBlade.modid, "proudsoul_sphere"), (Object)new Item(new Item.Properties().m_41497_(Rarity.UNCOMMON)){

                    public boolean m_5812_(ItemStack stack) {
                        return true;
                    }

                    public int getEnchantmentValue(ItemStack stack) {
                        return 150;
                    }
                });
                helper.register(new ResourceLocation(SlashBlade.modid, "proudsoul_crystal"), (Object)new Item(new Item.Properties().m_41497_(Rarity.RARE)){

                    public boolean m_5812_(ItemStack stack) {
                        return true;
                    }

                    public int getEnchantmentValue(ItemStack stack) {
                        return 200;
                    }
                });
                helper.register(new ResourceLocation(SlashBlade.modid, "proudsoul_trapezohedron"), (Object)new Item(new Item.Properties().m_41497_(Rarity.EPIC)){

                    public boolean m_5812_(ItemStack stack) {
                        return true;
                    }

                    public int getEnchantmentValue(ItemStack stack) {
                        return Integer.MAX_VALUE;
                    }

                    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
                        ItemStack itemstack = player.m_21120_(hand);
                        if (player.m_6047_()) {
                            level.m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_215762_, SoundSource.NEUTRAL, 1.5f, 1.0f);
                            return InteractionResultHolder.m_19092_((Object)ItemUtils.m_41813_((ItemStack)itemstack, (Player)player, (ItemStack)new ItemStack((ItemLike)SBItems.proudsoul_activated)), (boolean)level.m_5776_());
                        }
                        return InteractionResultHolder.m_19098_((Object)itemstack);
                    }
                });
                helper.register(new ResourceLocation(SlashBlade.modid, "proudsoul_activated"), (Object)new ItemSoulActivated(new Item.Properties().m_41487_(1).m_41497_(Rarity.EPIC)){

                    public boolean m_5812_(ItemStack stack) {
                        return true;
                    }

                    public int getEnchantmentValue(ItemStack stack) {
                        return Integer.MAX_VALUE;
                    }
                });
                helper.register(new ResourceLocation(SlashBlade.modid, "proudsoul_awakened"), (Object)new Item(new Item.Properties().m_41487_(1).m_41497_(Rarity.EPIC)){

                    public boolean m_5812_(ItemStack stack) {
                        return true;
                    }

                    public int getEnchantmentValue(ItemStack stack) {
                        return Integer.MAX_VALUE;
                    }

                    public boolean hasCraftingRemainingItem(ItemStack stack) {
                        return true;
                    }

                    public ItemStack getCraftingRemainingItem(ItemStack itemStack) {
                        return new ItemStack((ItemLike)SBItems.proudsoul_trapezohedron);
                    }
                });
                helper.register(new ResourceLocation(SlashBlade.modid, "bladestand_1"), (Object)new BladeStandItem(new Item.Properties().m_41497_(Rarity.COMMON)));
                helper.register(new ResourceLocation(SlashBlade.modid, "bladestand_2"), (Object)new BladeStandItem(new Item.Properties().m_41497_(Rarity.COMMON)));
                helper.register(new ResourceLocation(SlashBlade.modid, "bladestand_v"), (Object)new BladeStandItem(new Item.Properties().m_41497_(Rarity.COMMON)));
                helper.register(new ResourceLocation(SlashBlade.modid, "bladestand_s"), (Object)new BladeStandItem(new Item.Properties().m_41497_(Rarity.COMMON)));
                helper.register(new ResourceLocation(SlashBlade.modid, "bladestand_1w"), (Object)new BladeStandItem(new Item.Properties().m_41497_(Rarity.COMMON), true));
                helper.register(new ResourceLocation(SlashBlade.modid, "bladestand_2w"), (Object)new BladeStandItem(new Item.Properties().m_41497_(Rarity.COMMON), true));
            });
            event.register(ForgeRegistries.Keys.ENTITY_TYPES, helper -> {
                EntityType entity = SummonedSword = EntityType.Builder.m_20704_(EntityAbstractSummonedSword::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).setTrackingRange(4).setUpdateInterval(20).setCustomClientFactory(EntityAbstractSummonedSword::createInstance).m_20712_(SummonedSwordLoc.toString());
                helper.register(SummonedSwordLoc, (Object)entity);
                entity = StormSwords = EntityType.Builder.m_20704_(EntityStormSwords::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).setTrackingRange(4).setUpdateInterval(20).setCustomClientFactory(EntityStormSwords::createInstance).m_20712_(StormSwordsLoc.toString());
                helper.register(StormSwordsLoc, (Object)entity);
                entity = SpiralSwords = EntityType.Builder.m_20704_(EntitySpiralSwords::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).setTrackingRange(4).setUpdateInterval(20).setCustomClientFactory(EntitySpiralSwords::createInstance).m_20712_(SpiralSwordsLoc.toString());
                helper.register(SpiralSwordsLoc, (Object)entity);
                entity = BlisteringSwords = EntityType.Builder.m_20704_(EntityBlisteringSwords::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).setTrackingRange(4).setUpdateInterval(20).setCustomClientFactory(EntityBlisteringSwords::createInstance).m_20712_(BlisteringSwordsLoc.toString());
                helper.register(BlisteringSwordsLoc, (Object)entity);
                entity = HeavyRainSwords = EntityType.Builder.m_20704_(EntityHeavyRainSwords::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).setTrackingRange(4).setUpdateInterval(20).setCustomClientFactory(EntityHeavyRainSwords::createInstance).m_20712_(HeavyRainSwordsLoc.toString());
                helper.register(HeavyRainSwordsLoc, (Object)entity);
                entity = JudgementCut = EntityType.Builder.m_20704_(EntityJudgementCut::new, (MobCategory)MobCategory.MISC).m_20699_(2.5f, 2.5f).setTrackingRange(4).setUpdateInterval(20).setCustomClientFactory(EntityJudgementCut::createInstance).m_20712_(JudgementCutLoc.toString());
                helper.register(JudgementCutLoc, (Object)entity);
                entity = BladeItem = EntityType.Builder.m_20704_(BladeItemEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.25f, 0.25f).setTrackingRange(4).setUpdateInterval(20).setCustomClientFactory(BladeItemEntity::createInstanceFromPacket).m_20712_(BladeItemEntityLoc.toString());
                helper.register(BladeItemEntityLoc, (Object)entity);
                entity = BladeStand = EntityType.Builder.m_20704_(BladeStandEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).setTrackingRange(10).setUpdateInterval(20).setShouldReceiveVelocityUpdates(false).setCustomClientFactory(BladeStandEntity::createInstance).m_20712_(BladeStandEntityLoc.toString());
                helper.register(BladeStandEntityLoc, (Object)entity);
                entity = SlashEffect = EntityType.Builder.m_20704_(EntitySlashEffect::new, (MobCategory)MobCategory.MISC).m_20699_(3.0f, 3.0f).setTrackingRange(4).setUpdateInterval(20).setCustomClientFactory(EntitySlashEffect::createInstance).m_20712_(SlashEffectLoc.toString());
                helper.register(SlashEffectLoc, (Object)entity);
                entity = PlacePreview = EntityType.Builder.m_20704_(PlacePreviewEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).setTrackingRange(10).setUpdateInterval(20).setShouldReceiveVelocityUpdates(false).setCustomClientFactory(PlacePreviewEntity::createInstance).m_20712_(PlacePreviewEntityLoc.toString());
                helper.register(PlacePreviewEntityLoc, (Object)entity);
            });
            event.register(ForgeRegistries.Keys.STAT_TYPES, helper -> {
                SWORD_SUMMONED = RegistryEvents.registerCustomStat("sword_summoned");
            });
            Registry.m_122965_((Registry)BuiltInRegistries.f_279662_, (ResourceLocation)new ResourceLocation(SlashBlade.modid, SlashBlade.modid), (Object)SLASHBLADE);
        }

        private static String classToString(Class<? extends Entity> entityClass) {
            return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, entityClass.getSimpleName()).replace("entity_", "");
        }

        @SubscribeEvent
        public static void onRegisterRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerEntityRenderer(SummonedSword, SummonedSwordRenderer::new);
            event.registerEntityRenderer(StormSwords, SummonedSwordRenderer::new);
            event.registerEntityRenderer(SpiralSwords, SummonedSwordRenderer::new);
            event.registerEntityRenderer(BlisteringSwords, SummonedSwordRenderer::new);
            event.registerEntityRenderer(HeavyRainSwords, SummonedSwordRenderer::new);
            event.registerEntityRenderer(JudgementCut, JudgementCutRenderer::new);
            event.registerEntityRenderer(BladeItem, BladeItemEntityRenderer::new);
            event.registerEntityRenderer(BladeStand, BladeStandEntityRenderer::new);
            event.registerEntityRenderer(SlashEffect, SlashEffectRenderer::new);
            event.registerEntityRenderer(PlacePreview, PlacePreviewEntityRenderer::new);
        }

        @SubscribeEvent
        public static void onRegisterCapability(RegisterCapabilitiesEvent event) {
            CapabilitySlashBlade.register(event);
            CapabilityMobEffect.register(event);
            CapabilityInputState.register(event);
            CapabilityConcentrationRank.register(event);
        }

        private static ResourceLocation registerCustomStat(String name) {
            ResourceLocation resourcelocation = new ResourceLocation(SlashBlade.modid, name);
            Registry.m_122961_((Registry)BuiltInRegistries.f_256771_, (String)name, (Object)resourcelocation);
            Stats.f_12988_.m_12899_((Object)resourcelocation, StatFormatter.f_12873_);
            return resourcelocation;
        }

        static {
            BladeStandEntityLoc = new ResourceLocation(SlashBlade.modid, RegistryEvents.classToString(BladeStandEntity.class));
            SummonedSwordLoc = new ResourceLocation(SlashBlade.modid, RegistryEvents.classToString(EntityAbstractSummonedSword.class));
            SpiralSwordsLoc = new ResourceLocation(SlashBlade.modid, RegistryEvents.classToString(EntitySpiralSwords.class));
            StormSwordsLoc = new ResourceLocation(SlashBlade.modid, RegistryEvents.classToString(EntityStormSwords.class));
            BlisteringSwordsLoc = new ResourceLocation(SlashBlade.modid, RegistryEvents.classToString(EntityBlisteringSwords.class));
            HeavyRainSwordsLoc = new ResourceLocation(SlashBlade.modid, RegistryEvents.classToString(EntityHeavyRainSwords.class));
            JudgementCutLoc = new ResourceLocation(SlashBlade.modid, RegistryEvents.classToString(EntityJudgementCut.class));
            SlashEffectLoc = new ResourceLocation(SlashBlade.modid, RegistryEvents.classToString(EntitySlashEffect.class));
            PlacePreviewEntityLoc = new ResourceLocation(SlashBlade.modid, RegistryEvents.classToString(PlacePreviewEntity.class));
        }
    }
}

