/*
 * Decompiled with CFR 0.152.
 */
package cn.mmf.slashblade_addon.item;

import baguchan.tofucraft.api.tfenergy.IEnergyContained;
import baguchan.tofucraft.api.tfenergy.IEnergyExtractable;
import baguchan.tofucraft.api.tfenergy.IEnergyInsertable;
import java.awt.Color;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Consumer;
import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import mods.flammpfeil.slashblade.capability.slashblade.SimpleBladeStateCapabilityProvider;
import mods.flammpfeil.slashblade.init.DefaultResources;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.item.SwordType;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TofuSlashBladeItem
extends ItemSlashBlade
implements IEnergyContained,
IEnergyExtractable,
IEnergyInsertable {
    private ResourceLocation model;
    private ResourceLocation texture;
    private final float baseAttack;
    public final int tfMax;

    public TofuSlashBladeItem(Tier tier, int attackDamageIn, float attackSpeedIn, int tfMax, Item.Properties builder) {
        super(tier, attackDamageIn, attackSpeedIn, builder);
        this.tfMax = tfMax;
        this.baseAttack = attackDamageIn;
        this.model = DefaultResources.resourceDefaultModel;
        this.texture = DefaultResources.resourceDefaultTexture;
    }

    public void appendSlashArt(ItemStack stack, List<Component> tooltip, @NotNull ISlashBladeState s) {
        super.appendSlashArt(stack, tooltip, s);
    }

    public int getEnergy(ItemStack inst) {
        return inst.m_41783_() != null && inst.m_41783_().m_128441_("tf_energy") ? inst.m_41783_().m_128451_("tf_energy") : 0;
    }

    public int getEnergyMax(ItemStack inst) {
        return this.tfMax;
    }

    public void setEnergy(ItemStack inst, int amount) {
        inst.m_41784_().m_128405_("tf_energy", amount);
    }

    public void setEnergyMax(ItemStack inst, int amount) {
    }

    private boolean getShowState(ItemStack stack) {
        Minecraft mcinstance = Minecraft.m_91087_();
        return mcinstance.f_91074_ != null && mcinstance.f_91074_.m_6144_() && this.getEnergy(stack) != 0;
    }

    public boolean m_142522_(ItemStack p_150899_) {
        return this.getShowState(p_150899_) || super.m_142522_(p_150899_);
    }

    public int m_142158_(ItemStack stack) {
        return this.getShowState(stack) ? Math.round((float)this.getEnergy(stack) / (float)this.getEnergyMax(stack) * 13.0f) : super.m_142158_(stack);
    }

    public int m_142159_(ItemStack p_150901_) {
        return this.getShowState(p_150901_) ? Color.white.getRGB() : super.m_142159_(p_150901_);
    }

    public void m_7373_(ItemStack p_41421_, @Nullable Level p_41422_, List<Component> p_41423_, TooltipFlag p_41424_) {
        super.m_7373_(p_41421_, p_41422_, p_41423_, p_41424_);
        p_41423_.add((Component)Component.m_237110_((String)"tooltip.tofucraft.energy", (Object[])new Object[]{this.getEnergy(p_41421_), this.getEnergyMax(p_41421_)}));
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        if (this.getEnergy(stack) > 0 && amount > 0) {
            int damage = amount - this.drain(stack, amount, false);
            return super.damageItem(stack, damage, entity, onBroken);
        }
        return super.damageItem(stack, amount, entity, onBroken);
    }

    public int fill(ItemStack inst, int energy, boolean simulate) {
        int calculated = Math.min(energy, inst.m_41773_());
        if (!simulate) {
            if (inst.m_41773_() > 0) {
                inst.m_41721_(Mth.m_14045_((int)(inst.m_41773_() - calculated), (int)0, (int)inst.m_41776_()));
                return calculated * 5;
            }
            int calculated2 = Math.min(energy, this.getEnergyMax(inst) - this.getEnergy(inst));
            this.setEnergy(inst, this.getEnergy(inst) + calculated2);
            return calculated2;
        }
        return 0;
    }

    public int drain(ItemStack inst, int amount, boolean simulate) {
        if (!simulate) {
            int calculated2 = Math.min(this.getEnergy(inst), amount);
            this.setEnergy(inst, this.getEnergy(inst) - calculated2);
            return calculated2;
        }
        return 0;
    }

    public void appendSwordType(ItemStack stack, @javax.annotation.Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        EnumSet swordType = SwordType.from((ItemStack)stack);
        if (swordType.contains(SwordType.BEWITCHED)) {
            tooltip.add((Component)Component.m_237115_((String)"slashblade.sword_type.bewitched").m_130940_(ChatFormatting.DARK_PURPLE));
        } else if (swordType.contains(SwordType.ENCHANTED)) {
            tooltip.add((Component)Component.m_237115_((String)"slashblade.sword_type.enchanted").m_130940_(ChatFormatting.DARK_AQUA));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"slashblade.sword_type.noname").m_130940_(ChatFormatting.DARK_GRAY));
        }
    }

    public ResourceLocation getModel() {
        return this.model;
    }

    public TofuSlashBladeItem setModel(ResourceLocation model) {
        this.model = model;
        return this;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public TofuSlashBladeItem setTexture(ResourceLocation texture) {
        this.texture = texture;
        return this;
    }

    public boolean isDestructable(ItemStack stack) {
        return false;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new SimpleBladeStateCapabilityProvider(stack, this.model, this.texture, this.baseAttack, this.m_43314_().m_6609_());
    }
}

