/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.temp;

import com.robertx22.mine_and_slash.database.data.game_balance_config.GameBalanceConfig;
import com.robertx22.mine_and_slash.database.data.level_ranges.LevelRange;
import com.robertx22.mine_and_slash.database.registrators.LevelRanges;
import java.util.Arrays;
import java.util.Comparator;
import net.minecraft.ChatFormatting;

public enum SkillItemTier {
    TIER0("Spiritual", "common", LevelRanges.STARTER_0, 0.0f, 0, 1.0f, ChatFormatting.GRAY, 300, 20.0f, 50),
    TIER1("Celestial", "uncommon", LevelRanges.LOW_1, 0.2f, 1, 1.25f, ChatFormatting.GREEN, 360, 25.0f, 100),
    TIER2("Empyrean", "rare", LevelRanges.MIDDLE_2, 0.4f, 2, 1.5f, ChatFormatting.BLUE, 420, 30.0f, 200),
    TIER3("Angelic", "epic", LevelRanges.HIGH_3, 0.6f, 3, 1.75f, ChatFormatting.LIGHT_PURPLE, 480, 40.0f, 300),
    TIER4("Divine", "legendary", LevelRanges.ENDGAME_4, 0.8f, 4, 2.0f, ChatFormatting.GOLD, 600, 50.0f, 500),
    TIER5("Godly", "mythic", LevelRanges.MAX_5, 1.0f, 5, 2.5f, ChatFormatting.DARK_PURPLE, 900, 50.0f, 1000);

    public LevelRange levelRange;
    public float lvl_req;
    public String word;
    public String rar;
    public int tier;
    public float statMulti;
    public ChatFormatting format;
    public int durationSeconds;
    public int repairDurab;
    public float percent_healed;

    private SkillItemTier(String word, String rar, LevelRange levelRange, float lvl_req, int tier, float statMulti, ChatFormatting format, int durationseconds, float percent_healed, int repairDurab) {
        this.word = word;
        this.tier = tier;
        this.rar = rar;
        this.statMulti = statMulti;
        this.format = format;
        this.repairDurab = repairDurab;
        this.percent_healed = percent_healed;
        this.durationSeconds = durationseconds;
        this.lvl_req = lvl_req;
        this.levelRange = levelRange;
    }

    public int getDisplayTierNumber() {
        return this.tier;
    }

    public static SkillItemTier of(int tier) {
        return Arrays.stream(SkillItemTier.values()).filter(x -> x.tier == tier).findAny().orElse(TIER0);
    }

    public static SkillItemTier ofRarity(String rar) {
        return Arrays.stream(SkillItemTier.values()).filter(x -> x.rar.equals(rar)).findAny().orElse(TIER0);
    }

    public static SkillItemTier fromLevel(int lvl) {
        if (lvl < 1) {
            lvl = 1;
        }
        if (lvl > GameBalanceConfig.get().MAX_LEVEL) {
            lvl = GameBalanceConfig.get().MAX_LEVEL;
        }
        int finalLvl = lvl;
        return Arrays.stream(SkillItemTier.values()).filter(x -> {
            int minlvl = x.levelRange.getMinLevel();
            return finalLvl >= minlvl;
        }).max(Comparator.comparingInt(x -> x.tier)).orElseGet(() -> TIER0);
    }

    public SkillItemTier lowerTier() {
        if (this == TIER0) {
            return null;
        }
        if (this == TIER1) {
            return TIER0;
        }
        if (this == TIER2) {
            return TIER1;
        }
        if (this == TIER3) {
            return TIER2;
        }
        if (this == TIER4) {
            return TIER3;
        }
        if (this == TIER5) {
            return TIER4;
        }
        return null;
    }

    public SkillItemTier higherTier() {
        if (this == TIER0) {
            return TIER1;
        }
        if (this == TIER1) {
            return TIER2;
        }
        if (this == TIER2) {
            return TIER3;
        }
        if (this == TIER3) {
            return TIER4;
        }
        if (this == TIER4) {
            return TIER5;
        }
        return null;
    }
}

