/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.vanilla_mc.packets.spells;

import com.robertx22.library_of_exile.main.MyPacket;
import com.robertx22.library_of_exile.packets.ExilePacketContext;
import com.robertx22.mine_and_slash.capability.entity.CooldownsData;
import com.robertx22.mine_and_slash.capability.player.PlayerData;
import com.robertx22.mine_and_slash.capability.player.data.PlayerConfigData;
import com.robertx22.mine_and_slash.database.data.profession.ExplainedResult;
import com.robertx22.mine_and_slash.database.data.spells.components.Spell;
import com.robertx22.mine_and_slash.database.data.spells.spell_classes.bases.SpellCastContext;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.localization.Chats;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class TellServerToCastSpellPacket
extends MyPacket<TellServerToCastSpellPacket> {
    int number;

    public TellServerToCastSpellPacket(int number) {
        this.number = number;
    }

    public TellServerToCastSpellPacket() {
    }

    public ResourceLocation getIdentifier() {
        return new ResourceLocation("mmorpg", "tell_server_castspell");
    }

    public void loadFromData(FriendlyByteBuf tag) {
        this.number = tag.readInt();
    }

    public void saveToData(FriendlyByteBuf tag) {
        tag.writeInt(this.number);
    }

    public static boolean tryCastSpell(Player player, Spell spell) {
        PlayerData data = Load.player(player);
        if (player.m_21254_() || player.f_20911_) {
            return false;
        }
        if (spell != null) {
            ExplainedResult can = data.spellCastingData.canCast(spell, player);
            if (can.can) {
                SpellCastContext c = new SpellCastContext((LivingEntity)player, 0, spell);
                data.spellCastingData.setToCast(c);
                spell.spendResources(c);
                data.playerDataSync.setDirty();
                return true;
            }
            CooldownsData cds = Load.Unit((Entity)player).getCooldowns();
            if (!cds.isOnCooldown("spell_fail")) {
                cds.setOnCooldown("spell_fail", 40);
                if (can.answer != null && (Load.Unit((Entity)player).getLevel() < 15 || Load.player((Player)player).config.isConfigEnabled(PlayerConfigData.Config.CAST_FAIL))) {
                    player.m_213846_((Component)Chats.CAST_FAILED.locName().m_7220_(can.answer));
                }
            }
        }
        return false;
    }

    public void onReceived(ExilePacketContext ctx) {
        Player player = ctx.getPlayer();
        Spell spell = Load.player(ctx.getPlayer()).getSkillGemInventory().getHotbarGem(this.number).getSpell();
        TellServerToCastSpellPacket.tryCastSpell(player, spell);
    }

    public MyPacket<TellServerToCastSpellPacket> newInstance() {
        return new TellServerToCastSpellPacket();
    }
}

