/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.vanilla_mc.packets;

import com.robertx22.library_of_exile.main.MyPacket;
import com.robertx22.library_of_exile.packets.ExilePacketContext;
import com.robertx22.mine_and_slash.capability.player.PlayerData;
import com.robertx22.mine_and_slash.database.data.game_balance_config.PlayerPointsType;
import com.robertx22.mine_and_slash.database.data.stats.Stat;
import com.robertx22.mine_and_slash.database.data.stats.datapacks.stats.CoreStat;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class AllocateStatPacket
extends MyPacket<AllocateStatPacket> {
    public String stat;
    ACTION action;

    public AllocateStatPacket() {
    }

    public AllocateStatPacket(Stat stat, ACTION act) {
        this.stat = stat.GUID();
        this.action = act;
    }

    public ResourceLocation getIdentifier() {
        return new ResourceLocation("mmorpg", "stat_alloc");
    }

    public void loadFromData(FriendlyByteBuf tag) {
        this.stat = tag.m_130136_(30);
        this.action = (ACTION)tag.m_130066_(ACTION.class);
    }

    public void saveToData(FriendlyByteBuf tag) {
        tag.m_130072_(this.stat, 30);
        tag.m_130068_((Enum)this.action);
    }

    public void onReceived(ExilePacketContext ctx) {
        int current;
        Load.Unit((Entity)ctx.getPlayer()).setEquipsChanged();
        PlayerData cap = Load.player(ctx.getPlayer());
        if (this.action == ACTION.ALLOCATE) {
            if (PlayerPointsType.STATS.getFreePoints(ctx.getPlayer()) > 0 && ExileDB.Stats().get(this.stat) instanceof CoreStat) {
                cap.statPoints.map.put(this.stat, 1 + cap.statPoints.map.getOrDefault(this.stat, 0));
            }
        } else if (PlayerPointsType.STATS.getResetPoints(ctx.getPlayer()) > 0 && ExileDB.Stats().get(this.stat) instanceof CoreStat && (current = cap.statPoints.map.getOrDefault(this.stat, 0).intValue()) > 0) {
            cap.statPoints.map.put(this.stat, current - 1);
        }
        Load.Unit((Entity)ctx.getPlayer()).setEquipsChanged();
        cap.playerDataSync.setDirty();
    }

    public MyPacket<AllocateStatPacket> newInstance() {
        return new AllocateStatPacket();
    }

    public static enum ACTION {
        ALLOCATE,
        REMOVE;

    }
}

