/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.vanilla_mc.items.gemrunes;

import com.robertx22.library_of_exile.registry.ExileRegistry;
import com.robertx22.library_of_exile.registry.IGUID;
import com.robertx22.library_of_exile.registry.IWeighted;
import com.robertx22.library_of_exile.vanilla_util.main.VanillaUTIL;
import com.robertx22.mine_and_slash.aoe_data.datapacks.models.IAutoModel;
import com.robertx22.mine_and_slash.aoe_data.datapacks.models.ItemModelManager;
import com.robertx22.mine_and_slash.database.data.MinMax;
import com.robertx22.mine_and_slash.database.data.StatMod;
import com.robertx22.mine_and_slash.database.data.currency.IItemAsCurrency;
import com.robertx22.mine_and_slash.database.data.currency.base.Currency;
import com.robertx22.mine_and_slash.database.data.currency.base.GearCurrency;
import com.robertx22.mine_and_slash.database.data.currency.base.GearOutcome;
import com.robertx22.mine_and_slash.database.data.currency.loc_reqs.LocReqContext;
import com.robertx22.mine_and_slash.database.data.game_balance_config.GameBalanceConfig;
import com.robertx22.mine_and_slash.database.data.gear_types.bases.SlotFamily;
import com.robertx22.mine_and_slash.database.data.profession.ExplainedResult;
import com.robertx22.mine_and_slash.database.data.runes.Rune;
import com.robertx22.mine_and_slash.database.data.runewords.RuneWord;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.gui.texts.ExileTooltips;
import com.robertx22.mine_and_slash.gui.texts.textblocks.AdditionalBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.OperationTipBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.StatBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.WorksOnBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.dropblocks.DropChanceBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.dropblocks.DropLevelBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.usableitemblocks.UsageBlock;
import com.robertx22.mine_and_slash.loot.blueprints.bases.RunePart;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_parts.SocketData;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.interfaces.IAutoLocName;
import com.robertx22.mine_and_slash.uncommon.interfaces.IBaseAutoLoc;
import com.robertx22.mine_and_slash.uncommon.localization.Chats;
import com.robertx22.mine_and_slash.uncommon.localization.Itemtips;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.ClientOnly;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.TooltipUtils;
import com.robertx22.mine_and_slash.vanilla_mc.LuckyRandom;
import com.robertx22.mine_and_slash.vanilla_mc.items.gemrunes.RuneType;
import com.robertx22.mine_and_slash.vanilla_mc.packets.proxies.OpenGuiWrapper;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class RuneItem
extends Item
implements IGUID,
IAutoModel,
IAutoLocName,
IWeighted,
IItemAsCurrency {
    public int weight = 1000;
    public RuneType type;

    @Override
    public Currency currencyEffect(ItemStack stack) {
        return new RuneCurrency();
    }

    @Override
    public IBaseAutoLoc.AutoLocGroup locNameGroup() {
        return IBaseAutoLoc.AutoLocGroup.Misc;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        if (pLevel.f_46443_) {
            OpenGuiWrapper.openWikiRunewords();
        }
        return InteractionResultHolder.m_19098_((Object)pPlayer.m_21120_(pUsedHand));
    }

    public Component m_7626_(ItemStack stack) {
        return Component.m_237115_((String)this.m_5524_()).m_130940_(ChatFormatting.GOLD);
    }

    @Override
    public String locNameLangFileGUID() {
        return VanillaUTIL.REGISTRY.items().getKey((Object)this).toString();
    }

    @Override
    public String locNameForLangFile() {
        return this.type.locName + " Rune";
    }

    @Override
    public void generateModel(ItemModelManager manager) {
        manager.generated(this);
    }

    public RuneItem(RuneType type) {
        super(new Item.Properties().m_41487_(64));
        this.type = type;
        this.weight = type.weight;
    }

    public String GUID() {
        return "runes/" + this.type.id;
    }

    public int Weight() {
        return this.weight;
    }

    public Rune getRune() {
        return (Rune)ExileDB.Runes().get(this.type.id);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag context) {
        try {
            ExileTooltips t = new ExileTooltips();
            t.accept(new StatBlock(){

                @Override
                public List<? extends Component> getAvailableComponents() {
                    return RuneItem.this.statsTooltip();
                }
            });
            t.accept(new UsageBlock(TooltipUtils.splitLongText(Itemtips.RUNE_ITEM_USAGE.locName().m_130940_(ChatFormatting.BLUE))));
            t.accept(WorksOnBlock.usableOn(WorksOnBlock.ItemType.GEAR));
            t.accept(new OperationTipBlock().setAlt().setShift());
            Rune rune = this.getRune();
            if (rune.Weight() > 0) {
                int lvl = Load.Unit((Entity)ClientOnly.getPlayer()).getLevel();
                t.accept(new DropLevelBlock(rune.getReqLevelToDrop(), GameBalanceConfig.get().MAX_LEVEL));
                t.accept(new DropChanceBlock(RunePart.droppableAtLevel(lvl).getDropChance((ExileRegistry)rune)));
            } else {
                t.accept(new AdditionalBlock((Component)Itemtips.NOT_A_RANDOM_MNS_DROP_CHECK_MODPACK.locName().m_130940_(ChatFormatting.BLUE)));
            }
            tooltip.addAll(t.release());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<Component> statsTooltip() {
        List<StatMod> list;
        List<StatMod> armor;
        ArrayList<Component> tooltip = new ArrayList<Component>();
        int lvl = Load.Unit((Entity)ClientOnly.getPlayer()).getLevel();
        Rune gem = this.getRune();
        List<StatMod> wep = gem.getFor(SlotFamily.Weapon);
        if (!wep.isEmpty()) {
            tooltip.add((Component)Component.m_237113_((String)""));
            tooltip.add((Component)Words.WEAPON.locName().m_130940_(ChatFormatting.RED));
            for (StatMod statMod : wep) {
                tooltip.addAll(statMod.getEstimationTooltip(lvl));
            }
        }
        if (!(armor = gem.getFor(SlotFamily.Armor)).isEmpty()) {
            tooltip.add((Component)Component.m_237113_((String)""));
            tooltip.add((Component)Words.ARMOR.locName().m_130940_(ChatFormatting.BLUE));
            for (StatMod x : armor) {
                tooltip.addAll(x.getEstimationTooltip(lvl));
            }
        }
        if (!(list = gem.getFor(SlotFamily.Jewelry)).isEmpty()) {
            tooltip.add((Component)Component.m_237113_((String)""));
            tooltip.add((Component)Words.JEWERLY.locName().m_130940_(ChatFormatting.LIGHT_PURPLE));
            for (StatMod x : list) {
                tooltip.addAll(x.getEstimationTooltip(lvl));
            }
        }
        tooltip.add((Component)Component.m_237113_((String)""));
        return tooltip;
    }

    public class RuneCurrency
    extends GearCurrency {
        @Override
        public List<GearOutcome> getOutcomes() {
            return Arrays.asList(new GearOutcome(){

                @Override
                public Words getName() {
                    return Words.Rune;
                }

                @Override
                public GearOutcome.OutcomeType getOutcomeType() {
                    return GearOutcome.OutcomeType.GOOD;
                }

                @Override
                public ItemStack modify(LocReqContext ctx, GearItemData gear, ItemStack stack) {
                    List list;
                    SocketData rune = new SocketData();
                    boolean add = true;
                    Optional<SocketData> opt = gear.sockets.getSocketed().stream().filter(x -> x.isRune() && x.getRune().GUID().equals(RuneItem.this.type.id)).findAny();
                    if (opt.isPresent()) {
                        rune = opt.get();
                        add = false;
                    }
                    rune.g = RuneItem.this.type.id;
                    int val = LuckyRandom.randomInt(0, 100, LuckyRandom.LuckyUnlucky.UNLUCKY, 2);
                    if (!rune.getRune().uses_unlucky_ran) {
                        val = new MinMax(0, 100).random();
                    }
                    if (val > rune.p) {
                        rune.p = val;
                    }
                    if (add) {
                        gear.sockets.getSocketed().add(rune);
                    }
                    if (gear.getRarity().can_have_runewords && !(list = ExileDB.RuneWords().getFilterWrapped((Predicate<RuneWord>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$modify$1(net.minecraft.world.item.ItemStack com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData com.robertx22.mine_and_slash.database.data.runewords.RuneWord ), (Lcom/robertx22/mine_and_slash/database/data/runewords/RuneWord;)Z)((ItemStack)stack, (GearItemData)gear)).list).isEmpty()) {
                        RuneWord biggest = list.stream().max(Comparator.comparingInt(x -> x.runes.size())).get();
                        RuneWord current = gear.sockets.getRuneWord();
                        int currentSize = 0;
                        if (current != null && !current.isEmpty()) {
                            currentSize = current.runes.size();
                        }
                        if (biggest.runes.size() > currentSize) {
                            gear.sockets.setRuneword(biggest);
                        }
                    }
                    gear.saveToStack(stack);
                    return stack;
                }

                public int Weight() {
                    return 1000;
                }

                private static /* synthetic */ boolean lambda$modify$1(ItemStack stack, GearItemData gear, RuneWord x) {
                    return x.canApplyOnItem(stack) && x.hasMatchingRunesToCreate(gear);
                }
            });
        }

        @Override
        public int getPotentialLoss() {
            return 0;
        }

        @Override
        public ExplainedResult canBeModified(GearItemData data) {
            boolean can;
            Rune rune;
            if (data.uniqueStats != null && data.isUnique() && !data.uniqueStats.getUnique((GearItemData)data).runable) {
                return ExplainedResult.failure((Component)Chats.CANT_RUNE_THIS_UNIQUE.locName());
            }
            if (!data.rar.equals("runeword")) {
                int runes = (int)data.sockets.getSocketed().stream().filter(x -> x.isRune()).count();
                int gems = (int)data.sockets.getSocketed().stream().filter(x -> x.isGem()).count();
                if (gems > ++runes) {
                    return ExplainedResult.failure((Component)Chats.CANT_HAVE_MORE_RUNES_THAN_GEMS_IN_NON_RUNED.locName());
                }
            }
            if ((rune = (Rune)ExileDB.Runes().get(RuneItem.this.type.id)).getFor(data.GetBaseGearType().family()).isEmpty()) {
                return ExplainedResult.failure((Component)Chats.NOT_FAMILY.locName());
            }
            Optional<SocketData> opt = data.sockets.getSocketed().stream().filter(x -> x.isRune() && x.getRune().GUID().equals(RuneItem.this.type.id)).findAny();
            if (opt.isPresent() && opt.get().p >= 100) {
                return ExplainedResult.failure((Component)Chats.RUNE_IS_ALREADY_MAXED.locName());
            }
            int samerunes = (int)data.sockets.getSocketed().stream().filter(x -> x.isRune() && x.getRune().GUID().equals(RuneItem.this.type.id)).count();
            boolean bl = can = data.getEmptySockets() > 0 || samerunes == 1;
            if (!can) {
                return ExplainedResult.failure((Component)Chats.NEEDS_EMPTY_OR_RUNE.locName());
            }
            return ExplainedResult.success();
        }

        @Override
        public String locDescForLangFile() {
            return "";
        }

        @Override
        public String locNameForLangFile() {
            return "";
        }

        public String GUID() {
            return "rune";
        }

        public int Weight() {
            return 0;
        }
    }
}

