/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.vanilla_mc.items.crates.gem_crate;

import com.robertx22.library_of_exile.registry.IGUID;
import com.robertx22.library_of_exile.utils.SoundUtils;
import com.robertx22.mine_and_slash.database.data.currency.base.Currency;
import com.robertx22.mine_and_slash.database.data.gems.Gem;
import com.robertx22.mine_and_slash.database.data.runes.Rune;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.mmorpg.registers.common.items.SlashItems;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.datasaving.StackSaving;
import com.robertx22.mine_and_slash.uncommon.enumclasses.LootType;
import com.robertx22.mine_and_slash.uncommon.localization.Formatter;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.PlayerUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.TierColors;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.TooltipUtils;
import com.robertx22.mine_and_slash.vanilla_mc.items.crates.gem_crate.LootCrateData;
import com.robertx22.mine_and_slash.vanilla_mc.items.gemrunes.GemItem;
import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class LootCrateItem
extends Item
implements IGUID {
    public static List<LootType> LOOT_TYPES = Arrays.asList(LootType.Gem, LootType.Rune, LootType.Currency);

    public LootCrateItem() {
        super(new Item.Properties());
    }

    public LootCrateData getData(ItemStack stack) {
        return (LootCrateData)StackSaving.GEM_CRATE.loadFrom(stack);
    }

    public static ItemStack ofGem(GemItem.GemRank rank) {
        LootCrateData data = new LootCrateData();
        data.tier = rank.tier;
        data.type = data.type;
        ItemStack stack = new ItemStack((ItemLike)SlashItems.LOOT_CRATE.get());
        StackSaving.GEM_CRATE.saveTo(stack, (Object)data);
        stack.m_41783_().m_128405_("CustomModelData", data.type.custommodeldata);
        return stack;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!world.f_46443_) {
            try {
                ItemStack reward = ItemStack.f_41583_;
                LootCrateData data = (LootCrateData)StackSaving.GEM_CRATE.loadFrom(stack);
                if (data.type == LootType.Gem) {
                    Gem gem = (Gem)ExileDB.Gems().getFilterWrapped(x -> data.tier == x.tier).random();
                    reward = new ItemStack((ItemLike)gem.getItem());
                } else if (data.type == LootType.Rune) {
                    Rune rune = (Rune)ExileDB.Runes().getFilterWrapped(x -> Load.Unit((Entity)player).getLevel() >= x.getReqLevelToDrop()).random();
                    reward = new ItemStack((ItemLike)rune.getItem());
                } else if (data.type == LootType.Currency) {
                    Currency currency = (Currency)ExileDB.CurrencyItems().getFilterWrapped(x -> true).random();
                    if (currency == null) {
                        currency = (Currency)ExileDB.CurrencyItems().random();
                    }
                    reward = new ItemStack((ItemLike)currency.getCurrencyItem());
                }
                stack.m_41774_(1);
                SoundUtils.ding((Level)player.m_9236_(), (BlockPos)player.m_20183_());
                PlayerUtils.giveItem(reward, player);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)player.m_21120_(hand));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        LootCrateData data = this.getData(stack);
        if (data != null) {
            tooltip.add((Component)TooltipUtils.gearTier(data.tier));
        }
    }

    public Component m_7626_(ItemStack stack) {
        final LootCrateData data = this.getData(stack);
        if (data != null) {
            class RankChecker {
                RankChecker() {
                }

                private MutableComponent checker() {
                    if (data.type == LootType.Gem) {
                        return GemItem.GemRank.ofTier(data.tier).locName();
                    }
                    return Component.m_237113_((String)"");
                }
            }
            return Formatter.GEM_CHEST_NAME.locName(new RankChecker().checker(), data.type.word.locName(), Words.Loot.locName(), Words.Crate.locName().m_130940_(TierColors.get(data.tier)).m_130940_(ChatFormatting.BOLD));
        }
        return Words.EMPTY_BOX.locName();
    }

    public String GUID() {
        return "loot_crate/default";
    }
}

