/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.vanilla_mc.items;

import com.robertx22.library_of_exile.utils.SoundUtils;
import com.robertx22.mine_and_slash.database.data.profession.ICreativeTabTiered;
import com.robertx22.mine_and_slash.database.data.profession.LeveledItem;
import com.robertx22.mine_and_slash.database.data.profession.all.Professions;
import com.robertx22.mine_and_slash.database.data.rarities.GearRarity;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.gui.texts.ExileTooltips;
import com.robertx22.mine_and_slash.gui.texts.textblocks.LeveledItemBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.NameBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.RarityBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.dropblocks.ProfessionDropSourceBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.usableitemblocks.UsageBlock;
import com.robertx22.mine_and_slash.mmorpg.registers.common.items.RarityItems;
import com.robertx22.mine_and_slash.saveclasses.unit.ResourceType;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.effectdatas.EventBuilder;
import com.robertx22.mine_and_slash.uncommon.effectdatas.rework.RestoreType;
import com.robertx22.mine_and_slash.uncommon.localization.Itemtips;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.HealthUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.StringUTIL;
import com.robertx22.mine_and_slash.vanilla_mc.items.misc.AutoItem;
import com.robertx22.temp.SkillItemTier;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class SlashPotionItem
extends AutoItem
implements ICreativeTabTiered {
    String rar;
    Type type;

    public SlashPotionItem(String rar, Type type) {
        super(new Item.Properties().m_41487_(64));
        this.rar = rar;
        this.type = type;
    }

    @Override
    public String locNameForLangFile() {
        return StringUTIL.capitalise(this.rar) + " " + this.type.name + " Potion";
    }

    public String GUID() {
        return null;
    }

    @Override
    public Item getThis() {
        return this;
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        int num = (int)this.getHealPercent(pStack);
        pTooltipComponents.clear();
        pTooltipComponents.addAll(new ExileTooltips().accept(new NameBlock(pStack.m_41786_())).accept(new RarityBlock(this.getRarity())).accept(new ProfessionDropSourceBlock(Professions.ALCHEMY)).accept(new UsageBlock(Collections.singletonList(Itemtips.Restores.locName(Component.m_237113_((String)(num + "%")).m_130940_(ChatFormatting.GREEN), this.type.name).m_130940_(ChatFormatting.GRAY)))).accept(new LeveledItemBlock(pStack)).accept(new UsageBlock(Collections.singletonList(Words.COOLDOWN.locName(Component.m_237113_((String)("" + this.getCooldownTicks() / 20)).m_130940_(ChatFormatting.GOLD)).m_130940_(ChatFormatting.GOLD)))).release());
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player p, InteractionHand pUsedHand) {
        ItemStack stack = p.m_21120_(pUsedHand);
        if (!pLevel.f_46443_) {
            if (this.type == Type.HP) {
                EventBuilder.ofRestore((LivingEntity)p, (LivingEntity)p, ResourceType.health, RestoreType.potion, HealthUtils.getMaxHealth((LivingEntity)p) * this.getHealPercent(stack) / 100.0f).build().Activate();
                EventBuilder.ofRestore((LivingEntity)p, (LivingEntity)p, ResourceType.magic_shield, RestoreType.potion, Load.Unit((Entity)p).getUnit().magicShieldData().getValue() * this.getHealPercent(stack) / 100.0f).build().Activate();
            } else {
                EventBuilder.ofRestore((LivingEntity)p, (LivingEntity)p, ResourceType.mana, RestoreType.potion, Load.Unit((Entity)p).getUnit().manaData().getValue() * this.getHealPercent(stack) / 100.0f).build().Activate();
                EventBuilder.ofRestore((LivingEntity)p, (LivingEntity)p, ResourceType.energy, RestoreType.potion, Load.Unit((Entity)p).getUnit().energyData().getValue() * this.getHealPercent(stack) / 100.0f).build().Activate();
            }
            for (SlashPotionItem c : this.getCooldownItems()) {
                p.m_36335_().m_41524_((Item)c, this.getCooldownTicks());
            }
            SoundUtils.playSound((Entity)p, (SoundEvent)SoundEvents.f_11911_);
            stack.m_41774_(1);
        }
        return InteractionResultHolder.m_19098_((Object)p.m_21120_(pUsedHand));
    }

    public int getCooldownTicks() {
        return 600;
    }

    public List<SlashPotionItem> getCooldownItems() {
        if (this.type == Type.HP) {
            return RarityItems.HEALTH_POTIONS.values().stream().map(x -> (SlashPotionItem)x.get()).collect(Collectors.toList());
        }
        return RarityItems.RESOURCE_POTIONS.values().stream().map(x -> (SlashPotionItem)x.get()).collect(Collectors.toList());
    }

    public float getHealPercent(ItemStack stack) {
        GearRarity r = this.getRarity();
        SkillItemTier tier = LeveledItem.getTier(stack);
        return 5.0f + 0.25f * (float)r.stat_percents.max * tier.statMulti;
    }

    public GearRarity getRarity() {
        return (GearRarity)ExileDB.GearRarities().get(this.rar);
    }

    public static enum Type {
        HP("Health", Items.f_42620_),
        MANA("Mana", Items.f_42619_);

        String name;
        Item craftItem;

        private Type(String name, Item craftItem) {
            this.name = name;
            this.craftItem = craftItem;
        }
    }
}

