/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.vanilla_mc.commands.giveitems;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.robertx22.library_of_exile.registry.ExileRegistryType;
import com.robertx22.mine_and_slash.database.data.rarities.GearRarity;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.loot.LootInfo;
import com.robertx22.mine_and_slash.loot.blueprints.ITypeBlueprint;
import com.robertx22.mine_and_slash.loot.blueprints.RarityItemBlueprint;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.PlayerUtils;
import com.robertx22.mine_and_slash.vanilla_mc.commands.CommandRefs;
import com.robertx22.mine_and_slash.vanilla_mc.commands.suggestions.DatabaseSuggestions;
import com.robertx22.mine_and_slash.vanilla_mc.commands.suggestions.GearRaritySuggestions;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.world.entity.player.Player;

public class GenericGive {
    String id;
    ExileRegistryType type;
    Function<LootInfo, RarityItemBlueprint> blueprint;

    public GenericGive(String id, ExileRegistryType type, Function<LootInfo, RarityItemBlueprint> blueprint) {
        this.id = id;
        this.type = type;
        this.blueprint = blueprint;
    }

    public void register(CommandDispatcher<CommandSourceStack> dis) {
        dis.register((LiteralArgumentBuilder)Commands.m_82127_((String)CommandRefs.ID).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"give").requires(e -> e.m_6761_(2))).then(Commands.m_82127_((String)this.id).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"type", (ArgumentType)StringArgumentType.word()).suggests((SuggestionProvider)(this.type != null ? new DatabaseSuggestions(this.type, "random") : null)).then(Commands.m_82129_((String)"level", (ArgumentType)IntegerArgumentType.integer()).then(Commands.m_82129_((String)"rarity", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new GearRaritySuggestions()).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)5000)).executes(e -> this.execute((CommandSourceStack)e.getSource(), (Player)EntityArgument.m_91474_((CommandContext)e, (String)"target"), StringArgumentType.getString((CommandContext)e, (String)"type"), IntegerArgumentType.getInteger((CommandContext)e, (String)"level"), StringArgumentType.getString((CommandContext)e, (String)"rarity"), IntegerArgumentType.getInteger((CommandContext)e, (String)"amount")))))))))));
    }

    private int execute(CommandSourceStack commandSource, Player player, String type, int lvl, String rarity, int amount) {
        if (Objects.isNull(player)) {
            try {
                player = commandSource.m_81375_();
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
                return 1;
            }
        }
        for (int i = 0; i < amount; ++i) {
            RarityItemBlueprint blueprint = this.blueprint.apply(LootInfo.ofLevel(lvl));
            blueprint.level.set(lvl);
            if (ExileDB.GearRarities().isRegistered(rarity)) {
                blueprint.rarity.set((GearRarity)ExileDB.GearRarities().get(rarity));
            }
            if (blueprint instanceof ITypeBlueprint) {
                ITypeBlueprint typeb = (ITypeBlueprint)((Object)blueprint);
                if (!type.equals("random")) {
                    typeb.setType(type);
                }
            }
            PlayerUtils.giveItem(blueprint.createStack(), player);
        }
        return 0;
    }
}

