/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.utilityclasses;

import com.robertx22.library_of_exile.vanilla_util.main.VanillaUTIL;
import com.robertx22.mine_and_slash.mmorpg.SlashRef;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;

public class WorldUtils {
    public static ResourceLocation DUNGEON_DIM_ID = SlashRef.id("dungeon");

    public static void spawnEntity(Level world, Entity entity) {
        world.m_7967_(entity);
    }

    public static boolean isNearSurface(BlockPos pos, Level world, int buffer) {
        BlockPos surface = WorldUtils.getSurface((LevelAccessor)world, pos);
        return pos.m_123342_() > surface.m_123342_() - buffer;
    }

    public static BlockPos getSurfaceCenterOfChunk(LevelAccessor world, BlockPos pos) {
        int x = world.m_46865_((BlockPos)pos).m_7697_().f_45578_ + 8;
        int z = world.m_46865_((BlockPos)pos).m_7697_().f_45579_ + 8;
        pos = WorldUtils.furtherby8(pos);
        pos = WorldUtils.getSurface(world, pos);
        return pos;
    }

    public static BlockPos furtherby8(BlockPos pos) {
        int x = 0;
        int z = 0;
        x = pos.m_123341_() > 0 ? pos.m_123341_() + 8 : pos.m_123341_() - 8;
        z = pos.m_123343_() > 0 ? pos.m_123343_() + 8 : pos.m_123343_() - 8;
        pos = new BlockPos(x, pos.m_123342_(), z);
        return pos;
    }

    public static boolean surfaceIsWater(LevelAccessor world, BlockPos pos) {
        BlockPos surface = WorldUtils.getSurface(world, pos);
        for (BlockPos x : Arrays.asList(surface.m_7494_(), surface.m_6630_(2), surface.m_7495_(), surface.m_6625_(2), surface)) {
            if (!world.m_8055_(x).m_60713_(Blocks.f_49990_)) continue;
            return true;
        }
        return false;
    }

    public static BlockPos getSurface(LevelAccessor world, BlockPos pos) {
        pos = new BlockPos(pos.m_123341_(), world.m_5736_(), pos.m_123343_());
        boolean goingDown = world.m_46859_(pos);
        while (world.m_46859_(pos) || world.m_8055_(pos).m_60734_() instanceof LeavesBlock) {
            if (goingDown) {
                pos = pos.m_7495_();
                continue;
            }
            pos = pos.m_7494_();
        }
        while (!world.m_46859_(pos.m_7494_())) {
            pos = pos.m_7494_();
        }
        return pos.m_7494_();
    }

    public static boolean isDungeonWorld(Level world) {
        return WorldUtils.isMapWorldClass(world);
    }

    public static boolean isMapWorldClass(Level world) {
        if (world == null) {
            return false;
        }
        return VanillaUTIL.REGISTRY.dimensionTypes(world).getKey((Object)world.m_6042_()).equals((Object)DUNGEON_DIM_ID);
    }

    static boolean isId(Level world, ResourceLocation dimid) {
        ResourceLocation id = VanillaUTIL.REGISTRY.dimensionTypes(world).getKey((Object)world.m_6042_());
        if (id != null) {
            return id.equals((Object)dimid);
        }
        return false;
    }
}

