/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.utilityclasses;

import com.robertx22.library_of_exile.utils.CLOC;
import com.robertx22.library_of_exile.wrappers.ExileText;
import com.robertx22.mine_and_slash.capability.entity.EntityData;
import com.robertx22.mine_and_slash.config.forge.ClientConfigs;
import com.robertx22.mine_and_slash.database.data.gear_slots.GearSlot;
import com.robertx22.mine_and_slash.database.data.rarities.GearRarity;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.Rarity;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.StatRequirement;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.ICommonDataItem;
import com.robertx22.mine_and_slash.uncommon.localization.Itemtips;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.RepairUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class TooltipUtils {
    public static String CHECKMARK = ChatFormatting.GREEN + "\u2714";
    public static String X = ChatFormatting.RED + "\u2716";
    static Character CHAR = Character.valueOf("\u00a7".charAt(0));

    public static MutableComponent color(ChatFormatting format, MutableComponent comp) {
        return Component.m_237113_((String)("" + format)).m_7220_((Component)comp);
    }

    public static void addRequirements(List<Component> tip, int lvl, StatRequirement req, EntityData data) {
        tip.addAll(req.GetTooltipString(lvl, data));
    }

    public static void addEmpty(List<Component> tooltip) {
        tooltip.add((Component)CLOC.blank((String)""));
    }

    public static List<String> compsToStrings(List<Component> list) {
        return list.stream().map(x -> x.getString()).collect(Collectors.toList());
    }

    public static MutableComponent level(int lvl) {
        return Component.m_237113_((String)"").m_7220_((Component)Itemtips.LEVEL_TIP.locName(lvl).m_130940_(ChatFormatting.YELLOW));
    }

    public static List<Component> cutIfTooLong(MutableComponent comp) {
        List<String> stringList = TooltipUtils.cutIfTooLong(comp.getString());
        return stringList.stream().map(x -> ExileText.ofText((String)x).get()).collect(Collectors.toList());
    }

    public static List<MutableComponent> cutIfTooLong(MutableComponent comp, ChatFormatting format) {
        List<String> stringList = TooltipUtils.cutIfTooLong(comp.getString());
        return stringList.stream().map(x -> ExileText.ofText((String)x).format(format).get()).collect(Collectors.toList());
    }

    public static List<String> cutIfTooLong(String str) {
        return Arrays.asList(str);
    }

    public static MutableComponent itemBrokenText(ItemStack stack, ICommonDataItem data) {
        if (data != null && RepairUtils.isItemBroken(stack)) {
            MutableComponent comp = Component.m_237113_((String)(X + " ")).m_7220_((Component)Words.Broken.locName());
            return comp;
        }
        return null;
    }

    public static List<Component> mutableToComp(List<MutableComponent> list) {
        return new ArrayList<MutableComponent>(list);
    }

    public static List<Component> removeDoubleBlankLines(List<Component> list) {
        return TooltipUtils.removeDoubleBlankLines(list, (Integer)ClientConfigs.getConfig().REMOVE_EMPTY_TOOLTIP_LINES_IF_MORE_THAN_X_LINES.get());
    }

    private static List<Component> removeDoubleBlankLines(List<Component> list, int minLinesCutAllBlanks) {
        boolean alwaysRemoveEmpty;
        List<Component> newt = TooltipUtils.removeDoubleBlankLines(list, minLinesCutAllBlanks, false);
        boolean bl = alwaysRemoveEmpty = newt.size() > minLinesCutAllBlanks;
        if (alwaysRemoveEmpty) {
            newt = TooltipUtils.removeDoubleBlankLines(newt, minLinesCutAllBlanks, true);
        }
        return newt;
    }

    private static List<Component> removeDoubleBlankLines(List<Component> list, int minLinesCutAllBlanks, boolean alwaysRemoveEmpty) {
        ArrayList<Component> newt = new ArrayList<Component>();
        boolean lastIsEmpty = false;
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).getString().isBlank()) {
                lastIsEmpty = false;
                newt.add(list.get(i));
                continue;
            }
            if (!lastIsEmpty && !alwaysRemoveEmpty) {
                newt.add(list.get(i));
            }
            lastIsEmpty = true;
        }
        list.clear();
        list.addAll(newt);
        return newt;
    }

    public static MutableComponent rarity(Rarity rarity) {
        return Itemtips.RARITY_TIP.locName().m_130940_(ChatFormatting.WHITE).m_7220_((Component)rarity.locName().m_130940_(rarity.textFormatting()));
    }

    public static MutableComponent rarityShort(Rarity rarity) {
        return Component.m_237113_((String)("" + rarity.textFormatting())).m_7220_((Component)rarity.locName().m_130940_(rarity.textFormatting()));
    }

    public static MutableComponent tier(int tier) {
        return Itemtips.TIER_TIP.locName(tier);
    }

    @NotNull
    public static MutableComponent gearSlot(GearSlot slot) {
        return Itemtips.ITEM_TYPE.locName(slot.locName().m_130940_(ChatFormatting.AQUA)).m_130940_(ChatFormatting.WHITE);
    }

    public static MutableComponent gearTier(int tier) {
        return Itemtips.ITEM_TIER_TIP.locName(Component.m_237113_((String)("" + tier)).m_130940_(ChatFormatting.GOLD)).m_130940_(ChatFormatting.GOLD);
    }

    public static MutableComponent gearRarity(GearRarity rarity) {
        return Itemtips.RARITY_TIP.locName().m_130940_(ChatFormatting.WHITE).m_7220_((Component)rarity.locName().m_130940_(rarity.textFormatting()));
    }

    public static MutableComponent levelAndRarity(int lvl, int playerlvl, GearRarity rar) {
        ChatFormatting color = ChatFormatting.YELLOW;
        if (lvl > playerlvl) {
            color = ChatFormatting.RED;
        }
        return Itemtips.LEVEL_TIP.locName().m_130940_(color).m_7220_((Component)Component.m_237113_((String)("" + lvl)).m_130940_(color)).m_130946_(" ").m_7220_((Component)rar.locName().m_130940_(rar.textFormatting())).m_130946_(" ").m_7220_((Component)Words.ITEM.locName());
    }

    public static MutableComponent gearLevel(int lvl, int playerlvl) {
        ChatFormatting color = ChatFormatting.YELLOW;
        if (lvl > playerlvl) {
            color = ChatFormatting.RED;
        }
        return Itemtips.LEVEL_TIP.locName().m_130940_(color).m_7220_((Component)Component.m_237113_((String)("" + lvl)).m_130940_(color));
    }

    public static List<MutableComponent> splitLongText(MutableComponent comp) {
        String[] originalList;
        ArrayList<MutableComponent> componentList = new ArrayList<MutableComponent>();
        Style format = comp.m_7383_();
        for (String comp1 : originalList = comp.getString().split("\n")) {
            componentList.add(ExileText.ofText((String)comp1).get().m_130948_(format));
        }
        return componentList;
    }

    public static List<Component> splitLongText(List<? extends Component> comps) {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        for (Component component : comps) {
            if (component.getString().contains("\n")) {
                String[] originalList;
                Style format = component.m_7383_();
                for (String comp1 : originalList = component.getString().split("\n")) {
                    arrayList.add((Component)Component.m_237113_((String)comp1).m_130948_(format));
                }
                continue;
            }
            arrayList.add(component);
        }
        return arrayList;
    }

    public static MutableComponent joinMutableComps(Iterator<? extends Component> iterator, MutableComponent separator) {
        if (separator == null) {
            separator = Component.m_237113_((String)"");
        }
        MutableComponent starter = Component.m_237113_((String)"");
        while (iterator.hasNext()) {
            starter.m_7220_(iterator.next());
            if (!iterator.hasNext()) continue;
            starter.m_7220_((Component)separator);
        }
        return starter;
    }
}

