/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.utilityclasses;

import com.robertx22.mine_and_slash.capability.player.data.PlayerConfigData;
import com.robertx22.mine_and_slash.config.forge.ServerContainer;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.PlayerUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class TeamUtils {
    public static void forEachMember(Level world, BlockPos pos, Consumer<Player> action) {
        Player player = PlayerUtils.nearestPlayer((ServerLevel)world, pos);
        if (player != null) {
            TeamUtils.getOnlineMembers(player).forEach(x -> action.accept((Player)x));
        }
    }

    public static List<Player> getOnlineTeamMembersInRange(Player player, double range) {
        return TeamUtils.getOnlineMembers(player).stream().filter(x -> (double)player.m_20270_((Entity)x) < range).collect(Collectors.toList());
    }

    public static List<Player> getOnlineTeamMembersInRange(Player player) {
        return TeamUtils.getOnlineTeamMembersInRange(player, (Double)ServerContainer.get().PARTY_RADIUS.get());
    }

    public static List<Player> getOnlineMembers(Player player) {
        ArrayList<Player> players = new ArrayList<Player>();
        try {
            player.m_9236_().m_6907_().forEach(x -> {
                if (TeamUtils.areOnSameTeam(player, x)) {
                    players.add((Player)x);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (players.isEmpty()) {
            players.add(player);
        }
        return players;
    }

    public static boolean areOnSameTeam(Player p1, Player p2) {
        if (p1 == p2) {
            return true;
        }
        if ((double)p1.m_20270_((Entity)p2) > (Double)ServerContainer.get().MAX_TEAM_DISTANCE.get()) {
            return false;
        }
        if (Load.player((Player)p1).config.isConfigEnabled(PlayerConfigData.Config.AUTO_PVE) && Load.player((Player)p2).config.isConfigEnabled(PlayerConfigData.Config.AUTO_PVE)) {
            return true;
        }
        return Load.player((Player)p1).team.isOnSameTeam(p2);
    }
}

