/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.utilityclasses;

import com.robertx22.mine_and_slash.a_libraries.curios.MyCurioUtils;
import com.robertx22.mine_and_slash.database.data.gear_types.bases.BaseGearType;
import com.robertx22.mine_and_slash.event_hooks.my_events.CollectGearEvent;
import com.robertx22.mine_and_slash.saveclasses.unit.GearData;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class PlayerUtils {
    public static List<Player> getNearbyPlayers(Level world, BlockPos pos, double range) {
        return world.m_7654_().m_6846_().m_11314_().stream().filter(x -> pos.m_123331_((Vec3i)new BlockPos((int)x.m_20185_(), (int)x.m_20186_(), (int)x.m_20189_())) < range).collect(Collectors.toList());
    }

    public static List<Player> getNearbyPlayers(Entity en, double range) {
        return PlayerUtils.getNearbyPlayers(en.m_9236_(), en.m_20183_(), range);
    }

    public static List<ItemStack> getEquippedStacksOf(Player player, BaseGearType type) {
        if (type.getVanillaSlotType() == null) {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            if (type.gear_slot.equals("ring")) {
                list.addAll(MyCurioUtils.getAllSlots(Arrays.asList("ring"), player));
            }
            if (type.gear_slot.equals("necklace")) {
                list.addAll(MyCurioUtils.getAllSlots(Arrays.asList("necklace"), player));
            }
            return list;
        }
        return Arrays.asList(player.m_6844_(type.getVanillaSlotType()));
    }

    public static ItemStack lowestDurabilityWornGear(Player player) {
        List<GearData> stacks = CollectGearEvent.getAllGear(null, (LivingEntity)player, Load.Unit((Entity)player));
        Optional<GearData> opt = stacks.stream().filter(x -> !x.stack.m_41619_()).sorted(Comparator.comparingInt(x -> x.stack.m_41776_() - x.stack.m_41773_())).findFirst();
        if (opt.isPresent()) {
            return opt.get().stack;
        }
        return ItemStack.f_41583_;
    }

    public static void giveItem(ItemStack stack, Player player) {
        if (!player.m_36356_(stack)) {
            player.m_5552_(stack, 1.0f);
        }
        player.m_150109_().m_6596_();
    }

    public static Player nearestPlayer(ServerLevel world, LivingEntity entity) {
        return PlayerUtils.nearestPlayer(world, entity.m_20182_());
    }

    public static Player nearestPlayer(ServerLevel world, BlockPos pos) {
        return PlayerUtils.nearestPlayer(world, new Vec3((double)pos.m_123342_(), (double)pos.m_123342_(), (double)pos.m_123343_()));
    }

    public static Player nearestPlayer(ServerLevel world, Vec3 pos) {
        Optional<ServerPlayer> player = world.m_6907_().stream().min(Comparator.comparingDouble(x -> x.m_20238_(pos)));
        return player.orElse(null);
    }
}

