/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.utilityclasses;

import com.robertx22.mine_and_slash.database.data.spells.summons.entity.SummonEntity;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.EntityFinder;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.TeamUtils;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum AllyOrEnemy {
    allies{

        @Override
        public <T extends LivingEntity> List<T> getMatchingEntities(List<T> list, Entity caster) {
            return list.stream().filter(x -> this.is(caster, (LivingEntity)x)).collect(Collectors.toList());
        }

        @Override
        public boolean is(Entity caster, LivingEntity target) {
            return !enemies.is(caster, target);
        }

        @Override
        public boolean includesCaster() {
            return true;
        }
    }
    ,
    pets{

        @Override
        public <T extends LivingEntity> List<T> getMatchingEntities(List<T> list, Entity caster) {
            return list.stream().filter(x -> this.is(caster, (LivingEntity)x)).collect(Collectors.toList());
        }

        @Override
        public boolean is(Entity caster, LivingEntity target) {
            OwnableEntity pet;
            Player p;
            return caster instanceof Player && EntityFinder.isTamedByAlly(p = (Player)caster, target) && target instanceof OwnableEntity && (pet = (OwnableEntity)target).m_269323_() == caster;
        }

        @Override
        public boolean includesCaster() {
            return false;
        }
    }
    ,
    casters_summons{

        @Override
        public <T extends LivingEntity> List<T> getMatchingEntities(List<T> list, Entity caster) {
            return list.stream().filter(x -> this.is(caster, (LivingEntity)x)).collect(Collectors.toList());
        }

        @Override
        public boolean is(Entity caster, LivingEntity target) {
            if (caster instanceof Player) {
                OwnableEntity pet;
                Player p = (Player)caster;
                if (target instanceof SummonEntity && EntityFinder.isTamedByAlly(p, target) && target instanceof OwnableEntity && (pet = (OwnableEntity)target).m_269323_() == caster) {
                    return !Load.Unit((Entity)target).summonedPetData.isEmpty();
                }
            }
            return false;
        }

        @Override
        public boolean includesCaster() {
            return false;
        }
    }
    ,
    enemies{

        @Override
        public boolean is(Entity caster, LivingEntity target) {
            if (caster instanceof Player) {
                Player p = (Player)caster;
                if (EntityFinder.isTamedByAlly(p, target)) {
                    return false;
                }
                if (target instanceof Player) {
                    if (!caster.m_9236_().m_7654_().m_129799_()) {
                        return false;
                    }
                    return target != caster && !TeamUtils.areOnSameTeam((Player)caster, (Player)target);
                }
            } else {
                OwnableEntity o;
                LivingEntity livingEntity;
                if (target instanceof Player) {
                    return true;
                }
                if (target instanceof OwnableEntity && (livingEntity = (o = (OwnableEntity)target).m_269323_()) instanceof Player) {
                    Player p = (Player)livingEntity;
                    return true;
                }
                return false;
            }
            return true;
        }

        @Override
        public <T extends LivingEntity> List<T> getMatchingEntities(List<T> list, Entity caster) {
            return list.stream().filter(x -> this.is(caster, (LivingEntity)x)).collect(Collectors.toList());
        }

        @Override
        public boolean includesCaster() {
            return false;
        }
    }
    ,
    all{

        @Override
        public <T extends LivingEntity> List<T> getMatchingEntities(List<T> list, Entity caster) {
            return list;
        }

        @Override
        public boolean is(Entity caster, LivingEntity target) {
            return true;
        }

        @Override
        public boolean includesCaster() {
            return true;
        }
    };


    public abstract <T extends LivingEntity> List<T> getMatchingEntities(List<T> var1, Entity var2);

    public abstract boolean is(Entity var1, LivingEntity var2);

    public abstract boolean includesCaster();
}

