/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.testing.tests;

import com.robertx22.mine_and_slash.database.OptScaleExactStat;
import com.robertx22.mine_and_slash.database.data.perks.Perk;
import com.robertx22.mine_and_slash.database.data.talent_tree.TalentTree;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.uncommon.testing.CommandTest;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import net.minecraft.server.level.ServerPlayer;

public class CountTalentTreeAttributes
extends CommandTest {
    @Override
    public void run(ServerPlayer player) {
        TalentTree tree = (TalentTree)ExileDB.TalentTrees().get("talents");
        ArrayList<OptScaleExactStat> stats = new ArrayList<OptScaleExactStat>();
        int totalperks = tree.calcData.perks.size();
        int notables = 0;
        int gamechangers = 0;
        HashSet<Perk> diffPerks = new HashSet<Perk>();
        for (String x1 : tree.calcData.perks.values()) {
            Perk perk = (Perk)ExileDB.Perks().get(x1);
            if (perk == null) continue;
            perk.stats.forEach(s -> {
                if (s.v1 > 0.0f) {
                    stats.add((OptScaleExactStat)s);
                }
            });
            if (perk.type == Perk.PerkType.SPECIAL) {
                ++notables;
            }
            if (perk.type == Perk.PerkType.MAJOR) {
                ++gamechangers;
            }
            diffPerks.add(perk);
        }
        int differentPerks = diffPerks.size();
        OptScaleExactStat.combine(stats);
        stats.sort(Comparator.comparingInt(x -> (int)(-x.v1)));
        System.out.print("\n");
        System.out.print("Talent tree statistics:\n");
        System.out.print("Total perks: " + totalperks + "\n");
        System.out.print("Different perks: " + differentPerks + "\n");
        System.out.print("Total notable perks: " + notables + "\n");
        System.out.print("Total game changer perks: " + gamechangers + "\n");
        System.out.print("\n");
        System.out.print("Total stats: \n");
        for (OptScaleExactStat x2 : stats) {
            System.out.print(x2.getDebugString() + "\n");
        }
    }

    public String GUID() {
        return "talent_tree_info";
    }
}

