/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.stat_calculation;

import com.robertx22.mine_and_slash.aoe_data.database.base_stats.BaseStatsAdder;
import com.robertx22.mine_and_slash.database.data.base_stats.BaseStatsConfig;
import com.robertx22.mine_and_slash.database.data.stat_compat.StatCompat;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.maps.MapData;
import com.robertx22.mine_and_slash.maps.MapItemData;
import com.robertx22.mine_and_slash.saveclasses.ExactStatData;
import com.robertx22.mine_and_slash.saveclasses.unit.stat_ctx.SimpleStatCtx;
import com.robertx22.mine_and_slash.saveclasses.unit.stat_ctx.StatContext;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.WorldUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class CommonStatUtils {
    public static StatContext addStatCompat(LivingEntity en) {
        ArrayList<ExactStatData> list = new ArrayList<ExactStatData>();
        for (StatCompat c : ExileDB.StatCompat().getList()) {
            ExactStatData data;
            if (!c.isAttributeCompat() || (data = c.getResult(en, Load.Unit((Entity)en).getLevel())) == null) continue;
            list.add(data);
        }
        return new SimpleStatCtx(StatContext.StatCtxType.VANILLA_STAT_COMPAT, list);
    }

    public static List<StatContext> addExactCustomStats(LivingEntity en) {
        return Load.Unit((Entity)en).getCustomExactStats().getStatAndContext(en);
    }

    public static List<StatContext> addBaseStats(LivingEntity en) {
        try {
            String id = BaseStatsAdder.PLAYER;
            if (!(en instanceof Player)) {
                id = BaseStatsAdder.MOB;
            }
            BaseStatsConfig stats = (BaseStatsConfig)ExileDB.BaseStats().get(id);
            Objects.requireNonNull(stats);
            return stats.getStatAndContext(en);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Arrays.asList(new StatContext[0]);
        }
    }

    public static List<StatContext> addMapAffixStats(LivingEntity en) {
        MapData map;
        ArrayList<StatContext> list = new ArrayList<StatContext>();
        if (WorldUtils.isMapWorldClass(en.m_9236_()) && (map = Load.mapAt(en.m_9236_(), en.m_20183_())) != null) {
            MapItemData data = map.map;
            for (StatContext stat : data.getStatAndContext(en)) {
                list.add(stat);
            }
        }
        return list;
    }
}

