/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.enumclasses;

import com.robertx22.library_of_exile.registry.ExileRegistryType;
import com.robertx22.library_of_exile.registry.IAutoGson;
import com.robertx22.library_of_exile.registry.JsonExileRegistry;
import com.robertx22.mine_and_slash.database.registry.ExileRegistryTypes;
import com.robertx22.mine_and_slash.uncommon.enumclasses.PlayStyle;
import com.robertx22.mine_and_slash.uncommon.enumclasses.WeaponRange;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.StringUTIL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;

public class WeaponTypes
implements JsonExileRegistry<WeaponTypes>,
IAutoGson<WeaponTypes> {
    public static WeaponTypes SERIALIZER = new WeaponTypes();
    private static List<WeaponTypes> ALL = new ArrayList<WeaponTypes>();
    public static WeaponTypes none = new WeaponTypes("none", PlayStyle.STR, WeaponRange.MELEE, false, DamageValidityData.meleeWeapon());
    public static WeaponTypes axe = new WeaponTypes("axe", PlayStyle.STR, WeaponRange.MELEE, false, DamageValidityData.meleeWeapon());
    public static WeaponTypes staff = new WeaponTypes("staff", PlayStyle.INT, WeaponRange.MELEE, false, DamageValidityData.meleeWeapon());
    public static WeaponTypes trident = new WeaponTypes("trident", PlayStyle.STR, WeaponRange.OPTIONALLY_RANGED, false, DamageValidityData.meleeWeapon());
    public static WeaponTypes sword = new WeaponTypes("sword", PlayStyle.STR, WeaponRange.MELEE, false, DamageValidityData.meleeWeapon()).setCanDualWield();
    public static WeaponTypes bow = new WeaponTypes("bow", PlayStyle.DEX, WeaponRange.RANGED, true, DamageValidityData.projectile());
    public static WeaponTypes crossbow = new WeaponTypes("crossbow", PlayStyle.DEX, WeaponRange.RANGED, true, DamageValidityData.projectile());
    public boolean can_dual_wield = false;
    public PlayStyle style;
    public WeaponRange range;
    public String id;
    public boolean isProjectile;
    public DamageValidityData damage_validity_check = new DamageValidityData();

    public WeaponTypes() {
    }

    static void init() {
    }

    public static void registerAll() {
        for (WeaponTypes wep : ALL) {
            wep.addToSerializables();
        }
    }

    public ExileRegistryType getExileRegistryType() {
        return ExileRegistryTypes.WEAPON_TYPE;
    }

    public int Weight() {
        return 1000;
    }

    public Class<WeaponTypes> getClassForSerialization() {
        return WeaponTypes.class;
    }

    WeaponTypes(String id, PlayStyle style, WeaponRange range, boolean isProjectile, DamageValidityData valid) {
        this.id = id;
        this.style = style;
        this.range = range;
        this.isProjectile = isProjectile;
        this.damage_validity_check = valid;
        ALL.add(this);
    }

    public WeaponTypes setCanDualWield() {
        this.can_dual_wield = true;
        return this;
    }

    public String locName() {
        return StringUTIL.capitalise(this.id);
    }

    public boolean isMelee() {
        return this.range == WeaponRange.MELEE;
    }

    public static List<WeaponTypes> getAll() {
        return ALL.stream().filter(x -> x != none).collect(Collectors.toList());
    }

    public String GUID() {
        return this.id;
    }

    static {
        WeaponTypes.init();
    }

    public static class DamageValidityData {
        private SourceCheck source_check = SourceCheck.ANY;
        private TagCheck tag_and_id_check = TagCheck.MATCH_ANY;
        private List<ResourceLocation> valid_proj_dmg_id = Arrays.asList(new ResourceLocation("testmodid", "name"));
        private List<String> contains_in_dmg_id = Arrays.asList("arrow", "bolt", "ammo", "bullet", "dart", "missile");

        public DamageValidityData(SourceCheck shortcheck, TagCheck tag_and_id_check, List<ResourceLocation> valid_proj_dmg_id, List<String> contains_in_dmg_id) {
            this.tag_and_id_check = tag_and_id_check;
            this.source_check = shortcheck;
            this.valid_proj_dmg_id = valid_proj_dmg_id;
            this.contains_in_dmg_id = contains_in_dmg_id;
        }

        public static DamageValidityData projectile() {
            return new DamageValidityData(SourceCheck.RANGED_PROJECTILE, TagCheck.MATCH_ANY, Arrays.asList(new ResourceLocation[0]), Arrays.asList("arrow", "bolt", "ammo", "bullet", "dart", "missile"));
        }

        public static DamageValidityData meleeWeapon() {
            return new DamageValidityData(SourceCheck.DIRECT_ATTACK, TagCheck.ANY, Arrays.asList(new ResourceLocation[0]), Arrays.asList(new String[0]));
        }

        public DamageValidityData() {
        }

        public boolean isValid(DamageSource source) {
            if (!this.source_check.isValid(source)) {
                return false;
            }
            return this.tag_and_id_check.isValid(source, this);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum TagCheck {
        ANY{

            @Override
            public boolean isValid(DamageSource source, DamageValidityData data) {
                return true;
            }
        }
        ,
        MATCH_ANY{

            @Override
            public boolean isValid(DamageSource source, DamageValidityData data) {
                ResourceLocation dmgid = ((Registry)source.m_7639_().m_9236_().m_9598_().m_6632_(Registries.f_268580_).get()).m_7981_((Object)source.m_269415_());
                for (ResourceLocation id : data.valid_proj_dmg_id) {
                    if (!id.equals((Object)dmgid)) continue;
                    return true;
                }
                String id = source.m_19385_();
                for (String name : data.contains_in_dmg_id) {
                    if (!id.contains(name)) continue;
                    return true;
                }
                return false;
            }
        };


        public abstract boolean isValid(DamageSource var1, DamageValidityData var2);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum SourceCheck {
        ANY{

            @Override
            public boolean isValid(DamageSource source) {
                return true;
            }
        }
        ,
        RANGED_PROJECTILE{

            @Override
            public boolean isValid(DamageSource source) {
                return source.m_269533_(DamageTypeTags.f_268524_);
            }
        }
        ,
        DIRECT_ATTACK{

            @Override
            public boolean isValid(DamageSource source) {
                return source.m_7640_() == source.m_7639_();
            }
        };


        public abstract boolean isValid(DamageSource var1);
    }
}

