/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.enumclasses;

import com.robertx22.library_of_exile.registry.IGUID;
import com.robertx22.mine_and_slash.mmorpg.SlashRef;
import com.robertx22.mine_and_slash.tags.ModTag;
import com.robertx22.mine_and_slash.tags.TagList;
import com.robertx22.mine_and_slash.tags.all.ElementTags;
import com.robertx22.mine_and_slash.tags.all.SpellTags;
import com.robertx22.mine_and_slash.tags.imp.ElementTag;
import com.robertx22.mine_and_slash.tags.imp.SpellTag;
import com.robertx22.mine_and_slash.uncommon.enumclasses.ElementIds;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.resources.ResourceLocation;

public enum Elements implements IGUID
{
    Physical(Arrays.asList(new String[0]), Arrays.asList(ElementTags.PHYSICAL), "Physical", ChatFormatting.GOLD, "physical", "\u2600", SpellTags.PHYSICAL),
    Fire(Arrays.asList(new String[0]), Arrays.asList(ElementTags.ELEMENTAL), "Fire", ChatFormatting.RED, ElementIds.FIRE, "\u2600", SpellTags.FIRE),
    Cold(Arrays.asList(new String[0]), Arrays.asList(ElementTags.ELEMENTAL), "Cold", ChatFormatting.AQUA, ElementIds.WATER, "\u2600", SpellTags.COLD),
    Nature(Arrays.asList(new String[0]), Arrays.asList(ElementTags.ELEMENTAL), "Lightning", ChatFormatting.YELLOW, ElementIds.NATURE, "\u2600", SpellTags.LIGHTNING),
    Shadow(Arrays.asList(new String[0]), Arrays.asList(ElementTags.ALIGNMENT), "Chaos", ChatFormatting.DARK_PURPLE, "chaos", "\u2600", SpellTags.CHAOS),
    Elemental(Arrays.asList(ElementIds.NATURE, ElementIds.FIRE, ElementIds.WATER), Arrays.asList(ElementTags.ELEMENTAL), "Elemental", ChatFormatting.LIGHT_PURPLE, "elemental", "\u2600", SpellTags.PHYSICAL),
    ALL(Arrays.asList(ElementIds.NATURE, ElementIds.FIRE, ElementIds.WATER, Shadow.GUID()), Arrays.asList(new ElementTag[0]), "", ChatFormatting.LIGHT_PURPLE, "all", "\u2600", SpellTags.PHYSICAL);

    public SpellTag spellTag;
    public List<String> multiElements = new ArrayList<String>();
    public TagList<ElementTag> tags = new TagList(new ModTag[0]);
    public String dmgName;
    public String guidName;
    public String icon;
    public ChatFormatting format;
    private static List<Elements> allSingle;
    private static List<Elements> ele;

    private Elements(List<String> multiElements, List<ElementTag> tags, String dmgname, ChatFormatting format, String guidname, String icon, SpellTag tag) {
        this.multiElements = multiElements;
        this.tags.addAll(tags);
        this.dmgName = dmgname;
        this.format = format;
        this.guidName = guidname;
        this.icon = icon;
        this.spellTag = tag;
    }

    public boolean isValid() {
        return this != ALL;
    }

    public boolean shouldShowInStatPanel() {
        return this != ALL && this != Elemental;
    }

    public boolean isSingleElement() {
        return this.multiElements.isEmpty();
    }

    public String getIconNameDmg() {
        return this.getIconNameFormat(this.dmgName) + " Damage";
    }

    public String getIconNameDmgWithSpecialColor(ChatFormatting color) {
        return this.getIconNameFormat(this.dmgName) + color + " Damage";
    }

    public String getIconNameFormat() {
        return this.getIconNameFormat(this.dmgName);
    }

    public String getIconNameFormat(String str) {
        return this.format + this.icon + " " + str + ChatFormatting.GRAY;
    }

    public ResourceLocation getIconLocation() {
        return SlashRef.guiId("stat_icons/element_icons/" + this.GUID());
    }

    public static List<Elements> getAllSingle() {
        return allSingle;
    }

    public static List<Elements> getAllSingleElemental() {
        return ele;
    }

    public boolean elementsMatch(Elements other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (this.isSingleElement() && !other.isSingleElement() && other.multiElements.stream().anyMatch(x -> x.equals(this.guidName))) {
            return true;
        }
        return !this.isSingleElement() && other.isSingleElement() && this.multiElements.stream().anyMatch(x -> x.equals(other.guidName));
    }

    public String GUID() {
        return this.guidName;
    }

    static {
        allSingle = Arrays.stream(Elements.values()).filter(x -> x.isSingleElement() && x.isValid()).collect(Collectors.toList());
        ele = Arrays.stream(Elements.values()).filter(x -> x.tags.contains(ElementTags.ELEMENTAL) && x.isSingleElement() && x.isValid()).collect(Collectors.toList());
    }
}

