/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.effectdatas;

import com.robertx22.mine_and_slash.capability.player.helper.SocketedGem;
import com.robertx22.mine_and_slash.database.data.game_balance_config.GameBalanceConfig;
import com.robertx22.mine_and_slash.database.data.spells.components.Spell;
import com.robertx22.mine_and_slash.database.data.spells.entities.CalculatedSpellData;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.effectdatas.EffectEvent;
import com.robertx22.mine_and_slash.uncommon.effectdatas.rework.EventData;
import java.util.Objects;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class SpellStatsCalculationEvent
extends EffectEvent {
    public static String ID = "on_spell_stat_calc";
    int lvl;
    public CalculatedSpellData savedData;

    public String GUID() {
        return ID;
    }

    @Override
    public String getName() {
        return "Spell Calc Event";
    }

    public SpellStatsCalculationEvent(LivingEntity caster, String spellid) {
        super(caster, caster);
        Player p;
        SocketedGem gem;
        Spell spell = (Spell)ExileDB.Spells().get(spellid);
        this.savedData = this.create(Load.Unit((Entity)caster).getLevel(), caster, spell);
        this.lvl = Load.Unit((Entity)caster).getLevel();
        this.data.setString(EventData.STYLE, spell.config.getStyle().id);
        this.data.setString(EventData.SUMMON_TYPE, spell.config.summonType.id);
        this.data.setupNumber(EventData.AGGRO_RADIUS, spell.config.aggro_radius);
        this.data.setString(EventData.SPELL, spellid);
        float manamultilvl = GameBalanceConfig.get().MANA_COST_SCALING.getMultiFor(this.lvl);
        if (caster instanceof Player && (gem = Load.player(p = (Player)caster).getSkillGemInventory().getSpellGem(spell)) != null) {
            manamultilvl *= gem.getManaCostMulti();
        }
        this.data.setupNumber(EventData.CAST_TICKS, spell.config.getCastTimeTicks());
        this.data.setupNumber(EventData.MANA_COST, manamultilvl * spell.config.mana_cost.getValue(caster, spell));
        this.data.setupNumber(EventData.ENERGY_COST, manamultilvl * spell.config.ene_cost.getValue(caster, spell));
        this.data.setupNumber(EventData.COOLDOWN_TICKS, spell.config.cooldown_ticks);
        this.data.setupNumber(EventData.PROJECTILE_SPEED_MULTI, 1.0f);
        this.data.setupNumber(EventData.DURATION_MULTI, 1.0f);
        this.data.setupNumber(EventData.AREA_MULTI, 1.0f);
    }

    @Override
    protected void activate() {
        int cd = (int)Mth.m_14008_((double)this.data.getNumber((String)EventData.COOLDOWN_TICKS).number, (double)((double)this.getSpell().config.cooldown_ticks * GameBalanceConfig.get().MIN_SPELL_COOLDOWN_MULTI), (double)1000000.0);
        this.data.getNumber((String)EventData.COOLDOWN_TICKS).number = cd;
        this.savedData.data = this.data;
    }

    private CalculatedSpellData create(int lvl, LivingEntity caster, Spell spell) {
        Objects.requireNonNull(caster);
        CalculatedSpellData data = new CalculatedSpellData(this);
        data.spell_id = spell.GUID();
        data.lvl = lvl;
        data.caster_uuid = caster.m_20148_().toString();
        return data;
    }
}

