/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.effectdatas;

import com.robertx22.library_of_exile.main.MyPacket;
import com.robertx22.library_of_exile.main.Packets;
import com.robertx22.library_of_exile.utils.SoundUtils;
import com.robertx22.mine_and_slash.aoe_data.database.ailments.Ailment;
import com.robertx22.mine_and_slash.capability.entity.CooldownsData;
import com.robertx22.mine_and_slash.capability.entity.EntityData;
import com.robertx22.mine_and_slash.capability.player.data.PlayerConfigData;
import com.robertx22.mine_and_slash.config.forge.ServerContainer;
import com.robertx22.mine_and_slash.database.data.EntityConfig;
import com.robertx22.mine_and_slash.database.data.exile_effects.ExileEffect;
import com.robertx22.mine_and_slash.database.data.exile_effects.ExileEffectInstanceData;
import com.robertx22.mine_and_slash.database.data.game_balance_config.GameBalanceConfig;
import com.robertx22.mine_and_slash.database.data.rarities.MobRarity;
import com.robertx22.mine_and_slash.database.data.spells.entities.CalculatedSpellData;
import com.robertx22.mine_and_slash.database.data.spells.spell_classes.SpellCtx;
import com.robertx22.mine_and_slash.database.data.stats.layers.StatLayerData;
import com.robertx22.mine_and_slash.database.data.stats.types.offense.FullSwingDamage;
import com.robertx22.mine_and_slash.database.data.stats.types.resources.DamageAbsorbedByMana;
import com.robertx22.mine_and_slash.database.data.stats.types.resources.magic_shield.MagicShield;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.event_hooks.damage_hooks.util.AttackInformation;
import com.robertx22.mine_and_slash.loot.LootUtils;
import com.robertx22.mine_and_slash.maps.MapData;
import com.robertx22.mine_and_slash.mixin_ducks.DamageSourceDuck;
import com.robertx22.mine_and_slash.mixin_ducks.LivingEntityAccesor;
import com.robertx22.mine_and_slash.mixin_ducks.ProjectileEntityDuck;
import com.robertx22.mine_and_slash.mmorpg.MMORPG;
import com.robertx22.mine_and_slash.mmorpg.SlashRef;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.uncommon.MathHelper;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.datasaving.StackSaving;
import com.robertx22.mine_and_slash.uncommon.effectdatas.EffectEvent;
import com.robertx22.mine_and_slash.uncommon.effectdatas.EventBuilder;
import com.robertx22.mine_and_slash.uncommon.effectdatas.GenerateThreatEvent;
import com.robertx22.mine_and_slash.uncommon.effectdatas.ThreatGenType;
import com.robertx22.mine_and_slash.uncommon.effectdatas.rework.EventData;
import com.robertx22.mine_and_slash.uncommon.enumclasses.AttackType;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.enumclasses.WeaponTypes;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.AllyOrEnemy;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.DashUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.HealthUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.NumberUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.WorldUtils;
import com.robertx22.mine_and_slash.vanilla_mc.packets.DmgNumPacket;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class DamageEvent
extends EffectEvent {
    public static ResourceKey<DamageType> DAMAGE_TYPE = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)SlashRef.id("mod"));
    public static String ID = "on_damage";
    public LivingEntity petEntity;
    public static String dmgSourceName = "mmorpg.custom_damage";
    AttackInformation attackInfo;
    private HashMap<Elements, Integer> bonusElementDamageMap = new HashMap();
    static AttributeModifier NO_KNOCKBACK = new AttributeModifier(UUID.fromString("e926df30-c376-11ea-87d0-0242ac131053"), Attributes.f_22278_.m_22087_(), 100.0, AttributeModifier.Operation.ADDITION);
    public float wepdmgMulti = 1.0f;
    public boolean absorbedCompletely = false;

    public String GUID() {
        return ID;
    }

    protected DamageEvent(AttackInformation attackInfo, LivingEntity source, LivingEntity target, float dmg) {
        super(dmg, source, target);
        this.attackInfo = attackInfo;
        this.calcBlock();
        this.addMobDamageMultipliers();
    }

    public void addMobDamageMultipliers() {
        try {
            float penalty;
            if (!(this.source instanceof Player)) {
                MapData map;
                float penalty2;
                if (this.target instanceof Player && this.sourceData.getLevel() > this.targetData.getLevel() && (penalty2 = LootUtils.getLevelDistancePunishmentMulti(this.sourceData.getLevel(), this.targetData.getLevel())) < 1.0f) {
                    float dmgmulti = 2.0f - penalty2;
                    this.addMoreMulti(Words.HIGH_LVL_MOB_DMG_MULTI.locName(), EventData.NUMBER, dmgmulti);
                }
                GameBalanceConfig balance = GameBalanceConfig.get();
                if (balance.MOB_DMG_POWER_SCALING != 1.0) {
                    float multi = (float)(balance.MOB_DMG_POWER_SCALING_BASE * (double)((float)Math.pow(balance.MOB_DMG_POWER_SCALING, this.sourceData.getLevel())));
                    this.addMoreMulti(Words.LVL_EXPONENT_MOB_DMG.locName(), EventData.NUMBER, multi);
                }
                MobRarity rar = this.sourceData.getMobRarity();
                float enconfigmulti = (float)ExileDB.getEntityConfig((LivingEntity)this.source, (EntityData)this.sourceData).dmg_multi;
                this.addMoreMulti(Words.MOB_RARITY_MULTI.locName(), EventData.NUMBER, rar.DamageMultiplier());
                if (enconfigmulti != 1.0f) {
                    this.addMoreMulti(Words.MOB_CONFIG_MULTI.locName(), EventData.NUMBER, enconfigmulti);
                }
                if (WorldUtils.isDungeonWorld(this.source.m_9236_()) && this.target instanceof Player && (map = Load.mapAt(this.target.m_9236_(), this.target.m_20183_())) != null && map.map != null && !map.map.getStatReq().meetsReq(map.map.lvl, Load.Unit((Entity)this.target))) {
                    float minusres = map.map.getStatReq().getLackingResistNumber(map.map.lvl, Load.Unit((Entity)this.target));
                    float multi = Math.max((float)((double)minusres * GameBalanceConfig.get().MOB_DMG_MULTI_PER_MAP_RES_REQ_LACKING), 2.0f);
                    this.addMoreMulti(Words.MAP_RES_REQ_LACK_DMG_MULTI.locName(), EventData.NUMBER, multi);
                }
            } else if (this.targetData.getLevel() > this.sourceData.getLevel() && !(this.target instanceof Player) && (penalty = LootUtils.getLevelDistancePunishmentMulti(this.sourceData.getLevel(), this.targetData.getLevel())) < 1.0f) {
                this.addMoreMulti(Words.DMG_TO_HIGH_LVL_MOB_DMG_MULTI.locName(), EventData.NUMBER, penalty);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Component getDamageName() {
        try {
            if (this.data.isBasicAttack()) {
                return Component.m_237113_((String)"Attack");
            }
            if (this.data.isSpellEffect()) {
                return this.getSpell().locName();
            }
            String id = this.data.getString(EventData.AILMENT);
            if (ExileDB.Ailments().isRegistered(id)) {
                Ailment ailment = (Ailment)ExileDB.Ailments().get(id);
                return ailment.locName();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Component.m_237113_((String)"[Error, dmg isn't a basic attack, spell or ailment]");
    }

    public AttackType getAttackType() {
        return this.data.getAttackType();
    }

    public Elements getElement() {
        return this.data.getElement();
    }

    public void addBonusEleDmg(Elements element, float dmg) {
        this.bonusElementDamageMap.put(element, (int)((float)this.bonusElementDamageMap.getOrDefault((Object)element, 0).intValue() + dmg));
    }

    private void calcBlock() {
        Vec3 vec3d;
        if (this.targetData.getResources().getEnergy() < 1.0f) {
            return;
        }
        if (this.target.m_21254_() && this.attackInfo != null && (vec3d = this.attackInfo.getSource().m_7270_()) != null) {
            Vec3 vec3d2 = this.target.m_20252_(1.0f);
            Vec3 vec3d3 = vec3d.m_82505_(this.target.m_20182_()).m_82541_();
            vec3d3 = new Vec3(vec3d3.f_82479_, 0.0, vec3d3.f_82481_);
            if (vec3d3.m_82526_(vec3d2) < 0.0) {
                this.data.setHitAvoided(EventData.IS_BLOCKED);
            }
        }
    }

    public float getActualDamage() {
        float dmg = this.data.getNumber();
        if (dmg <= 0.0f) {
            return 0.0f;
        }
        return dmg;
    }

    private void calcAttackCooldown() {
        GearItemData gear;
        float cool = 1.0f;
        WeaponTypes weaponType = this.data.getWeaponType();
        if (weaponType.isMelee() && this.source instanceof Player && (gear = (GearItemData)StackSaving.GEARS.loadFrom(this.source.m_21205_())) != null) {
            float atkpersec = 1.0f;
            float secWaited = (float)(this.source.f_19797_ - this.source.m_21215_()) / 20.0f;
            float secNeededToWaitForFull = 1.0f / atkpersec;
            cool = secWaited / secNeededToWaitForFull;
            cool = Mth.m_14036_((float)cool, (float)0.0f, (float)1.0f);
        }
        this.data.setupNumber(EventData.ATTACK_COOLDOWN, cool);
    }

    private float getAttackSpeedDamageMulti() {
        float multi = 1.0f;
        float cool = this.data.getNumber((String)EventData.ATTACK_COOLDOWN).number;
        if (cool < 0.1f) {
            multi = 0.0f;
            this.cancelDamage();
        }
        if (cool > 0.8f) {
            multi = this.sourceData.getUnit().getCalculatedStat(FullSwingDamage.getInstance()).getMultiplier();
        }
        return multi;
    }

    private void modifyIfArrowDamage() {
        if (this.attackInfo != null && this.attackInfo.getSource() != null && this.attackInfo.getSource().m_7640_() instanceof ProjectileEntityDuck && this.data.getWeaponType() == WeaponTypes.bow) {
            ProjectileEntityDuck duck = (ProjectileEntityDuck)this.attackInfo.getSource().m_7640_();
            float arrowmulti = duck.my$getDmgMulti();
            this.addMoreMulti(Words.ARROW_DRAW_AMOUNT_MULTI.locName(), EventData.NUMBER, arrowmulti);
        }
    }

    public boolean areBothPlayers() {
        return this.source instanceof ServerPlayer && this.target instanceof ServerPlayer;
    }

    public void cancelDamage() {
        this.data.getNumber((String)EventData.NUMBER).number = 0.0f;
        this.data.setBoolean(EventData.DISABLE_KNOCKBACK, true);
        this.data.setBoolean(EventData.CANCELED, true);
        if (this.attackInfo != null) {
            this.attackInfo.setAmount(0.0f);
            this.attackInfo.setCanceled(true);
        }
    }

    public boolean stopFriendlyFire() {
        if (WorldUtils.isMapWorldClass(this.source.m_9236_())) {
            if (AllyOrEnemy.allies.is((Entity)this.source, this.target)) {
                this.cancelDamage();
                return true;
            }
        } else if (this.source instanceof Player && AllyOrEnemy.allies.is((Entity)this.source, this.target)) {
            this.cancelDamage();
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return "Damage Event";
    }

    @Override
    public void initBeforeActivating() {
        this.calcAttackCooldown();
        if (this.source instanceof Player) {
            if (this.data.isBasicAttack()) {
                this.addMoreMulti(Words.ATTACK_SPEED_MULTI.locName(), EventData.NUMBER, this.getAttackSpeedDamageMulti());
            }
            this.modifyIfArrowDamage();
        }
        if (this.areBothPlayers()) {
            this.addMoreMulti(Words.PVP_DMG_MULTI.locName(), EventData.NUMBER, ((Double)ServerContainer.get().PVP_DMG_MULTI.get()).floatValue());
        }
        if (this.data.isBasicAttack() && this.attackInfo != null && this.attackInfo.weaponData != null && !this.data.getBoolean(EventData.UNARMED_ATTACK)) {
            float multi;
            this.wepdmgMulti = multi = this.attackInfo.weaponData.GetBaseGearType().getGearSlot().getBasicDamageMulti();
            this.addMoreMulti(Words.WEAPON_BASIC_ATTACK_DMG_MULTI.locName(), EventData.NUMBER, multi);
        }
    }

    public MutableComponent getDamageMessage(DmgByElement info) {
        MutableComponent ele = Component.m_237113_((String)this.getElement().getIconNameDmg());
        if (info.isMixedDamage()) {
            ele = Component.m_237113_((String)"\u2600 ").m_7220_((Component)Words.MULTI_ELEMENT.locName()).m_130940_(ChatFormatting.LIGHT_PURPLE);
        }
        return Words.DAMAGE_MESSAGE.locName(this.source.m_5446_(), MMORPG.DECIMAL_FORMAT.format(info.totalDmg), ele, this.getDamageName()).m_130948_(Style.f_131099_.m_131157_(ChatFormatting.RED).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)this.getInfoHoverMessage(info, true))));
    }

    public MutableComponent getInfoHoverMessage(DmgByElement info, boolean doBonusDmg) {
        MutableComponent msg = Component.m_237119_();
        if (this.isSpell()) {
            msg.m_7220_((Component)Component.m_237113_((String)"Spell: ").m_7220_((Component)this.getSpell().locName()).m_130946_("\n").m_130940_(ChatFormatting.AQUA));
        }
        if (this.data.isBasicAttack()) {
            msg.m_7220_((Component)Component.m_237113_((String)"Basic Attack\n").m_130940_(ChatFormatting.RED));
        }
        if (this.data.getAttackType() == AttackType.dot) {
            msg.m_7220_((Component)Component.m_237113_((String)"Damage Over Time\n").m_130940_(ChatFormatting.RED));
        }
        if (!this.data.getString(EventData.AILMENT).isEmpty()) {
            String ailment = this.data.getString(EventData.AILMENT);
            Ailment ailment2 = (Ailment)ExileDB.Ailments().get(ailment);
            msg.m_7220_((Component)Component.m_237113_((String)"Ailment: ").m_7220_((Component)ailment2.locName()).m_130946_("\n").m_130940_(ailment2.element.format));
        }
        msg.m_7220_((Component)Component.m_237113_((String)("\n" + this.getElement().getIconNameDmg() + ":\n")).m_130940_(this.getElement().format));
        msg.m_7220_((Component)Component.m_237113_((String)("Base Damage: " + (int)this.data.getOriginalNumber((String)EventData.NUMBER).number + "\n")).m_130940_(ChatFormatting.BLUE));
        msg.m_7220_((Component)Component.m_237113_((String)"Damage Info: \n").m_130940_(ChatFormatting.RED));
        for (StatLayerData statLayerData : this.getSortedLayers()) {
            if (!statLayerData.numberID.equals(EventData.NUMBER)) continue;
            msg.m_7220_((Component)statLayerData.getLayer().getTooltip(statLayerData).m_130946_("\n"));
        }
        if (!this.getMoreMultis().isEmpty()) {
            msg.m_7220_((Component)Component.m_237113_((String)"Multipliers: \n").m_130940_(ChatFormatting.LIGHT_PURPLE));
            for (EffectEvent.MoreMultiData moreMultiData : this.getMoreMultis()) {
                if (!moreMultiData.numberid.equals(EventData.NUMBER)) continue;
                msg.m_7220_((Component)moreMultiData.text.m_130946_(": ").m_7220_((Component)Component.m_237113_((String)("x" + MMORPG.DECIMAL_FORMAT.format(moreMultiData.multi))))).m_130946_("\n");
            }
        }
        msg.m_7220_((Component)Component.m_237113_((String)("Final Damage: " + info.dmgmap.getOrDefault((Object)this.getElement(), Float.valueOf(0.0f)).intValue() + "\n")).m_130940_(ChatFormatting.GOLD));
        if (doBonusDmg && info.isMixedDamage()) {
            for (Map.Entry entry : info.dmgmap.entrySet()) {
                if (entry.getKey() == this.getElement()) continue;
                msg.m_7220_((Component)Component.m_237113_((String)"\n- Bonus Damage Types:\n").m_130940_(ChatFormatting.YELLOW));
                DamageEvent dmg = info.eventMap.get(entry.getKey());
                msg.m_7220_((Component)dmg.getInfoHoverMessage(info, false));
            }
        }
        if (doBonusDmg) {
            msg.m_7220_((Component)Component.m_237113_((String)("Total Combined Damage: " + (int)info.totalDmg + "\n")).m_130940_(ChatFormatting.GOLD));
        }
        return msg;
    }

    @Override
    protected void activate() {
        LivingEntity e2;
        Player p;
        if (this.target.m_21223_() <= 0.0f || !this.target.m_6084_()) {
            return;
        }
        if (this.stopFriendlyFire()) {
            return;
        }
        this.targetData.lastDamageTaken = this;
        DmgByElement info = this.calculateAllBonusElementalDamage();
        if (this.data.isHitAvoided()) {
            if (this.attackInfo != null) {
                this.attackInfo.setAmount(0.0f);
                this.attackInfo.setCanceled(true);
            }
            this.cancelDamage();
            this.sendDamageParticle(info);
            SoundUtils.playSound((Entity)this.target, (SoundEvent)SoundEvents.f_12346_, (float)1.0f, (float)1.5f);
            return;
        }
        float dmg = info.totalDmg;
        LivingEntity livingEntity = this.target;
        if (livingEntity instanceof Player) {
            p = (Player)livingEntity;
            if (Load.player((Player)p).config.isConfigEnabled(PlayerConfigData.Config.DAMAGE_MESSAGES)) {
                try {
                    p.m_213846_((Component)this.getDamageMessage(info));
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        if ((e2 = this.source) instanceof Player) {
            p = (Player)e2;
            if (Load.player((Player)p).config.isConfigEnabled(PlayerConfigData.Config.DAMAGE_MESSAGES)) {
                p.m_213846_((Component)this.getDamageMessage(info));
            }
        }
        if ((e2 = this.target) instanceof Player) {
            p = (Player)e2;
            dmg = DamageAbsorbedByMana.modifyEntityDamage(this, dmg);
            dmg = MagicShield.modifyEntityDamage(this, dmg);
        }
        float vanillaDamage = HealthUtils.realToVanilla(this.target, dmg);
        if (this.absorbedCompletely && vanillaDamage < 1.0E-4f) {
            vanillaDamage = 1.0E-4f;
        }
        if (this.data.isCanceled()) {
            this.cancelDamage();
            return;
        }
        AttributeInstance attri = this.target.m_21051_(Attributes.f_22278_);
        if ((this.data.getBoolean(EventData.DISABLE_KNOCKBACK) || this.getAttackType() == AttackType.dot) && !attri.m_22109_(NO_KNOCKBACK)) {
            attri.m_22125_(NO_KNOCKBACK);
        }
        DamageSource dmgsource = new DamageSource((Holder)((Registry)this.source.m_9236_().m_9598_().m_6632_(Registries.f_268580_).get()).m_246971_(DAMAGE_TYPE), (Entity)this.source, (Entity)this.source, this.source.m_20182_());
        if (this.data.isSpellEffect()) {
            if (!this.data.getBoolean(EventData.DISABLE_KNOCKBACK) && dmg > 0.0f && !this.data.isHitAvoided()) {
                DashUtils.knockback(this.source, this.target);
            }
            LivingEntityAccesor duck = (LivingEntityAccesor)this.target;
            SoundEvent sound = SoundEvents.f_11915_;
            float volume = duck.myGetHurtVolume();
            float pitch = duck.myGetHurtPitch();
            SoundUtils.playSound((Entity)this.target, (SoundEvent)sound, (float)volume, (float)pitch);
        }
        EntityConfig config = ExileDB.getEntityConfig(this.target, Load.Unit((Entity)this.target));
        if (!(this.target instanceof Player) && config != null && config.set_health_damage_override) {
            float hp = MathHelper.clamp(this.target.m_21223_() - vanillaDamage, 0.0f, this.target.m_21233_());
            this.target.m_21153_(hp);
            if (this.target.m_21223_() <= 0.0f) {
                this.target.m_6667_(this.target.m_269291_().m_269333_(this.source));
            }
            if (this.attackInfo != null) {
                this.attackInfo.setAmount(1.0E-6f);
            }
        } else if (this.attackInfo != null) {
            DamageSourceDuck duck = (DamageSourceDuck)this.attackInfo.getSource();
            duck.setMnsDamage(vanillaDamage);
            duck.tryOverrideDmgWithMns(this.attackInfo);
        } else if (!(this.target instanceof Player)) {
            int inv = this.target.f_19802_;
            this.target.f_19802_ = 0;
            this.target.m_6469_(dmgsource, vanillaDamage);
            this.target.f_19802_ = inv;
        } else {
            this.target.m_6469_(dmgsource, vanillaDamage);
        }
        if (attri.m_22109_(NO_KNOCKBACK)) {
            attri.m_22130_(NO_KNOCKBACK);
        }
        if (dmg > 0.0f) {
            LivingEntity e32;
            if (this.data.isBasicAttack()) {
                for (Map.Entry e32 : this.targetData.getStatusEffectsData().exileMap.entrySet().stream().toList()) {
                    if (((ExileEffectInstanceData)e32.getValue()).shouldRemove()) continue;
                    ExileEffectInstanceData data = (ExileEffectInstanceData)e32.getValue();
                    CalculatedSpellData sd = data.calcSpell;
                    SpellCtx ctx = SpellCtx.onEntityBasicAttacked(this.source, sd, this.target);
                    ExileEffect eff = (ExileEffect)ExileDB.ExileEffects().get((String)e32.getKey());
                    if (eff.spell == null) continue;
                    eff.spell.tryActivate(SpellCtx.ON_ENTITY_ATTACKED, ctx);
                }
            }
            if ((e32 = this.source) instanceof Player) {
                Player p2 = (Player)e32;
                p2.m_21335_((Entity)this.target);
                this.sourceData.getCooldowns().setOnCooldown(CooldownsData.IN_COMBAT, 200);
                if (this.target instanceof Mob) {
                    if (this.petEntity instanceof LivingEntity && Load.Unit((Entity)this.petEntity).isSummon()) {
                        threatEvent = new GenerateThreatEvent(this.petEntity, (Mob)this.target, ThreatGenType.deal_dmg, dmg);
                        threatEvent.Activate();
                    } else {
                        threatEvent = new GenerateThreatEvent((LivingEntity)((Player)this.source), (Mob)this.target, ThreatGenType.deal_dmg, dmg);
                        threatEvent.Activate();
                    }
                }
            } else if (this.source instanceof Mob && this.target instanceof Player) {
                this.targetData.getCooldowns().setOnCooldown(CooldownsData.IN_COMBAT, 200);
                threatEvent = new GenerateThreatEvent((LivingEntity)((Player)this.target), (Mob)this.source, ThreatGenType.take_dmg, dmg);
                threatEvent.Activate();
            }
            this.sendDamageParticle(info);
        }
    }

    private void sendDamageParticle(DmgByElement info) {
        Object text = "";
        if (this.source instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)this.source;
            if (this.data.isHitAvoided()) {
                text = this.getAttackType().isAttack() ? "Dodge" : "Resist";
                DmgNumPacket packet = new DmgNumPacket(this.target, (String)text, false, ChatFormatting.GOLD);
                Packets.sendToClient((Player)player, (MyPacket)packet);
                return;
            }
            for (Map.Entry<Elements, Float> entry : info.dmgmap.entrySet()) {
                if (entry.getValue().intValue() <= 0) continue;
                text = entry.getKey().format + NumberUtils.formatDamageNumber(this, entry.getValue().intValue());
                DmgNumPacket packet = new DmgNumPacket(this.target, (String)text, this.data.isCrit(), entry.getKey().format);
                Packets.sendToClient((Player)player, (MyPacket)packet);
            }
        }
    }

    public DmgByElement calculateAllBonusElementalDamage() {
        DmgByElement info = new DmgByElement();
        for (Map.Entry<Elements, Integer> entry : this.bonusElementDamageMap.entrySet()) {
            if (entry.getValue() <= 0) continue;
            DamageEvent bonus = EventBuilder.ofDamage(this.attackInfo, this.source, this.target, entry.getValue().intValue()).setupDamage(AttackType.hit, this.data.getWeaponType(), this.data.getStyle()).set(x -> {
                if (this.wepdmgMulti != 1.0f) {
                    x.addMoreMulti(Words.WEAPON_BASIC_ATTACK_DMG_MULTI.locName(), EventData.NUMBER, this.wepdmgMulti);
                }
                x.setElement((Elements)((Object)((Object)entry.getKey())));
            }).build();
            if (this.isSpell()) {
                bonus.data.setString(EventData.SPELL, this.data.getString(EventData.SPELL));
            }
            bonus.data.setBoolean(EventData.IS_BONUS_ELEMENT_DAMAGE, true);
            bonus.data.setBoolean(EventData.IS_BASIC_ATTACK, this.data.getBoolean(EventData.IS_BASIC_ATTACK));
            bonus.data.setBoolean(EventData.IS_ATTACK_FULLY_CHARGED, this.data.getBoolean(EventData.IS_ATTACK_FULLY_CHARGED));
            bonus.data.setupNumber(EventData.ATTACK_COOLDOWN, this.data.getNumber((String)EventData.ATTACK_COOLDOWN).number);
            bonus.data.setupNumber(EventData.DMG_EFFECTIVENESS, this.data.getNumber((String)EventData.DMG_EFFECTIVENESS).number);
            bonus.calculateEffects();
            bonus.setElement(entry.getKey());
            bonus.calculateEffects();
            float dmg = bonus.getActualDamage();
            info.addDmg(bonus, dmg, bonus.getElement());
        }
        info.addDmg(this, this.getActualDamage(), this.getElement());
        return info;
    }

    public Elements GetElement() {
        return this.getElement();
    }

    public void setElement(Elements ele) {
        this.data.setElement(ele);
    }

    public void setisAilmentDamage(Ailment al) {
        this.data.setString(EventData.AILMENT, al.GUID());
    }

    public void setPenetration(float val) {
        this.data.getNumber((String)EventData.PENETRATION).number = val;
    }

    public float getPenetration() {
        return this.data.getNumber((String)EventData.PENETRATION).number;
    }

    public static class DmgByElement {
        private HashMap<Elements, Float> dmgmap = new HashMap();
        private HashMap<Elements, DamageEvent> eventMap = new HashMap();
        public float totalDmg = 0.0f;

        public boolean isMixedDamage() {
            int bonusdmg = (int)this.dmgmap.entrySet().stream().filter(x -> true).count();
            return bonusdmg > 1;
        }

        public void addDmg(DamageEvent event, float dmg, Elements element) {
            Elements ele = element;
            if (ele == null) {
                ele = Elements.Physical;
            }
            float total = this.dmgmap.getOrDefault((Object)element, Float.valueOf(0.0f)).floatValue() + dmg;
            this.dmgmap.put(ele, Float.valueOf(total));
            this.eventMap.put(ele, event);
            this.totalDmg += dmg;
        }
    }
}

