/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.coins;

import com.robertx22.library_of_exile.registry.IGUID;
import com.robertx22.mine_and_slash.database.data.profession.ExplainedResult;
import com.robertx22.mine_and_slash.database.data.profession.LeveledItem;
import com.robertx22.mine_and_slash.maps.MapData;
import com.robertx22.mine_and_slash.mmorpg.registers.common.items.SlashItems;
import com.robertx22.mine_and_slash.uncommon.coins.CoinItem;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.temp.SkillItemTier;
import java.util.HashMap;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class Coin
implements IGUID {
    public static HashMap<String, Coin> ALL = new HashMap();
    private static String PROPHECY_ID = "prophecy";
    public static Coin PROPHECY = new Coin(PROPHECY_ID, "Prophecy", new Validator(){

        @Override
        public ExplainedResult isCoinValid(Player p, ItemStack stack) {
            MapData map = Load.mapAt(p.m_9236_(), p.m_20183_());
            if (map == null) {
                return ExplainedResult.failure((Component)Component.m_237113_((String)"Not Inside a Map - Can't Check"));
            }
            SkillItemTier range = LeveledItem.getTier(stack);
            if (!range.levelRange.isLevelInRange(map.map.getLevel())) {
                return ExplainedResult.failure((Component)Component.m_237113_((String)"Coin not usable in this map - Wrong Level"));
            }
            return ExplainedResult.success((Component)Component.m_237113_((String)"Usable Coin"));
        }
    }, x -> {
        if (x.m_41720_() == SlashItems.COINS.get(PROPHECY_ID).get()) {
            return 1;
        }
        return 0;
    });
    public String id;
    public String locname;
    Validator validator;
    Function<ItemStack, Integer> value;

    public static void init() {
    }

    public Coin(String id, String locname, Validator validator, Function<ItemStack, Integer> value) {
        this.id = id;
        this.locname = locname;
        this.validator = validator;
        this.value = value;
        ALL.put(id, this);
    }

    public CoinItem getItem() {
        return SlashItems.COINS.get(this.id).get();
    }

    public int getTotalFromInventory(Player p) {
        int num = 0;
        for (int i = 0; i < p.m_150109_().m_6643_(); ++i) {
            ItemStack stack = p.m_150109_().m_8020_(i);
            num += this.getValueIgnoringStackCount(p, stack) * stack.m_41613_();
        }
        return num;
    }

    public ExplainedResult spend(Player p, int amount) {
        int tospend = amount;
        for (int i = 0; i < p.m_150109_().m_6643_(); ++i) {
            ItemStack stack = p.m_150109_().m_8020_(i);
            int val = this.getValueIgnoringStackCount(p, stack);
            if (val <= 0) continue;
            int max = val * stack.m_41613_();
            if (tospend > max) {
                tospend -= max;
                stack.m_41774_(stack.m_41613_());
                continue;
            }
            while (tospend > 0 && stack.m_41613_() > 0) {
                tospend -= val;
                stack.m_41774_(1);
            }
        }
        if (tospend > 0) {
            return ExplainedResult.failure((Component)Component.m_237113_((String)"Didn't find enough currency to spend, this is a bug!"));
        }
        return ExplainedResult.success((Component)Component.m_237113_((String)("Spent " + amount + this.locname + " coins")));
    }

    public int getValueIgnoringStackCount(Player p, ItemStack stack) {
        if (!this.validator.isCoinValid((Player)p, (ItemStack)stack).can) {
            return 0;
        }
        return this.value.apply(stack);
    }

    public String GUID() {
        return this.id;
    }

    public static abstract class Validator {
        public abstract ExplainedResult isCoinValid(Player var1, ItemStack var2);
    }
}

