/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.saveclasses.unit.stat_calc;

import com.robertx22.mine_and_slash.capability.entity.EntityData;
import com.robertx22.mine_and_slash.capability.player.PlayerData;
import com.robertx22.mine_and_slash.capability.player.helper.GemInventoryHelper;
import com.robertx22.mine_and_slash.capability.player.helper.SocketedGem;
import com.robertx22.mine_and_slash.database.data.spells.components.Spell;
import com.robertx22.mine_and_slash.database.data.stats.Stat;
import com.robertx22.mine_and_slash.database.data.stats.datapacks.stats.AttributeStat;
import com.robertx22.mine_and_slash.event_hooks.damage_hooks.util.AttackInformation;
import com.robertx22.mine_and_slash.event_hooks.my_events.CollectGearEvent;
import com.robertx22.mine_and_slash.gui.screens.stat_gui.StatCalcInfoData;
import com.robertx22.mine_and_slash.saveclasses.ExactStatData;
import com.robertx22.mine_and_slash.saveclasses.skill_gem.SkillGemData;
import com.robertx22.mine_and_slash.saveclasses.unit.GearData;
import com.robertx22.mine_and_slash.saveclasses.unit.InCalcStatContainer;
import com.robertx22.mine_and_slash.saveclasses.unit.StatContainer;
import com.robertx22.mine_and_slash.saveclasses.unit.StatData;
import com.robertx22.mine_and_slash.saveclasses.unit.Unit;
import com.robertx22.mine_and_slash.saveclasses.unit.stat_calc.CtxStats;
import com.robertx22.mine_and_slash.saveclasses.unit.stat_calc.InCalc;
import com.robertx22.mine_and_slash.saveclasses.unit.stat_ctx.GearStatCtx;
import com.robertx22.mine_and_slash.saveclasses.unit.stat_ctx.SimpleStatCtx;
import com.robertx22.mine_and_slash.saveclasses.unit.stat_ctx.StatContext;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.interfaces.AddToAfterCalcEnd;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.Cached;
import com.robertx22.mine_and_slash.uncommon.stat_calculation.CommonStatUtils;
import com.robertx22.mine_and_slash.uncommon.stat_calculation.MobStatUtils;
import com.robertx22.mine_and_slash.uncommon.stat_calculation.PlayerStatUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;

public class StatCalculation {
    public static List<StatContext> getStatsWithoutSuppGems(LivingEntity entity, EntityData data, AttackInformation dmgData) {
        List<Object> statContexts = new ArrayList();
        ArrayList<GearData> gears = new ArrayList<GearData>();
        new CollectGearEvent.CollectedGearStacks(entity, gears, dmgData);
        statContexts = StatCalculation.collectStatsWithCtx(entity, data, gears);
        statContexts.removeIf(x -> x.stats.isEmpty());
        if (entity instanceof Player) {
            Player p = (Player)entity;
            PlayerData pd = Load.player(p);
            pd.ctxs = new StatCalcInfoData();
            for (StatContext statContext : statContexts) {
                if (!(statContext instanceof SimpleStatCtx)) continue;
                SimpleStatCtx s = (SimpleStatCtx)statContext;
                pd.ctxs.list.add(s);
            }
        }
        return statContexts;
    }

    public static void calc(Unit unit, List<StatContext> statsWithoutSuppGems, LivingEntity entity, int skillGem, AttackInformation dmgData) {
        if (entity.m_9236_().f_46443_) {
            return;
        }
        EntityData data = Load.Unit((Entity)entity);
        unit.clearStats();
        ArrayList<StatContext> gemstats = new ArrayList<StatContext>();
        if (entity instanceof Player) {
            Player p = (Player)entity;
            PlayerData playerData = Load.player(p);
            gemstats.addAll(StatCalculation.collectGemStats(p, data, playerData, skillGem));
        }
        InCalcStatContainer statCalc = new InCalcStatContainer();
        ArrayList<StatContext> allstats = new ArrayList<StatContext>();
        allstats.addAll(gemstats);
        allstats.addAll(statsWithoutSuppGems);
        CtxStats sc = new CtxStats(allstats);
        sc.applyCtxModifierStats();
        sc.applyToInCalc(statCalc);
        if (entity instanceof Player) {
            Player player = (Player)entity;
        }
        InCalc incalc = new InCalc(unit);
        incalc.addVanillaHpToStats(entity, statCalc);
        incalc.modify(data, statCalc);
        unit.setStats(statCalc.calculate());
        HashMap<String, StatData> stats = new HashMap<String, StatData>(unit.getStats().stats);
        StatContainer copiedStats = unit.getStats().clone();
        for (Map.Entry<String, StatData> en : stats.entrySet()) {
            Stat stat = en.getValue().GetStat();
            if (!(stat instanceof AddToAfterCalcEnd)) continue;
            AddToAfterCalcEnd aff = (AddToAfterCalcEnd)((Object)stat);
            aff.affectStats(copiedStats, unit.getStats(), en.getValue());
        }
        for (StatData stat : unit.getStats().stats.values()) {
            stat.softCapStat(unit);
        }
        Cached.VANILLA_STAT_UIDS_TO_CLEAR_EVERY_STAT_CALC.forEach(x -> {
            AttributeInstance in = entity.m_21051_((Attribute)x.left);
            if (in != null && in.m_22111_((UUID)x.right) != null) {
                in.m_22120_((UUID)x.right);
            }
        });
        unit.getStats().stats.values().forEach(x -> {
            if (x.GetStat() instanceof AttributeStat) {
                AttributeStat stat = (AttributeStat)x.GetStat();
                stat.addToEntity(entity, (StatData)x);
            }
        });
    }

    private static List<StatContext> collectGemStats(Player p, EntityData data, PlayerData playerData, int skillGem) {
        ArrayList<StatContext> statContexts = new ArrayList<StatContext>();
        if (skillGem > -1 && skillGem <= GemInventoryHelper.MAX_SKILL_GEMS) {
            List<ExactStatData> stats;
            SocketedGem gem = playerData.getSkillGemInventory().getHotbarGem(skillGem);
            for (SkillGemData d : gem.getSupportDatas()) {
                if (d.getSupport() == null) continue;
                statContexts.add(new SimpleStatCtx(StatContext.StatCtxType.SUPPORT_GEM, d.getSupport().GetAllStats(data, d)));
            }
            Spell spell = gem.getSpell();
            if (spell != null && !(stats = spell.getStats(p)).isEmpty()) {
                statContexts.add(new SimpleStatCtx(StatContext.StatCtxType.INNATE_SPELL, stats));
            }
        }
        return statContexts;
    }

    private static List<StatContext> collectStatsWithCtx(LivingEntity entity, EntityData data, List<GearData> gears) {
        ArrayList<StatContext> statContexts = new ArrayList<StatContext>();
        statContexts.addAll(CommonStatUtils.addExactCustomStats(entity));
        statContexts.add(data.getStatusEffectsData().getStats(entity));
        statContexts.addAll(StatCalculation.addGearStats(gears));
        statContexts.addAll(CommonStatUtils.addMapAffixStats(entity));
        statContexts.addAll(CommonStatUtils.addBaseStats(entity));
        if (entity instanceof Player) {
            Player p = (Player)entity;
            PlayerData playerData = Load.player(p);
            playerData.aurasOn = new ArrayList<String>();
            for (SkillGemData aura : playerData.getSkillGemInventory().getAurasGems()) {
                playerData.aurasOn.add(aura.id);
            }
            statContexts.add(CommonStatUtils.addStatCompat((LivingEntity)p));
            statContexts.addAll(PlayerStatUtils.addToolStats(p));
            statContexts.add(PlayerStatUtils.addBonusExpPerCharacters(p));
            statContexts.addAll(playerData.buff.getStatAndContext((LivingEntity)p));
            statContexts.addAll(playerData.getSkillGemInventory().getAuraStats(entity));
            statContexts.addAll(playerData.getJewels().getStatAndContext(entity));
            statContexts.addAll(playerData.statPoints.getStatAndContext(entity));
            statContexts.addAll(PlayerStatUtils.addNewbieElementalResists(data));
            statContexts.addAll(playerData.talents.getStatAndContext(entity));
            statContexts.addAll(playerData.ascClass.getStatAndContext(entity));
            statContexts.addAll(playerData.prophecy.getStatAndContext(entity));
        } else {
            statContexts.addAll(MobStatUtils.getMobBaseStats(data, entity));
            if (data.isSummon()) {
                statContexts.addAll(MobStatUtils.addSummonStats((TamableAnimal)entity));
            } else {
                statContexts.addAll(MobStatUtils.getAffixStats(entity));
                statContexts.addAll(MobStatUtils.getWorldMultiplierStats(entity));
                statContexts.addAll(MobStatUtils.addMapTierStats(entity));
                statContexts.addAll(MobStatUtils.getMobConfigStats(entity, data));
            }
        }
        return statContexts;
    }

    static List<StatContext> addGearStats(List<GearData> gears) {
        ArrayList<StatContext> ctxs = new ArrayList<StatContext>();
        gears.forEach(x -> {
            List<ExactStatData> stats = x.gear.GetAllStats();
            if (x.percentStatUtilization != 100) {
                float multi = (float)x.percentStatUtilization / 100.0f;
                stats.forEach(s -> s.multiplyBy(multi));
            }
            ctxs.add(GearStatCtx.of(x.gear, stats));
            StatContext ench = x.gear.getEnchantCompatStats(x.stack);
            if (ench != null) {
                ctxs.add(ench);
            }
        });
        return ctxs;
    }
}

