/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.saveclasses.unit;

import com.robertx22.mine_and_slash.database.data.stats.Stat;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.saveclasses.ExactStatData;
import com.robertx22.mine_and_slash.saveclasses.unit.StatData;
import com.robertx22.mine_and_slash.uncommon.enumclasses.ModType;
import net.minecraft.util.Mth;

public class InCalcStatData {
    public String id = "";
    private float Flat = 0.0f;
    private float Percent = 0.0f;
    private float Multi = 1.0f;

    private InCalcStatData() {
    }

    public InCalcStatData(String id) {
        this.id = id;
    }

    public void clear() {
        this.Flat = 0.0f;
        this.Percent = 0.0f;
        this.Multi = 0.0f;
    }

    private float calcValue() {
        Stat stat = this.GetStat();
        float finalValue = stat.base;
        finalValue += this.Flat;
        finalValue *= 1.0f + this.Percent / 100.0f;
        if (stat.getMultiUseType() == Stat.MultiUseType.MULTIPLY_STAT) {
            finalValue *= this.Multi;
        }
        return Mth.m_14036_((float)finalValue, (float)stat.min, (float)stat.getHardCap());
    }

    public Stat GetStat() {
        return (Stat)ExileDB.Stats().get(this.id);
    }

    public void addAlreadyScaledFlat(float val1) {
        this.Flat += val1;
    }

    public void addFullyTo(InCalcStatData other) {
        other.Flat += this.Flat;
        other.Percent += this.Percent;
        other.Multi += 1.0f - this.Multi;
    }

    public void add(ExactStatData modData) {
        ModType type = modData.getType();
        float v1 = modData.getFirstValue();
        if (type == ModType.FLAT) {
            this.Flat += v1;
        } else if (type == ModType.PERCENT) {
            this.Percent += v1;
        } else if (type == ModType.MORE) {
            this.Multi *= 1.0f + v1 / 100.0f;
        }
    }

    public float getValue() {
        return this.Flat;
    }

    public StatData getCalculated() {
        float mu = 1.0f;
        if (this.GetStat().getMultiUseType() == Stat.MultiUseType.MULTIPLICATIVE_DAMAGE) {
            mu = this.Multi;
        }
        return new StatData(this.id, this.calcValue(), mu);
    }
}

