/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.saveclasses.unit;

import com.robertx22.mine_and_slash.capability.entity.EntityData;
import com.robertx22.mine_and_slash.config.forge.ServerContainer;
import com.robertx22.mine_and_slash.database.data.gear_types.bases.BaseGearType;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.tags.all.SlotTags;
import com.robertx22.mine_and_slash.uncommon.datasaving.StackSaving;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.RepairUtils;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;

public class GearData {
    public ItemStack stack;
    public GearItemData gear;
    public EquipmentSlot slot;
    public int percentStatUtilization = 100;

    public GearData(ItemStack stack, EquipmentSlot slot, EntityData data) {
        this.stack = stack;
        if (stack != null) {
            this.gear = (GearItemData)StackSaving.GEARS.loadFrom(stack);
        }
        this.slot = slot;
        this.calcStatUtilization(data);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GearData)) {
            return false;
        }
        GearData other = (GearData)obj;
        return ItemStack.m_41728_((ItemStack)this.stack, (ItemStack)other.stack);
    }

    private void calcStatUtilization(EntityData data) {
        if (this.slot == EquipmentSlot.OFFHAND && this.gear != null) {
            if (this.gear.GetBaseGearType().getTags().contains(SlotTags.offhand_family)) {
                this.percentStatUtilization = 100;
            }
            if (this.gear.GetBaseGearType().weaponType().can_dual_wield && this.gear.GetBaseGearType().getTags().contains(SlotTags.weapon_family)) {
                this.percentStatUtilization = (Integer)ServerContainer.get().PERC_OFFHAND_WEP_STAT.get();
            }
        }
    }

    public boolean isUsableBy(EntityData data) {
        if (this.stack == null) {
            return false;
        }
        if (this.gear == null) {
            return false;
        }
        if (this.stack.m_41763_() && RepairUtils.isItemBroken(this.stack)) {
            return false;
        }
        if (!this.gear.isValidItem()) {
            return false;
        }
        if (this.gear.lvl > data.getLevel()) {
            return false;
        }
        BaseGearType type = this.gear.GetBaseGearType();
        if (type.isWeapon()) {
            if (type.weaponType().can_dual_wield && this.slot == EquipmentSlot.OFFHAND) {
                return true;
            }
            return this.slot == EquipmentSlot.MAINHAND;
        }
        if (type.tags.contains(SlotTags.chest)) {
            return this.slot == EquipmentSlot.CHEST;
        }
        if (type.tags.contains(SlotTags.pants)) {
            return this.slot == EquipmentSlot.LEGS;
        }
        if (type.tags.contains(SlotTags.boots)) {
            return this.slot == EquipmentSlot.FEET;
        }
        if (type.tags.contains(SlotTags.helmet)) {
            return this.slot == EquipmentSlot.HEAD;
        }
        if (type.tags.contains(SlotTags.jewelry_family)) {
            return this.slot == null;
        }
        if (type.tags.contains(SlotTags.offhand_family)) {
            return this.slot == EquipmentSlot.OFFHAND;
        }
        return false;
    }
}

