/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.saveclasses.stat_soul;

import com.robertx22.library_of_exile.registry.IGUID;
import com.robertx22.library_of_exile.utils.LoadSave;
import com.robertx22.mine_and_slash.database.data.gear_slots.GearSlot;
import com.robertx22.mine_and_slash.database.data.rarities.GearRarity;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.gui.texts.ExileTooltips;
import com.robertx22.mine_and_slash.gui.texts.textblocks.NameBlock;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipContext;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.saveclasses.stat_soul.StatSoulData;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.datasaving.StackSaving;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.ClientOnly;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.LevelUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.PlayerUtils;
import com.robertx22.mine_and_slash.vanilla_mc.items.misc.ICreativeTabNbt;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class StatSoulItem
extends Item
implements IGUID,
ICreativeTabNbt {
    public static String TAG = "stat_soul";

    public StatSoulItem() {
        super(new Item.Properties());
    }

    public static boolean hasSoul(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128441_(TAG);
    }

    public static StatSoulData getSoul(ItemStack stack) {
        StatSoulData data = (StatSoulData)LoadSave.Load(StatSoulData.class, (Object)new StatSoulData(), (CompoundTag)stack.m_41784_(), (String)TAG);
        return data;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player p, InteractionHand pUsedHand) {
        ItemStack itemstack = p.m_21120_(pUsedHand);
        if (!pLevel.f_46443_ && StackSaving.STAT_SOULS.has(itemstack)) {
            StatSoulData data = (StatSoulData)StackSaving.STAT_SOULS.loadFrom(itemstack);
            GearItemData geardata = data.createGearData(null, p);
            Item item = geardata.GetBaseGearType().getRandomItem(data.getRarity());
            ItemStack stack = item.m_7968_();
            StackSaving.GEARS.saveTo(stack, (Object)geardata);
            PlayerUtils.giveItem(stack, p);
            itemstack.m_41774_(1);
        }
        return InteractionResultHolder.m_19098_((Object)p.m_21120_(pUsedHand));
    }

    @Override
    public List<ItemStack> createAllVariationsForCreativeTabs() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (GearRarity rarity : ExileDB.GearRarities().getList()) {
            for (GearSlot slot : ExileDB.GearSlots().getList()) {
                int i = 0;
                while (i <= LevelUtils.getMaxTier()) {
                    StatSoulData data = new StatSoulData();
                    data.tier = i++;
                    data.rar = rarity.GUID();
                    data.slot = slot.GUID();
                    ItemStack stack = data.toStack();
                    list.add(stack);
                }
            }
        }
        return list;
    }

    public Component m_7626_(ItemStack stack) {
        MutableComponent txt = Component.m_237115_((String)this.m_5524_());
        try {
            StatSoulData data = StatSoulItem.getSoul(stack);
            if (data == null) {
                return txt;
            }
            GearRarity rar = (GearRarity)ExileDB.GearRarities().get(data.rar);
            GearSlot slot = (GearSlot)ExileDB.GearSlots().get(data.slot);
            MutableComponent t = rar.locName();
            if (!data.canBeOnAnySlot()) {
                t.m_130946_(" ").m_7220_((Component)slot.locName());
            }
            t.m_130946_(" ").m_7220_((Component)Words.Soul.locName()).m_130940_(rar.textFormatting());
            return t;
        }
        catch (Exception e) {
            e.printStackTrace();
            return txt;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag context) {
        try {
            StatSoulData data = (StatSoulData)StackSaving.STAT_SOULS.loadFrom(stack);
            if (data != null) {
                tooltip.clear();
                if (Screen.m_96638_() && data.gear != null) {
                    data.gear.BuildTooltip(new TooltipContext(stack, tooltip, Load.Unit((Entity)ClientOnly.getPlayer())));
                } else {
                    ExileTooltips exileTooltips = data.getTooltip(stack, false);
                    exileTooltips.accept(new NameBlock(Collections.singletonList(stack.m_41786_())));
                    tooltip.addAll(exileTooltips.release());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String GUID() {
        return "stat_soul/stat_soul";
    }
}

