/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.saveclasses.stat_soul;

import com.robertx22.library_of_exile.utils.ItemstackDataSaver;
import com.robertx22.mine_and_slash.database.data.game_balance_config.GameBalanceConfig;
import com.robertx22.mine_and_slash.database.data.gear_slots.GearSlot;
import com.robertx22.mine_and_slash.database.data.gear_types.bases.BaseGearType;
import com.robertx22.mine_and_slash.database.data.gear_types.bases.SlotFamily;
import com.robertx22.mine_and_slash.database.data.level_ranges.LevelRange;
import com.robertx22.mine_and_slash.database.data.rarities.GearRarity;
import com.robertx22.mine_and_slash.database.data.unique_items.UniqueGear;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.gui.inv_gui.actions.auto_salvage.ToggleAutoSalvageRarity;
import com.robertx22.mine_and_slash.gui.texts.ExileTooltips;
import com.robertx22.mine_and_slash.gui.texts.textblocks.AdditionalBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.OperationTipBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.RarityBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.SalvageBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.WorksOnBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.usableitemblocks.UsageBlock;
import com.robertx22.mine_and_slash.loot.LootInfo;
import com.robertx22.mine_and_slash.loot.blueprints.GearBlueprint;
import com.robertx22.mine_and_slash.mmorpg.registers.common.items.RarityItems;
import com.robertx22.mine_and_slash.mmorpg.registers.common.items.SlashItems;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.ModRange;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.StatRangeInfo;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipContext;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.uncommon.MathHelper;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.datasaving.StackSaving;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.ICommonDataItem;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.ISettableLevelTier;
import com.robertx22.mine_and_slash.uncommon.localization.Chats;
import com.robertx22.mine_and_slash.uncommon.localization.Itemtips;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.LevelUtils;
import com.robertx22.mine_and_slash.vanilla_mc.items.TagForceSoulItem;
import com.robertx22.temp.SkillItemTier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class StatSoulData
implements ICommonDataItem<GearRarity>,
ISettableLevelTier {
    public int tier = 1;
    public String slot = "";
    public String rar = "";
    public SlotFamily fam = SlotFamily.NONE;
    public String uniq = "";
    public String force_tag = "";
    public boolean can_sal = true;
    public GearItemData gear = null;

    public static StatSoulData ofFamily(GearRarity rar, SkillItemTier tier, SlotFamily fam) {
        StatSoulData data = new StatSoulData();
        data.tier = tier.tier;
        data.fam = fam;
        data.rar = rar.GUID();
        return data;
    }

    public boolean canBeOnAnySlot() {
        return this.slot.isEmpty();
    }

    public void setCanBeOnAnySlot() {
        this.slot = "";
    }

    public ItemStack toStack() {
        ItemStack stack = new ItemStack((ItemLike)SlashItems.STAT_SOUL.get());
        StackSaving.STAT_SOULS.saveTo(stack, (Object)this);
        if (!this.slot.isEmpty()) {
            stack.m_41784_().m_128405_("CustomModelData", ((GearSlot)ExileDB.GearSlots().get((String)this.slot)).model_num);
        }
        return stack;
    }

    public void insertAsUnidentifiedOn(ItemStack stack, Player p) {
        if (this.gear != null) {
            StackSaving.GEARS.saveTo(stack, (Object)this.gear);
        } else {
            StackSaving.GEARS.saveTo(stack, (Object)this.createGearData(stack, p));
        }
    }

    public GearSlot getSlotFor(ItemStack stack) {
        GearSlot gearslot = (GearSlot)ExileDB.GearSlots().random();
        if (!this.slot.isEmpty()) {
            gearslot = (GearSlot)ExileDB.GearSlots().get(this.slot);
        }
        if (stack != null) {
            gearslot = GearSlot.getSlotOf(stack.m_41720_());
        }
        return gearslot;
    }

    public boolean forcesTag() {
        return !this.force_tag.isEmpty();
    }

    public boolean isArmor() {
        return this.fam == SlotFamily.Armor || !this.slot.isEmpty() && ((GearSlot)ExileDB.GearSlots().get((String)this.slot)).fam == SlotFamily.Armor;
    }

    public boolean canApplyTo(ItemStack stack) {
        GearSlot slot = GearSlot.getSlotOf(stack.m_41720_());
        if (slot == null) {
            return false;
        }
        if (this.canBeOnAnySlot()) {
            return slot != null;
        }
        if (this.fam != SlotFamily.NONE && slot.fam == this.fam) {
            return true;
        }
        if (!this.slot.isEmpty()) {
            return this.slot.equals(slot.GUID());
        }
        return false;
    }

    public GearItemData createGearData(@Nullable ItemStack stack, Player p) {
        int lvl = MathHelper.clamp(Load.Unit((Entity)p).getLevel(), LevelUtils.tierToLevel(this.tier).getMinLevel(), LevelUtils.tierToLevel(this.tier).getMaxLevel());
        GearBlueprint b = new GearBlueprint(LootInfo.ofLevel(lvl));
        b.level.set(lvl);
        b.rarity.set((GearRarity)ExileDB.GearRarities().get(this.rar));
        GearSlot gearslot = this.getSlotFor(stack);
        String slotid = gearslot.GUID();
        b.gearItemSlot.set((BaseGearType)ExileDB.GearTypes().getFilterWrapped(x -> x.gear_slot.equals(slotid) && (!this.forcesTag() || x.tags.contains(this.force_tag))).random());
        UniqueGear uniq = (UniqueGear)ExileDB.UniqueGears().get(this.uniq);
        if (!uniq.isEmpty()) {
            b.uniquePart.set(uniq);
            b.rarity.set(uniq.getUniqueRarity());
            b.gearItemSlot.set(uniq.getBaseGear());
        }
        GearItemData gear = b.createData();
        gear.setPotential((int)((double)gear.getPotentialNumber() * GameBalanceConfig.get().CRAFTED_GEAR_POTENTIAL_MULTI));
        gear.data.set(GearItemData.KEYS.SALVAGING_DISABLED, !this.can_sal);
        return gear;
    }

    public boolean canInsertIntoStack(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        if (StackSaving.GEARS.has(stack)) {
            return false;
        }
        if (this.gear != null) {
            return GearSlot.isItemOfThisSlot(this.gear.GetBaseGearType().getGearSlot(), stack.m_41720_());
        }
        return this.canApplyTo(stack);
    }

    @Override
    public String getRarityId() {
        return this.rar;
    }

    @Override
    public GearRarity getRarity() {
        return (GearRarity)ExileDB.GearRarities().get(this.rar);
    }

    @Override
    public void setTier(int tier) {
        this.tier = tier;
    }

    @Override
    public void BuildTooltip(TooltipContext ctx) {
    }

    @Override
    public int getLevel() {
        return LevelUtils.levelToTier(this.tier);
    }

    @Override
    public ItemstackDataSaver<? extends ICommonDataItem> getStackSaver() {
        return StackSaving.STAT_SOULS;
    }

    public ExileTooltips getTooltip(ItemStack stack, boolean cangen) {
        ExileTooltips exileTooltips = new ExileTooltips().accept(new RarityBlock(this.getRarity())).accept(new UsageBlock(Collections.singletonList(Chats.INFUSES_STATS.locName().m_130940_(ChatFormatting.AQUA))));
        if (this.gear != null) {
            exileTooltips.accept(new AdditionalBlock((Component)Itemtips.CHECK_GEAR_STATS_IN_SOUL.locName().m_130940_(ChatFormatting.AQUA)));
            exileTooltips.accept(new OperationTipBlock().setAlt().setShift());
        } else {
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            LevelRange levelRange = LevelUtils.tierToLevel(this.tier);
            tooltip.add(Itemtips.SOUL_GENERATE_GEAR_LEVEL_RANGE.locName(Component.m_237113_((String)("" + levelRange.getMinLevel())), Component.m_237113_((String)("" + levelRange.getMaxLevel()))).m_130940_(ChatFormatting.GOLD));
            if (new StatRangeInfo((ModRange)ModRange.hide()).hasAltDown) {
                tooltip.add(Component.m_237113_((String)("[" + Itemtips.MAP_TIER_TIP.locName().getString() + "]")).m_130940_(ChatFormatting.BLUE));
            }
            if (!this.canBeOnAnySlot()) {
                if (this.fam != SlotFamily.NONE) {
                    tooltip.add(Itemtips.ITEM_TYPE.locName(Component.m_237113_((String)this.fam.name()).m_130940_(ChatFormatting.BLUE)).m_130940_(ChatFormatting.GRAY));
                } else {
                    tooltip.add(Itemtips.ITEM_TYPE.locName(((GearSlot)ExileDB.GearSlots().get(this.slot)).locName().m_130940_(ChatFormatting.BLUE)).m_130940_(ChatFormatting.GRAY));
                }
            }
            if (!Objects.equals(this.force_tag, "")) {
                Arrays.stream(TagForceSoulItem.AvailableTags.values()).filter(x -> x.tag.equals(this.force_tag)).findFirst().ifPresent(x -> tooltip.add(Itemtips.SOUL_LOCKED_TO_TYPE.locName(x.translation).m_130940_(ChatFormatting.GOLD)));
            }
            exileTooltips.accept(new UsageBlock(tooltip));
            exileTooltips.accept(new OperationTipBlock().setAlt());
        }
        exileTooltips.accept(WorksOnBlock.usableOn(WorksOnBlock.ItemType.SOULLESS_GEAR));
        exileTooltips.accept(new AdditionalBlock(Collections.singletonList(Chats.RIGHT_CLICK_TO_GEN_ITEM.locName().m_130940_(ChatFormatting.BLUE))).showWhen(() -> cangen)).accept(new SalvageBlock(this));
        return exileTooltips;
    }

    @Override
    public void saveToStack(ItemStack stack) {
        StackSaving.STAT_SOULS.saveTo(stack, (Object)this);
    }

    @Override
    public List<ItemStack> getSalvageResult(ItemStack stack) {
        int amount = 1;
        return Arrays.asList(new ItemStack((ItemLike)RarityItems.RARITY_STONE.getOrDefault(this.getRarity().GUID(), RarityItems.RARITY_STONE.get("common")).get(), amount));
    }

    @Override
    public ToggleAutoSalvageRarity.SalvageType getSalvageType() {
        return ToggleAutoSalvageRarity.SalvageType.GEAR;
    }
}

