/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.saveclasses.spells;

import com.robertx22.mine_and_slash.database.OptScaleExactStat;
import com.robertx22.mine_and_slash.database.data.game_balance_config.PlayerPointsType;
import com.robertx22.mine_and_slash.database.data.perks.Perk;
import com.robertx22.mine_and_slash.database.data.spell_school.SpellSchool;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.saveclasses.ExactStatData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.IStatCtx;
import com.robertx22.mine_and_slash.saveclasses.unit.stat_ctx.SimpleStatCtx;
import com.robertx22.mine_and_slash.saveclasses.unit.stat_ctx.StatContext;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class SpellSchoolsData
implements IStatCtx {
    public HashMap<String, Integer> allocated_lvls = new HashMap();

    public Set<String> school() {
        HashSet<String> list = new HashSet<String>();
        for (Perk perk : this.getAllPerks()) {
            Optional<SpellSchool> sc = perk.getSpellSchool();
            if (!sc.isPresent()) {
                this.allocated_lvls.remove(perk.GUID());
                continue;
            }
            list.add(sc.get().GUID());
        }
        return list;
    }

    public List<Perk> getAllPerks() {
        return this.allocated_lvls.keySet().stream().map(x -> (Perk)ExileDB.Perks().get(x)).collect(Collectors.toList());
    }

    public void reset(PointType type) {
        Set<String> schools = this.school();
        for (Perk perk : this.getAllPerks()) {
            Optional<SpellSchool> sch = perk.getSpellSchool();
            if (sch.isPresent() && sch.get() != null && schools.contains(sch.get().GUID())) continue;
            this.allocated_lvls.remove(perk.GUID());
        }
        for (Perk perk : this.getAllPerks()) {
            if (type == PointType.SPELL && perk.isSpell()) {
                this.allocated_lvls.remove(perk.GUID());
            }
            if (type != PointType.PASSIVE || !perk.isPassive()) continue;
            this.allocated_lvls.remove(perk.GUID());
        }
    }

    public int getLevel(String id) {
        return this.allocated_lvls.getOrDefault(id, 0);
    }

    public int getSpentPoints(PointType type) {
        int total = 0;
        for (Map.Entry<String, Integer> en : this.allocated_lvls.entrySet()) {
            if (!type.is(en.getKey())) continue;
            total += en.getValue().intValue();
        }
        return total;
    }

    public boolean canLearn(Player en, SpellSchool school, Perk perk) {
        PointType type = perk.getPointType();
        if (type.getGeneralType().getFreePoints(en) < 1) {
            return false;
        }
        if (!school.isLevelEnoughFor((LivingEntity)en, perk)) {
            return false;
        }
        if (this.school().size() > 1 && !this.school().contains(school.GUID())) {
            return false;
        }
        return this.allocated_lvls.getOrDefault(perk.GUID(), 0) < perk.getMaxLevel();
    }

    public boolean canUnlearn(Player en, SpellSchool school, Perk perk) {
        if (this.getLevel(perk.id) < 1) {
            return false;
        }
        return perk.getPointType().getGeneralType().hasResetPoints(en);
    }

    public void learn(Perk perk, SpellSchool school) {
        if (!this.school().contains(school.GUID())) {
            this.school().add(school.GUID());
        }
        int current = this.allocated_lvls.getOrDefault(perk.GUID(), 0);
        this.allocated_lvls.put(perk.GUID(), current + 1);
    }

    public void unlearn(Player p, Perk perk, SpellSchool school) {
        int current;
        if (!this.school().contains(school.GUID())) {
            this.school().add(school.GUID());
        }
        if ((current = this.allocated_lvls.getOrDefault(perk.GUID(), 0).intValue()) > 0) {
            perk.getPointType().getGeneralType().reduceResetPoints(p, 1);
            this.allocated_lvls.put(perk.GUID(), current - 1);
        }
    }

    @Override
    public List<StatContext> getStatAndContext(LivingEntity en) {
        ArrayList<ExactStatData> stats = new ArrayList<ExactStatData>();
        for (Map.Entry<String, Integer> s : this.allocated_lvls.entrySet()) {
            if (!ExileDB.Perks().isRegistered(s.getKey())) continue;
            for (OptScaleExactStat stat : ((Perk)ExileDB.Perks().get((String)s.getKey())).stats) {
                ExactStatData data = stat.toExactStat(Load.Unit((Entity)en).getLevel());
                data.percentIncrease = (s.getValue() - 1) * 100;
                data.increaseByAddedPercent();
                stats.add(data);
            }
        }
        return Arrays.asList(new SimpleStatCtx(StatContext.StatCtxType.ASCENDANCY, stats));
    }

    public static enum PointType {
        SPELL,
        PASSIVE;


        public PlayerPointsType getGeneralType() {
            return this == SPELL ? PlayerPointsType.SPELLS : PlayerPointsType.PASSIVES;
        }

        public boolean is(String perkid) {
            if (this == SPELL) {
                return ((Perk)ExileDB.Perks().get(perkid)).isSpell();
            }
            return !((Perk)ExileDB.Perks().get(perkid)).isSpell();
        }
    }
}

