/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.saveclasses.spells;

import com.robertx22.library_of_exile.main.MyPacket;
import com.robertx22.library_of_exile.main.Packets;
import com.robertx22.library_of_exile.registry.ExileRegistry;
import com.robertx22.mine_and_slash.capability.entity.EntityData;
import com.robertx22.mine_and_slash.database.data.exile_effects.ExileEffect;
import com.robertx22.mine_and_slash.database.data.exile_effects.ExileEffectInstanceData;
import com.robertx22.mine_and_slash.database.data.game_balance_config.GameBalanceConfig;
import com.robertx22.mine_and_slash.database.data.profession.ExplainedResult;
import com.robertx22.mine_and_slash.database.data.spells.components.Spell;
import com.robertx22.mine_and_slash.database.data.spells.entities.CalculatedSpellData;
import com.robertx22.mine_and_slash.database.data.spells.spell_classes.bases.SpellCastContext;
import com.robertx22.mine_and_slash.database.data.stats.Stat;
import com.robertx22.mine_and_slash.database.data.stats.types.LearnSpellStat;
import com.robertx22.mine_and_slash.database.data.stats.types.MaxAllSpellLevels;
import com.robertx22.mine_and_slash.database.data.stats.types.MaxSpellLevel;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.mmorpg.MMORPG;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.saveclasses.skill_gem.SkillGemData;
import com.robertx22.mine_and_slash.saveclasses.spells.ChargeData;
import com.robertx22.mine_and_slash.saveclasses.unit.Unit;
import com.robertx22.mine_and_slash.uncommon.MathHelper;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.datasaving.StackSaving;
import com.robertx22.mine_and_slash.uncommon.effectdatas.SpendResourceEvent;
import com.robertx22.mine_and_slash.uncommon.localization.Chats;
import com.robertx22.mine_and_slash.vanilla_mc.packets.NoManaPacket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class SpellCastingData {
    public HashMap<Integer, String> hotbar = new HashMap();
    public List<InsertedSpell> spells = new ArrayList<InsertedSpell>();
    public int castTickLeft = 0;
    public int castTicksDone = 0;
    public int spellTotalCastTicks = 0;
    public CalculatedSpellData calcSpell = null;
    public Boolean casting = false;
    public ChargeData charges = new ChargeData();
    static transient Spell lastSpell = null;

    public boolean learnedSpellButHotbarIsEmpty() {
        return this.getAllHotbarSpells().isEmpty() && !this.spells.isEmpty();
    }

    public int keyOfSpell(String spell) {
        for (Map.Entry<Integer, String> en : this.hotbar.entrySet()) {
            if (!en.getValue().equals(spell)) continue;
            return en.getKey();
        }
        return -1;
    }

    public List<HotbarSpellData> getAllHotbarSpellsInfo() {
        ArrayList<HotbarSpellData> list = new ArrayList<HotbarSpellData>();
        for (Integer i : this.hotbar.keySet()) {
            String spell = this.hotbar.getOrDefault(i, "");
            if (!ExileDB.Spells().isRegistered(spell)) continue;
            list.add(new HotbarSpellData((Spell)ExileDB.Spells().get(spell), i));
        }
        return list;
    }

    public List<InsertedSpell> getAllHotbarSpells() {
        ArrayList<InsertedSpell> list = new ArrayList<InsertedSpell>();
        for (Integer i : this.hotbar.keySet()) {
            list.add(this.getSpellData(i));
        }
        list.removeIf(x -> x == null || x.getData() == null);
        return list;
    }

    public void setHotbar(int slot, String spell) {
        for (Map.Entry<Integer, String> en : this.hotbar.entrySet()) {
            if (!en.getValue().equals(spell)) continue;
            this.hotbar.put(en.getKey(), "");
        }
        this.hotbar.put(slot, spell);
    }

    public void resetSpells() {
        this.spells.clear();
    }

    public void calcSpellLevels(Unit unit) {
        this.resetSpells();
        unit.getStats().stats.values().forEach(x -> {
            Stat patt4111$temp = x.GetStat();
            if (patt4111$temp instanceof LearnSpellStat) {
                LearnSpellStat learn = (LearnSpellStat)patt4111$temp;
                this.addSpell(new InsertedSpell(learn.spell.GUID(), (int)x.getValue()));
            }
        });
        unit.getStats().stats.values().forEach(x -> {
            block3: {
                block2: {
                    Stat patt4436$temp = x.GetStat();
                    if (!(patt4436$temp instanceof MaxSpellLevel)) break block2;
                    MaxSpellLevel max = (MaxSpellLevel)patt4436$temp;
                    for (InsertedSpell spell : this.spells) {
                        if (!spell.getSpell().config.tags.contains(max.tag)) continue;
                        spell.bonus_ranks = (int)((float)spell.bonus_ranks + x.getValue());
                    }
                    break block3;
                }
                if (!(x.GetStat() instanceof MaxAllSpellLevels)) break block3;
                for (InsertedSpell spell : this.spells) {
                    spell.bonus_ranks = (int)((float)spell.bonus_ranks + x.getValue());
                }
            }
        });
        for (InsertedSpell spell : this.spells) {
            spell.bonus_ranks = MathHelper.clamp(spell.bonus_ranks, 0, GameBalanceConfig.get().MAX_BONUS_SPELL_LEVELS);
            spell.rank += spell.bonus_ranks;
        }
    }

    public void addSpell(InsertedSpell spell) {
        this.spells.add(spell);
    }

    public InsertedSpell getSpellData(int slot) {
        String id = this.getSpellId(slot);
        return this.spells.stream().filter(x -> x.id.equals(id)).findAny().orElse(new InsertedSpell("", 0));
    }

    public InsertedSpell getSpellData(String id) {
        return this.spells.stream().filter(x -> x.id.equals(id)).findAny().orElse(new InsertedSpell("", 0));
    }

    public String getSpellId(int slot) {
        return this.hotbar.getOrDefault(slot, "");
    }

    public void cancelCast(LivingEntity entity) {
        try {
            if (this.isCasting()) {
                SpellCastContext ctx = new SpellCastContext(entity, 0, this.getSpellBeingCast());
                Spell spell = this.getSpellBeingCast();
                if (spell != null) {
                    int cd = ctx.spell.getCooldownTicks(ctx);
                    Load.Unit((Entity)entity).getCooldowns().setOnCooldown(spell.GUID(), cd);
                }
                this.calcSpell = null;
                this.castTickLeft = 0;
                this.spellTotalCastTicks = 0;
                this.castTicksDone = 0;
                this.casting = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isCasting() {
        return this.calcSpell != null && this.casting != false && ExileDB.Spells().isRegistered(this.calcSpell.spell_id);
    }

    public void onTimePass(LivingEntity entity) {
        try {
            if (this.isCasting()) {
                Spell spell = this.calcSpell.getSpell();
                SpellCastContext ctx = new SpellCastContext(entity, this.castTicksDone, spell);
                if (spell != null && ExileDB.Spells().isRegistered((ExileRegistry)spell)) {
                    spell.onCastingTick(ctx);
                }
                this.tryCast(ctx);
                lastSpell = spell;
                --this.castTickLeft;
                ++this.castTicksDone;
                if (this.castTickLeft < 0) {
                    for (Map.Entry<String, ExileEffectInstanceData> en : ctx.data.statusEffects.exileMap.entrySet()) {
                        ExileEffect eff = (ExileEffect)ExileDB.ExileEffects().get(en.getKey());
                        if (eff.remove_on_spell_cast == null || !spell.config.tags.contains(eff.remove_on_spell_cast)) continue;
                        --en.getValue().stacks;
                    }
                    this.calcSpell = null;
                }
            } else {
                lastSpell = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.cancelCast(entity);
        }
    }

    public List<String> getSpellsOnCooldown(LivingEntity en) {
        return Load.Unit((Entity)en).getCooldowns().getAllSpellsOnCooldown();
    }

    public void setToCast(SpellCastContext ctx) {
        this.calcSpell = ctx.calcData;
        this.spellTotalCastTicks = this.castTickLeft = ctx.spell.getCastTimeTicks(ctx);
        this.castTicksDone = 0;
        this.casting = true;
    }

    public void tryCast(SpellCastContext ctx) {
        if (this.getSpellBeingCast() != null && this.castTickLeft <= 0) {
            Spell spell = this.getSpellBeingCast();
            int timesToCast = ctx.spell.getConfig().times_to_cast;
            if (timesToCast == 1) {
                spell.cast(ctx);
            }
            this.onSpellCast(ctx);
            this.calcSpell = null;
        }
    }

    public Spell getSpellBeingCast() {
        if (this.calcSpell != null) {
            return this.calcSpell.getSpell();
        }
        return null;
    }

    public ExplainedResult canCast(Spell spell, Player player) {
        if (player.m_9236_().f_46443_) {
            return ExplainedResult.failure((Component)Component.m_237113_((String)"Client side"));
        }
        if (this.isCasting()) {
            return ExplainedResult.failure((Component)Chats.ALREADY_CASTING.locName());
        }
        if (spell == null) {
            return ExplainedResult.failure((Component)Component.m_237113_((String)"Trying to cast NULL Spell, this shouldn't happen"));
        }
        if (Load.Unit((Entity)player).getCooldowns().isOnCooldown(spell.GUID())) {
            if (Load.Unit((Entity)player).getCooldowns().getCooldownTicks(spell.GUID()) > 40) {
                return ExplainedResult.failure((Component)Chats.SPELL_IS_ON_CD.locName());
            }
            return ExplainedResult.silentlyFail();
        }
        if (player.m_7500_()) {
            return ExplainedResult.success();
        }
        if (spell.GUID().contains("test") && !MMORPG.RUN_DEV_TOOLS) {
            return ExplainedResult.failure((Component)Chats.USING_TEST_SPELL.locName());
        }
        if (spell.config.charges > 0 && !this.charges.hasCharge(spell.config.charge_name)) {
            return ExplainedResult.failure((Component)Chats.NO_CHARGES.locName());
        }
        SpellCastContext ctx = new SpellCastContext((LivingEntity)player, 0, spell);
        EntityData data = Load.Unit((Entity)player);
        if (data != null) {
            if (!spell.isAllowedInDimension(player.m_9236_())) {
                return ExplainedResult.failure((Component)Chats.NOT_IN_THIS_DIMENSION.locName());
            }
            SpendResourceEvent mana = spell.getManaCostCtx(ctx);
            SpendResourceEvent energy = spell.getEnergyCostCtx(ctx);
            if (data.getResources().hasEnough(mana) && data.getResources().hasEnough(energy)) {
                GearItemData wep = (GearItemData)StackSaving.GEARS.loadFrom(ctx.caster.m_21205_());
                if (wep == null) {
                    return ExplainedResult.failure((Component)Chats.NOT_MNS_WEAPON.locName());
                }
                if (!spell.getConfig().castingWeapon.predicate.predicate.test((LivingEntity)player)) {
                    return ExplainedResult.failure((Component)Chats.WRONG_CASTING_WEAPON.locName());
                }
                if (!wep.canPlayerWear(ctx.data)) {
                    return ExplainedResult.failure((Component)Chats.WEAPON_REQ_NOT_MET.locName());
                }
                return ExplainedResult.success();
            }
            if (player instanceof ServerPlayer) {
                Packets.sendToClient((Player)player, (MyPacket)new NoManaPacket());
                return ExplainedResult.failure((Component)Chats.NO_MANA.locName());
            }
        }
        return ExplainedResult.silentlyFail();
    }

    public void setCooldownOnCasted(SpellCastContext ctx) {
        Player p;
        int cd = ctx.spell.getCooldownTicks(ctx);
        ctx.data.getCooldowns().setOnCooldown(ctx.spell.GUID(), cd);
        if (ctx.spell.config.charges > 0 && ctx.caster instanceof Player) {
            this.charges.spendCharge((Player)ctx.caster, ctx.spell.config.charge_name);
        }
        if (ctx.caster instanceof Player && (p = (Player)ctx.caster).m_7500_() && cd > 20) {
            ctx.data.getCooldowns().setOnCooldown(ctx.spell.GUID(), 20);
        }
    }

    public void onSpellCast(SpellCastContext ctx) {
        this.setCooldownOnCasted(ctx);
        this.casting = false;
        if (ctx.caster instanceof ServerPlayer) {
            Load.Unit((Entity)ctx.caster).sync.setDirty();
        }
    }

    public static class HotbarSpellData {
        public Spell spell;
        public int hotbarkey;

        public HotbarSpellData(Spell spell, int hotbarkey) {
            this.spell = spell;
            this.hotbarkey = hotbarkey;
        }
    }

    public static class InsertedSpell {
        public String id;
        public int rankBeforePlusSkills = 0;
        public int rank;
        public int bonus_ranks = 0;

        public Spell getSpell() {
            return (Spell)ExileDB.Spells().get(this.id);
        }

        public InsertedSpell(String id, int rank) {
            this.id = id;
            this.rank = rank;
            this.rankBeforePlusSkills = rank;
        }

        public SkillGemData getData() {
            if (this.id.isEmpty()) {
                return null;
            }
            SkillGemData data = new SkillGemData();
            data.id = this.id;
            data.type = SkillGemData.SkillGemType.SKILL;
            data.setLinks(0);
            data.perc = (int)((float)this.rankBeforePlusSkills / (float)data.getSpell().max_lvl * 100.0f);
            if (this.rankBeforePlusSkills > 1) {
                for (int total = this.rankBeforePlusSkills - 1; total > 2; total -= 3) {
                    data.setLinks(data.getFlatLinks() + 1);
                }
            }
            return data;
        }
    }
}

