/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.saveclasses.prof_tool;

import com.google.common.collect.ImmutableList;
import com.robertx22.mine_and_slash.database.data.affixes.Affix;
import com.robertx22.mine_and_slash.database.data.game_balance_config.GameBalanceConfig;
import com.robertx22.mine_and_slash.database.data.profession.Profession;
import com.robertx22.mine_and_slash.database.data.profession.all.Professions;
import com.robertx22.mine_and_slash.database.data.rarities.GearRarity;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.gui.texts.ExileTooltips;
import com.robertx22.mine_and_slash.gui.texts.textblocks.AdditionalBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.NameBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.OperationTipBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.RarityBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.affixdatablocks.SimpleItemStatBlock;
import com.robertx22.mine_and_slash.saveclasses.ExactStatData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.ITooltip;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.ModRange;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.StatRangeInfo;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipContext;
import com.robertx22.mine_and_slash.tags.all.SlotTags;
import com.robertx22.mine_and_slash.uncommon.localization.Chats;
import com.robertx22.mine_and_slash.uncommon.localization.Itemtips;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.LevelUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.TooltipUtils;
import com.robertx22.temp.SkillItemTier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.SwordItem;

public class ProfessionToolData
implements ITooltip {
    public String prof = "";
    public List<ToolAffix> affixes = new ArrayList<ToolAffix>();
    public int lvl = 1;
    public int xp = 0;
    public int force_lvl = -1;

    public List<ExactStatData> GetAllStats() {
        ArrayList<ExactStatData> list = new ArrayList<ExactStatData>();
        this.affixes.stream().forEach(x -> {
            try {
                ((Affix)ExileDB.Affixes().get(x.id)).getStats().stream().map(e -> e.ToExactStat(x.p, this.lvl)).forEach(t -> list.add((ExactStatData)t));
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        });
        return list;
    }

    public Profession getProfession() {
        return (Profession)ExileDB.Professions().get(this.prof);
    }

    public static boolean isCorrectTool(Profession prof, ItemStack stack) {
        if (prof.id.equals(Professions.MINING)) {
            return stack.m_204117_(ItemTags.f_271360_) || stack.m_41720_() instanceof PickaxeItem;
        }
        if (prof.id.equals(Professions.FARMING)) {
            return stack.m_204117_(ItemTags.f_271298_) || stack.m_41720_() instanceof HoeItem;
        }
        if (prof.id.equals(Professions.FISHING)) {
            return stack.m_41720_() instanceof FishingRodItem;
        }
        if (prof.id.equals(Professions.HUSBANDRY)) {
            return stack.m_204117_(ItemTags.f_271388_) || stack.m_41720_() instanceof SwordItem;
        }
        return false;
    }

    public void addExp(Player p, ItemStack stack, int added) {
        this.xp += added;
        int currentXPNeeded = this.getExpNeeded();
        if (this.lvl < GameBalanceConfig.get().MAX_LEVEL) {
            while (this.xp >= currentXPNeeded && this.lvl < GameBalanceConfig.get().MAX_LEVEL) {
                SkillItemTier tier = SkillItemTier.fromLevel(this.lvl);
                ++this.lvl;
                this.xp -= currentXPNeeded;
                SkillItemTier newtier = SkillItemTier.fromLevel(this.lvl);
                p.m_213846_((Component)Chats.TOOL_LEVEL_UP.locName(stack.m_41786_(), this.lvl).m_130940_(ChatFormatting.YELLOW));
                if (tier == newtier) continue;
                this.addStat();
                p.m_213846_((Component)Chats.TOOL_ADD_STAT.locName(stack.m_41786_(), this.getRarity().locName()).m_130940_(this.getRarity().textFormatting()));
            }
        }
    }

    public void addStat() {
        GearRarity rar = (GearRarity)ExileDB.GearRarities().random();
        ToolAffix data = new ToolAffix();
        data.rar = rar.GUID();
        data.p = rar.stat_percents.random();
        data.id = ((Affix)ExileDB.Affixes().getFilterWrapped(x -> x.type == Affix.Type.tool && x.getAllTagReq().contains(this.getProfession().tool_tag) && x.getAllTagReq().contains(SlotTags.tool.GUID())).random()).GUID();
        this.affixes.add(data);
    }

    public GearRarity getRarity() {
        return (GearRarity)ExileDB.GearRarities().get(this.getTier().rar);
    }

    public SkillItemTier getTier() {
        return SkillItemTier.fromLevel(this.lvl);
    }

    public int getExpNeeded() {
        return LevelUtils.getExpRequiredForLevel(this.lvl + 1) / 10;
    }

    @Override
    public void BuildTooltip(TooltipContext ctx) {
        if (Screen.m_96637_()) {
            return;
        }
        ExileTooltips exileTooltips = new ExileTooltips().accept(new NameBlock(Collections.singletonList(ctx.stack.m_41786_()))).accept(new RarityBlock(this.getRarity())).accept(new AdditionalBlock((List<? extends Component>)ImmutableList.of((Object)TooltipUtils.level(this.lvl).m_130940_(ChatFormatting.GREEN), (Object)Itemtips.PROF_TOOL_EXP_TIP.locName(this.xp, this.getExpNeeded()).m_130940_(ChatFormatting.GREEN)))).accept(new SimpleItemStatBlock(new StatRangeInfo(ModRange.hide())).accept((Component)Itemtips.PROF_TOOL_STATS_TIP.locName(), this.GetAllStats())).accept(new OperationTipBlock().setCtrl().setAlt());
        if (this.force_lvl > -1) {
            exileTooltips.accept(new AdditionalBlock((Component)Itemtips.PROF_TOOL_LEVEL_CAP.locName(this.force_lvl).m_130940_(ChatFormatting.RED)));
        }
        List<Component> tooltip = ctx.tooltip;
        tooltip.clear();
        tooltip.addAll(exileTooltips.release());
    }

    public static class ToolAffix {
        public String id = "";
        public String rar = "";
        public int p = 0;
    }
}

