/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.saveclasses.jewel;

import com.google.common.collect.ImmutableList;
import com.robertx22.library_of_exile.utils.ItemstackDataSaver;
import com.robertx22.library_of_exile.utils.RandomUtils;
import com.robertx22.mine_and_slash.capability.entity.EntityData;
import com.robertx22.mine_and_slash.capability.player.PlayerData;
import com.robertx22.mine_and_slash.database.data.affixes.Affix;
import com.robertx22.mine_and_slash.database.data.rarities.GearRarity;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.gui.inv_gui.actions.auto_salvage.ToggleAutoSalvageRarity;
import com.robertx22.mine_and_slash.gui.texts.ExileTooltips;
import com.robertx22.mine_and_slash.gui.texts.textblocks.AdditionalBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.ClickToOpenGuiBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.NameBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.OperationTipBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.RarityBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.RequirementBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.SalvageBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.StatBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.affixdatablocks.SimpleItemStatBlock;
import com.robertx22.mine_and_slash.mmorpg.registers.common.items.RarityItems;
import com.robertx22.mine_and_slash.mmorpg.registers.common.items.SlashItems;
import com.robertx22.mine_and_slash.mmorpg.registers.deferred_wrapper.RegObj;
import com.robertx22.mine_and_slash.saveclasses.ExactStatData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.IStatCtx;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.ModRange;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.StatRangeInfo;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipContext;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_parts.AffixData;
import com.robertx22.mine_and_slash.saveclasses.item_classes.tooltips.TooltipStatWithContext;
import com.robertx22.mine_and_slash.saveclasses.jewel.CraftedUniqueJewelData;
import com.robertx22.mine_and_slash.saveclasses.jewel.StatsWhileUnderAuraData;
import com.robertx22.mine_and_slash.saveclasses.unit.stat_ctx.SimpleStatCtx;
import com.robertx22.mine_and_slash.saveclasses.unit.stat_ctx.StatContext;
import com.robertx22.mine_and_slash.tags.all.SlotTags;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.datasaving.StackSaving;
import com.robertx22.mine_and_slash.uncommon.enumclasses.PlayStyle;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.ICommonDataItem;
import com.robertx22.mine_and_slash.uncommon.localization.Itemtips;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class JewelItemData
implements ICommonDataItem<GearRarity>,
IStatCtx {
    public CraftedUniqueJewelData uniq = new CraftedUniqueJewelData();
    public List<AffixData> cor = new ArrayList<AffixData>();
    public List<AffixData> affixes = new ArrayList<AffixData>();
    public List<StatsWhileUnderAuraData> auraStats = new ArrayList<StatsWhileUnderAuraData>();
    public String style;
    public int lvl;
    public String rar;

    public JewelItemData() {
        this.style = PlayStyle.STR.id;
        this.lvl = 1;
        this.rar = "common";
    }

    public void corrupt() {
        if (this.cor.isEmpty()) {
            int num = RandomUtils.roll((int)10) ? 2 : 1;
            for (int i = 0; i < num; ++i) {
                Affix affix = (Affix)ExileDB.Affixes().getFilterWrapped(x -> x.type == Affix.Type.jewel_corruption).random();
                AffixData data = new AffixData(Affix.Type.jewel_corruption);
                data.randomizeTier(this.getRarity());
                data.p = data.getMinMax().random();
                data.id = affix.guid;
                this.cor.add(data);
            }
        }
    }

    public void generateAffixes() {
        int num = 1 + this.getRarity().min_affixes / 2;
        this.affixes.clear();
        for (int i = 0; i < num; ++i) {
            Affix affix = (Affix)ExileDB.Affixes().getFilterWrapped(x -> x.getAllTagReq().contains(SlotTags.any_jewel.GUID()) || x.getAllTagReq().contains(this.getStyle().getJewelAffixTag().GUID())).random();
            AffixData data = new AffixData(Affix.Type.jewel);
            data.randomizeTier(this.getRarity());
            data.p = data.getMinMax().random();
            data.id = affix.guid;
            this.affixes.add(data);
        }
    }

    @Override
    public void BuildTooltip(TooltipContext ctx) {
        ctx.tooltip.clear();
        StatRangeInfo info = new StatRangeInfo(ModRange.of(this.getRarity().stat_percents));
        ExileTooltips tip = new ExileTooltips();
        tip.accept(new NameBlock(Collections.singletonList(ctx.stack.m_41786_())));
        tip.accept(new RarityBlock(this.getRarity()));
        if (this.auraStats.isEmpty()) {
            tip.accept(new SimpleItemStatBlock(info).acceptIf((Component)Itemtips.JEWEL_STATS.locName().m_130940_(ChatFormatting.BLUE), this.affixes.stream().flatMap(x -> x.getAllStatsWithCtx(this.lvl, this.getRarity()).stream()).toList(), this.auraStats.isEmpty()));
        } else {
            tip.accept(new StatBlock(){

                @Override
                public List<? extends Component> getAvailableComponents() {
                    ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
                    for (StatsWhileUnderAuraData aura : JewelItemData.this.auraStats) {
                        list.addAll(aura.getTooltip());
                        list.add(Component.m_237119_());
                    }
                    return list;
                }
            });
        }
        if (!this.cor.isEmpty()) {
            tip.accept(new StatBlock(){

                @Override
                public List<? extends Component> getAvailableComponents() {
                    ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
                    list.add(Itemtips.COR_STATS.locName().m_130940_(ChatFormatting.RED));
                    for (TooltipStatWithContext c : JewelItemData.this.cor.stream().flatMap(x -> x.getAllStatsWithCtx(JewelItemData.this.lvl, JewelItemData.this.getRarity()).stream()).toList()) {
                        list.addAll(c.GetTooltipString());
                    }
                    return list;
                }
            });
        }
        tip.accept(new RequirementBlock(this.lvl)).accept(new SalvageBlock(this)).accept(new AdditionalBlock(() -> {
            ItemStack up = this.uniq.getCraftedTier().upgradeStack.get();
            return ImmutableList.of((Object)Itemtips.JEWEL_UPGRADE_1.locName(up.m_41613_(), up.m_41786_()).m_130940_(ChatFormatting.AQUA), (Object)Itemtips.JEWEL_UPGRADE_2.locName(up.m_41613_(), up.m_41786_()).m_130940_(ChatFormatting.AQUA));
        }).showWhen(() -> this.auraStats.isEmpty() && this.uniq.isUnique() && this.uniq.isCraftableUnique() && this.uniq.getCraftedTier().canUpgradeMore())).accept(new OperationTipBlock().setShift().setAlt());
        tip.accept(new ClickToOpenGuiBlock());
        ctx.tooltip.addAll(tip.release());
    }

    public boolean canWear(EntityData data) {
        return data.getLevel() >= this.lvl;
    }

    @Override
    public int getLevel() {
        return this.lvl;
    }

    @Override
    public ItemstackDataSaver<JewelItemData> getStackSaver() {
        return StackSaving.JEWEL;
    }

    @Override
    public void saveToStack(ItemStack stack) {
        this.getStackSaver().saveTo(stack, (Object)this);
    }

    @Override
    public String getRarityId() {
        return this.rar;
    }

    @Override
    public GearRarity getRarity() {
        return (GearRarity)ExileDB.GearRarities().get(this.rar);
    }

    public Item getItem() {
        PlayStyle s = this.getStyle();
        if (!this.auraStats.isEmpty()) {
            return SlashItems.WATCHER_EYE_JEWEL.get();
        }
        if (s == PlayStyle.DEX) {
            return SlashItems.DEX_JEWEL.get();
        }
        if (s == PlayStyle.INT) {
            return SlashItems.INT_JEWEL.get();
        }
        return SlashItems.STR_JEWEL.get();
    }

    public PlayStyle getStyle() {
        return PlayStyle.fromID(this.style);
    }

    @Override
    public List<ItemStack> getSalvageResult(ItemStack stack) {
        int amount = 1;
        if (RarityItems.RARITY_STONE.containsKey(this.getRarity().GUID())) {
            return Arrays.asList(new ItemStack((ItemLike)RarityItems.RARITY_STONE.get(this.getRarity().GUID()).get(), amount));
        }
        return Arrays.asList(new ItemStack((ItemLike)((RegObj)RandomUtils.randomFromList(RarityItems.RARITY_STONE.values().stream().toList())).get(), RandomUtils.RandomRange((int)1, (int)5)));
    }

    @Override
    public List<StatContext> getStatAndContext(LivingEntity en) {
        ArrayList<ExactStatData> list = new ArrayList<ExactStatData>();
        for (AffixData affix : this.affixes) {
            list.addAll(affix.GetAllStats(this.lvl));
        }
        for (AffixData affix : this.cor) {
            list.addAll(affix.GetAllStats(this.lvl));
        }
        ArrayList<StatContext> ctx = new ArrayList<StatContext>();
        if (en instanceof Player) {
            Player p = (Player)en;
            PlayerData data = Load.player(p);
            for (StatsWhileUnderAuraData aura : this.auraStats) {
                if (!data.aurasOn.contains(aura.getAura().id)) continue;
                ctx.addAll(aura.getStatAndContext(en));
            }
        }
        ctx.add(new SimpleStatCtx(StatContext.StatCtxType.JEWEL, list));
        return ctx;
    }

    @Override
    public ToggleAutoSalvageRarity.SalvageType getSalvageType() {
        return ToggleAutoSalvageRarity.SalvageType.JEWEL;
    }
}

