/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.saveclasses.item_classes;

import com.google.common.collect.ImmutableList;
import com.robertx22.mine_and_slash.capability.entity.EntityData;
import com.robertx22.mine_and_slash.config.forge.ClientConfigs;
import com.robertx22.mine_and_slash.database.data.stats.types.resources.energy.Energy;
import com.robertx22.mine_and_slash.gui.texts.ExileTooltips;
import com.robertx22.mine_and_slash.gui.texts.IgnoreNullList;
import com.robertx22.mine_and_slash.gui.texts.StatCategory;
import com.robertx22.mine_and_slash.gui.texts.textblocks.AdditionalBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.NameBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.OperationTipBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.RarityBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.RequirementBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.SalvageBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.StatBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.gearblocks.DurabilityBlock;
import com.robertx22.mine_and_slash.saveclasses.ExactStatData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.IGearPartTooltip;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.ModRange;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.StatRangeInfo;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_parts.BaseStatsData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_parts.GearAffixesData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_parts.GearInfusionData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_parts.GearSocketsData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_parts.ImplicitStatsData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_parts.UniqueStatsData;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.saveclasses.item_classes.tooltips.MergedStats;
import com.robertx22.mine_and_slash.saveclasses.item_classes.tooltips.TooltipStatInfo;
import com.robertx22.mine_and_slash.tags.imp.SlotTag;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.enumclasses.ModType;
import com.robertx22.mine_and_slash.uncommon.localization.Gui;
import com.robertx22.mine_and_slash.uncommon.localization.Itemtips;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.TooltipUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class GearTooltipUtils {
    public static void BuildTooltip(final GearItemData gear, ItemStack stack, List<Component> tooltip, EntityData data) {
        if (gear.GetBaseGearType() == null) {
            return;
        }
        final StatRangeInfo info = new StatRangeInfo(ModRange.hide());
        tooltip.clear();
        List<Component> release = new ExileTooltips().accept(new NameBlock(gear.GetDisplayName(stack))).accept(new RarityBlock(gear.getRarity())).accept(new RequirementBlock().setStatRequirement(gear.getRequirement()).setLevelRequirement(gear.getLevel())).accept(new StatBlock(){
            @Nonnull
            private final GearItemData gearItemData;
            @Nonnull
            private final StatRangeInfo tinfo;
            public BaseStatsData baseStatsData;
            public ImplicitStatsData implicitStatsData;
            public GearAffixesData gearAffixesData;
            @Nullable
            public UniqueStatsData uniqueStatsData;
            public GearSocketsData gearSocketsData;
            @Nullable
            public GearInfusionData gearEnchantData;
            {
                this.gearItemData = gear;
                this.tinfo = info;
            }

            private static int getPriority(String s, Map<String, Integer> priorityMap) {
                return priorityMap.entrySet().stream().filter(entry -> s.contains((CharSequence)entry.getKey())).map(Map.Entry::getValue).min(Integer::compare).orElse(Integer.MAX_VALUE);
            }

            @Override
            public List<? extends Component> getAvailableComponents() {
                boolean showMerge;
                IgnoreNullList<Object> list = new IgnoreNullList<Object>();
                this.implicitStatsData = this.gearItemData.imp;
                this.baseStatsData = this.gearItemData.baseStats;
                this.gearAffixesData = this.gearItemData.affixes;
                this.gearSocketsData = this.gearItemData.sockets;
                this.gearEnchantData = this.gearItemData.ench;
                this.uniqueStatsData = this.gearItemData.uniqueStats;
                if (this.baseStatsData != null) {
                    list.addAll(this.baseStatsData.GetTooltipString(this.tinfo, this.gearItemData));
                    list.add(ExileTooltips.EMPTY_LINE);
                }
                boolean bl = showMerge = !this.tinfo.useInDepthStats();
                if (((Boolean)ClientConfigs.getConfig().IN_DEPTH_TOOLTIPS_BY_DEFAULT.get()).booleanValue()) {
                    showMerge = false;
                }
                if (showMerge) {
                    ArrayList<ExactStatData> stats = new ArrayList<ExactStatData>();
                    stats.addAll(this.implicitStatsData.GetAllStats(this.gearItemData));
                    this.gearAffixesData.getAllAffixesAndSockets().forEach(x -> stats.addAll(x.GetAllStats(this.gearItemData)));
                    if (this.uniqueStatsData != null) {
                        stats.addAll(this.uniqueStatsData.GetAllStats(this.gearItemData));
                    }
                    Map<Boolean, List<ExactStatData>> map = stats.stream().collect(Collectors.groupingBy(x -> x.getStat().is_long));
                    MergedStats merged = new MergedStats(new ArrayList<ExactStatData>(), this.tinfo);
                    if (map.get(false) != null) {
                        merged = new MergedStats(map.get(false), this.tinfo);
                    }
                    HashMap<String, Integer> DPMap = new HashMap<String, Integer>();
                    DPMap.put("damage", 1);
                    DPMap.put("dmg", 1);
                    DPMap.put("penetration", 2);
                    Comparator damageAndPenetration = (s1, s2) -> {
                        int p1 = 1.getPriority(s1.stat.GUID(), DPMap);
                        int p2 = 1.getPriority(s2.stat.GUID(), DPMap);
                        return Integer.compare(p1, p2);
                    };
                    HashMap priorityMap = new HashMap();
                    Arrays.asList(Elements.values()).forEach(x -> priorityMap.put(x.guidName, x.ordinal()));
                    Comparator eleOrder = (s1, s2) -> {
                        int p1 = 1.getPriority(s1.stat.GUID(), priorityMap);
                        int p2 = 1.getPriority(s2.stat.GUID(), priorityMap);
                        return Integer.compare(p1, p2);
                    };
                    LinkedHashMap<String, ArrayList<TooltipStatInfo>> orderStatMap = new LinkedHashMap<String, ArrayList<TooltipStatInfo>>();
                    for (StatCategory category : StatCategory.values()) {
                        orderStatMap.put(category.name(), new ArrayList());
                    }
                    orderStatMap.put("other", new ArrayList());
                    for (TooltipStatInfo tooltipStatInfo : merged.mergedList) {
                        StatCategory.distributeStat(tooltipStatInfo, orderStatMap);
                    }
                    for (ArrayList tooltipStatInfos : orderStatMap.values()) {
                        tooltipStatInfos.sort(Comparator.comparing(o -> o.stat.GUID()));
                        tooltipStatInfos.sort(Comparator.comparing(o -> o.stat.GUID().length()));
                        tooltipStatInfos.sort(eleOrder);
                        tooltipStatInfos.sort(damageAndPenetration);
                        for (TooltipStatInfo tooltipStatInfo : tooltipStatInfos) {
                            list.addAll(tooltipStatInfo.GetTooltipString());
                        }
                    }
                    Optional.ofNullable(map.get(true)).map(x -> x.stream().flatMap(y -> y.GetTooltipString().stream()).toList()).ifPresent(list::addAll);
                    list.add(ExileTooltips.EMPTY_LINE);
                } else {
                    List<Object> uniComps = new ArrayList();
                    ArrayList<Object> prefixComps = new ArrayList<Object>();
                    ArrayList<Object> corComps = new ArrayList<Object>();
                    ArrayList<Object> suffixComps = new ArrayList<Object>();
                    List<Component> impComps = this.implicitStatsData.GetTooltipString(this.tinfo, this.gearItemData);
                    if (this.uniqueStatsData != null) {
                        uniComps = this.uniqueStatsData.GetTooltipString(this.tinfo, this.gearItemData);
                    }
                    ChatFormatting color = ChatFormatting.BLUE;
                    if (!this.gearAffixesData.getPreStatsWithCtx(this.gearItemData, this.tinfo).isEmpty()) {
                        prefixComps.add(Itemtips.PREFIX_STATS.locName().m_130940_(color));
                        prefixComps.addAll(this.gearAffixesData.getPreStatsWithCtx(this.gearItemData, this.tinfo).stream().flatMap(x -> x.GetTooltipString().stream()).map(x -> x).toList());
                    }
                    if (!this.gearAffixesData.getCorStatsWithCtx(this.gearItemData, this.tinfo).isEmpty()) {
                        corComps.add(Itemtips.COR_STATS.locName().m_130940_(ChatFormatting.RED));
                        corComps.addAll(this.gearAffixesData.getCorStatsWithCtx(this.gearItemData, this.tinfo).stream().flatMap(x -> x.GetTooltipString().stream()).map(x -> x).toList());
                    }
                    if (!this.gearAffixesData.getSufStatsWithCtx(this.gearItemData, this.tinfo).isEmpty()) {
                        suffixComps.add(Itemtips.SUFFIX_STATS.locName().m_130940_(color));
                        suffixComps.addAll(this.gearAffixesData.getSufStatsWithCtx(this.gearItemData, this.tinfo).stream().flatMap(x -> x.GetTooltipString().stream()).map(x -> x).toList());
                    }
                    Stream<List> addOrder = Stream.of(impComps, uniComps, prefixComps, suffixComps, corComps);
                    addOrder.forEachOrdered(x -> {
                        x.sort(Comparator.comparing(component -> component.getString().contains("\u25c6")));
                        list.addAll((List<Object>)x);
                        list.add(ExileTooltips.EMPTY_LINE);
                    });
                }
                IgnoreNullList<IGearPartTooltip> list3 = IgnoreNullList.of(new IGearPartTooltip[]{this.gearSocketsData, this.gearEnchantData});
                ListIterator iGearPartTooltipListIterator = list3.listIterator();
                while (iGearPartTooltipListIterator.hasNext()) {
                    list.addAll(((IGearPartTooltip)iGearPartTooltipListIterator.next()).GetTooltipString(this.tinfo, this.gearItemData));
                    if (!iGearPartTooltipListIterator.hasNext()) continue;
                    list.add(ExileTooltips.EMPTY_LINE);
                }
                return list;
            }
        }).accept(new AdditionalBlock((List<? extends Component>)ImmutableList.of((Object)(gear.isCorrupted() ? Component.m_237113_((String)"").m_7220_((Component)Itemtips.POTENTIAL.locName(gear.getPotentialNumber()).m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.STRIKETHROUGH})).m_7220_((Component)Component.m_237113_((String)" ")).m_7220_((Component)Words.Corrupted.locName().m_130940_(ChatFormatting.RED)) : Itemtips.POTENTIAL.locName(gear.getPotentialNumber()).m_130940_(ChatFormatting.GOLD)), (Object)Itemtips.QUALITY.locName(gear.getQuality()).m_130940_(ChatFormatting.GOLD))).showWhen(() -> info.hasShiftDown)).accept(new AdditionalBlock(() -> {
            int cost = (int)Energy.getInstance().scale(ModType.FLAT, gear.GetBaseGearType().getGearSlot().weapon_data.energy_cost_per_swing, data.getLevel());
            int permob = (int)Energy.getInstance().scale(ModType.FLAT, gear.GetBaseGearType().getGearSlot().weapon_data.energy_cost_per_mob_attacked, data.getLevel());
            float damageFactor = gear.GetBaseGearType().getGearSlot().getBasicDamageMulti() * 100.0f / 100.0f;
            return Collections.singletonList(Words.Energy_Cost_Per_Mob.locName(cost, permob, Float.valueOf(damageFactor)).m_130940_(ChatFormatting.GREEN));
        }).showWhen(() -> info.hasShiftDown && gear.GetBaseGearType().getGearSlot().weapon_data.damage_multiplier > 0.0f)).accept(new AdditionalBlock(() -> ImmutableList.of((Object)Itemtips.ITEM_TYPE.locName(gear.GetBaseGearType().locName().m_130940_(ChatFormatting.BLUE)), (Object)Words.TAGS.locName().m_7220_((Component)TooltipUtils.joinMutableComps(gear.GetBaseGearType().getTags().getTags(SlotTag.SERIALIZER).stream().map(x -> ((SlotTag)x).locName()).toList().iterator(), Gui.COMMA_SEPARATOR.locName())))).showWhen(() -> info.hasShiftDown)).accept(new SalvageBlock(gear)).accept(new OperationTipBlock().setAll()).accept(new DurabilityBlock(stack)).release();
        tooltip.addAll(release);
    }
}

