/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.saveclasses.item_classes;

import com.robertx22.library_of_exile.utils.ItemstackDataSaver;
import com.robertx22.library_of_exile.utils.RandomUtils;
import com.robertx22.mine_and_slash.capability.entity.EntityData;
import com.robertx22.mine_and_slash.database.data.affixes.Affix;
import com.robertx22.mine_and_slash.database.data.gear_types.bases.BaseGearType;
import com.robertx22.mine_and_slash.database.data.gear_types.bases.SlotFamily;
import com.robertx22.mine_and_slash.database.data.profession.PlayerUTIL;
import com.robertx22.mine_and_slash.database.data.rarities.GearRarity;
import com.robertx22.mine_and_slash.database.data.requirements.bases.GearRequestedFor;
import com.robertx22.mine_and_slash.database.data.stat_compat.StatCompat;
import com.robertx22.mine_and_slash.database.data.unique_items.UniqueGear;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.gui.inv_gui.actions.auto_salvage.ToggleAutoSalvageRarity;
import com.robertx22.mine_and_slash.mmorpg.registers.common.items.RarityItems;
import com.robertx22.mine_and_slash.mmorpg.registers.deferred_wrapper.RegObj;
import com.robertx22.mine_and_slash.saveclasses.ExactStatData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.GearItemEnum;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.IRerollable;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.IStatsContainer;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.StatRequirement;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipContext;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_parts.AffixData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_parts.BaseStatsData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_parts.GearAffixesData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_parts.GearInfusionData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_parts.GearSocketsData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_parts.ImplicitStatsData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_parts.UniqueStatsData;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearTooltipUtils;
import com.robertx22.mine_and_slash.saveclasses.item_classes.rework.DataKey;
import com.robertx22.mine_and_slash.saveclasses.item_classes.rework.DataKeyHolder;
import com.robertx22.mine_and_slash.saveclasses.item_classes.rework.GenericDataHolder;
import com.robertx22.mine_and_slash.saveclasses.unit.stat_ctx.SimpleStatCtx;
import com.robertx22.mine_and_slash.saveclasses.unit.stat_ctx.StatContext;
import com.robertx22.mine_and_slash.uncommon.MathHelper;
import com.robertx22.mine_and_slash.uncommon.datasaving.StackSaving;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.ICommonDataItem;
import com.robertx22.mine_and_slash.uncommon.localization.Formatter;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.LevelUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.TooltipUtils;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class GearItemData
implements ICommonDataItem<GearRarity> {
    public static KeyHolderClass KEYS = new KeyHolderClass();
    public BaseStatsData baseStats = new BaseStatsData();
    public ImplicitStatsData imp = new ImplicitStatsData();
    public GearAffixesData affixes = new GearAffixesData();
    public GearSocketsData sockets = new GearSocketsData();
    public UniqueStatsData uniqueStats;
    public GearInfusionData ench;
    public GenericDataHolder data = new GenericDataHolder();
    public String rar = "common";
    public int lvl = 1;
    public String gtype = "";
    private int pn = 0;

    public int getQuality() {
        return this.data.get(GearItemData.KEYS.QUALITY);
    }

    public float getQualityBaseStatsMulti() {
        return 1.0f + (float)this.getQuality() / 100.0f;
    }

    public void setQuality(int a) {
        this.data.set(GearItemData.KEYS.QUALITY, a);
    }

    public boolean isCorrupted() {
        return this.data.get(GearItemData.KEYS.CORRUPT);
    }

    public int getTier() {
        return LevelUtils.levelToTier(this.lvl);
    }

    @Override
    public int getLevel() {
        return this.lvl;
    }

    @Override
    public ToggleAutoSalvageRarity.SalvageType getSalvageType() {
        return ToggleAutoSalvageRarity.SalvageType.GEAR;
    }

    @Override
    public String getSalvageConfigurationId() {
        return this.GetBaseGearType().gear_slot;
    }

    public StatRequirement getRequirement() {
        return this.GetBaseGearType().req;
    }

    public boolean canPlayerWear(EntityData data) {
        if (PlayerUTIL.isFake((Player)data.getEntity())) {
            return true;
        }
        if (this.getLevel() > data.getLevel()) {
            return false;
        }
        return this.getRequirement().meetsReq(this.getLevel(), data);
    }

    public boolean isValidItem() {
        return ExileDB.GearTypes().isRegistered(this.gtype);
    }

    public int getEmptySockets() {
        return this.sockets.getTotalSockets() - this.sockets.getSocketedGemsCount();
    }

    public boolean canGetAffix(Affix affix) {
        if (affix.only_one_per_item && this.affixes.containsAffix(affix)) {
            return false;
        }
        return affix.meetsRequirements(new GearRequestedFor(this));
    }

    public int getPotentialNumber() {
        return this.pn;
    }

    public void setPotential(int potential) {
        this.pn = MathHelper.clamp(potential, 0, 1000000);
    }

    public GearItemEnum getGearEnum() {
        if (this.isUnique()) {
            return GearItemEnum.UNIQUE;
        }
        return GearItemEnum.NORMAL;
    }

    @Override
    public String getRarityId() {
        return this.rar;
    }

    @Override
    public GearRarity getRarity() {
        return (GearRarity)ExileDB.GearRarities().get(this.rar);
    }

    public Component name(ItemStack stack) {
        return stack.m_41786_();
    }

    public BaseGearType GetBaseGearType() {
        return (BaseGearType)ExileDB.GearTypes().get(this.gtype);
    }

    public List<MutableComponent> GetDisplayName(ItemStack stack) {
        try {
            return this.getFullAffixedName();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Arrays.asList(new MutableComponent[0]);
        }
    }

    private MutableComponent prefixChecker() {
        if (this.affixes.hasPrefix()) {
            AffixData prefix = this.affixes.pre.stream().sorted(Comparator.comparingInt(x -> -x.p.intValue())).findFirst().get();
            return prefix.BaseAffix().locName();
        }
        return Component.m_237113_((String)"");
    }

    private MutableComponent uniqueChecker() {
        MutableComponent base = this.GetBaseGearType().locName();
        if (this.imp.has()) {
            base = this.imp.get().locName();
        }
        if (this.uniqueStats == null) {
            return base;
        }
        UniqueGear uniq = this.uniqueStats.getUnique(this);
        if (uniq.replaces_name) {
            return uniq.locName().m_130940_(this.getRarity().textFormatting());
        }
        return Formatter.UNIQUE_NAME_FORMAT.locName(this.uniqueStats.getUnique(this).locName(), base).m_130940_(this.getRarity().textFormatting());
    }

    private MutableComponent suffixChecker() {
        if (this.affixes.hasSuffix()) {
            AffixData suffix = this.affixes.suf.stream().sorted(Comparator.comparingInt(x -> -x.p.intValue())).findFirst().get();
            return suffix.BaseAffix().locName();
        }
        return Component.m_237113_((String)"");
    }

    private List<MutableComponent> getFullAffixedName() {
        ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
        ChatFormatting format = this.getRarity().textFormatting();
        String str1 = this.prefixChecker().getString();
        String str2 = this.uniqueChecker().getString();
        String str3 = this.suffixChecker().getString();
        MutableComponent text = !str1.isEmpty() && !str2.isEmpty() && !str3.isEmpty() ? Formatter.GEAR_ITEM_NAME_ALL.locName(this.prefixChecker(), this.uniqueChecker(), this.suffixChecker()) : (str1.isEmpty() && !str2.isEmpty() && str3.isEmpty() ? Formatter.GEAR_ITEM_NAME_ONLY_GEAR.locName(this.uniqueChecker()) : (!str1.isEmpty() && !str2.isEmpty() && str3.isEmpty() ? Formatter.GEAR_ITEM_NAME_PRE_GEAR.locName(this.prefixChecker(), this.uniqueChecker()) : Formatter.GEAR_ITEM_NAME_ANOTHER.locName(this.prefixChecker(), this.uniqueChecker(), this.suffixChecker())));
        text.m_130940_(format);
        list.addAll(TooltipUtils.cutIfTooLong(text, format));
        return list;
    }

    public List<IStatsContainer> GetAllStatContainers() {
        ArrayList<IStatsContainer> list = new ArrayList<IStatsContainer>();
        this.IfNotNullAdd(this.baseStats, list);
        this.IfNotNullAdd(this.imp, list);
        this.affixes.getAllAffixesAndSockets().forEach(x -> this.IfNotNullAdd(x, list));
        this.IfNotNullAdd(this.sockets, list);
        this.IfNotNullAdd(this.uniqueStats, list);
        this.IfNotNullAdd(this.ench, list);
        return list;
    }

    public List<IStatsContainer> GetAllStatContainersExceptBase() {
        return this.GetAllStatContainers().stream().filter(x -> !(x instanceof BaseStatsData)).collect(Collectors.toList());
    }

    public List<MutableComponent> getEnchantCompatTooltip(ItemStack stack) {
        StatContext ench = this.getEnchantCompatStats(stack);
        ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
        if (ench == null) {
            return list;
        }
        list.add(Words.EnchantCompatStats.locName().m_130940_(ChatFormatting.AQUA));
        for (ExactStatData stat : ench.stats) {
            list.addAll(stat.GetTooltipString());
        }
        return list;
    }

    public StatContext getEnchantCompatStats(ItemStack stack) {
        ArrayList<ExactStatData> list = new ArrayList<ExactStatData>();
        for (Map.Entry en : stack.getAllEnchantments().entrySet()) {
            String id = ForgeRegistries.ENCHANTMENTS.getKey((Object)((Enchantment)en.getKey())).toString();
            for (StatCompat compat : ExileDB.StatCompat().getFilterWrapped((Predicate<StatCompat>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getEnchantCompatStats$4(java.lang.String com.robertx22.mine_and_slash.database.data.stat_compat.StatCompat ), (Lcom/robertx22/mine_and_slash/database/data/stat_compat/StatCompat;)Z)((String)id)).list) {
                ExactStatData result = compat.getEnchantCompatResult(stack, this.lvl);
                if (result == null) continue;
                list.add(result);
            }
        }
        if (list.isEmpty()) {
            return null;
        }
        SimpleStatCtx ctx = new SimpleStatCtx(StatContext.StatCtxType.ENCHANT_COMPAT, list);
        return ctx;
    }

    public List<ExactStatData> GetAllStats() {
        ArrayList<ExactStatData> list = new ArrayList<ExactStatData>();
        for (IStatsContainer x : this.GetAllStatContainers()) {
            List<ExactStatData> stats = x.GetAllStats(this);
            stats.forEach(s -> list.add((ExactStatData)s));
        }
        return list;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void BuildTooltip(TooltipContext ctx) {
        GearTooltipUtils.BuildTooltip(this, ctx.stack, ctx.tooltip, ctx.data);
    }

    public List<IRerollable> GetAllRerollable() {
        ArrayList<IRerollable> list = new ArrayList<IRerollable>();
        this.IfNotNullAdd(this.baseStats, list);
        this.affixes.getAllAffixesAndSockets().forEach(x -> this.IfNotNullAdd(x, list));
        list.add(this.imp);
        this.IfNotNullAdd(this.uniqueStats, list);
        return list;
    }

    private <T> void IfNotNullAdd(T obj, List<T> list) {
        if (obj != null) {
            list.add(obj);
        }
    }

    @Override
    public List<ItemStack> getSalvageResult(ItemStack stack) {
        if (!this.data.get(GearItemData.KEYS.SALVAGING_DISABLED).booleanValue()) {
            if (this.isUnique()) {
                return Arrays.asList(new ItemStack((ItemLike)((RegObj)RandomUtils.randomFromList(RarityItems.RARITY_STONE.values().stream().toList())).get(), RandomUtils.RandomRange((int)2, (int)9)));
            }
            int amount = 1;
            return Arrays.asList(new ItemStack((ItemLike)RarityItems.RARITY_STONE.getOrDefault(this.getRarity().GUID(), RarityItems.RARITY_STONE.get("common")).get(), amount));
        }
        return Arrays.asList(ItemStack.f_41583_);
    }

    @Override
    public boolean isSalvagable() {
        return this.data.get(GearItemData.KEYS.SALVAGING_DISABLED) == false;
    }

    @Override
    public ItemstackDataSaver<GearItemData> getStackSaver() {
        return StackSaving.GEARS;
    }

    @Override
    public void saveToStack(ItemStack stack) {
        this.getStackSaver().saveTo(stack, (Object)this);
    }

    public boolean isWeapon() {
        try {
            if (this.GetBaseGearType().family().equals((Object)SlotFamily.Weapon)) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private static /* synthetic */ boolean lambda$getEnchantCompatStats$4(String id, StatCompat x) {
        return x.isEnchantCompat() && x.enchant_id.equals(id);
    }

    public static class KeyHolderClass
    extends DataKeyHolder {
        public DataKey.BooleanKey CORRUPT = this.of(new DataKey.BooleanKey("cr"));
        public DataKey.BooleanKey SALVAGING_DISABLED = this.of(new DataKey.BooleanKey("sl"));
        public DataKey.BooleanKey USED_SHARPENING_STONE = this.of(new DataKey.BooleanKey("us"));
        public DataKey.StringKey UNIQUE_ID = this.of(new DataKey.StringKey("uq"));
        public DataKey.IntKey QUALITY = this.of(new DataKey.IntKey("ql"));
        public DataKey.IntKey ENCHANT_TIMES = this.of(new DataKey.IntKey("et"));
        public DataKey.IntKey LEVEL_TIMES = this.of(new DataKey.IntKey("lt"));
    }
}

