/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.saveclasses.gearitem.gear_parts;

import com.robertx22.library_of_exile.registry.FilterListWrap;
import com.robertx22.library_of_exile.wrappers.ExileText;
import com.robertx22.mine_and_slash.database.data.StatMod;
import com.robertx22.mine_and_slash.database.data.affixes.Affix;
import com.robertx22.mine_and_slash.database.data.requirements.bases.GearRequestedFor;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.saveclasses.ExactStatData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.IGearPart;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.IGearPartTooltip;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.IRerollable;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.IStatsContainer;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.StatRangeInfo;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.saveclasses.item_classes.tooltips.TooltipStatInfo;
import com.robertx22.mine_and_slash.saveclasses.item_classes.tooltips.TooltipStatWithContext;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;

public class ImplicitStatsData
implements IGearPartTooltip,
IRerollable,
IStatsContainer {
    public Integer p = 0;
    public String imp = "";

    @Override
    public void RerollFully(GearItemData gear) {
        FilterListWrap opt = ExileDB.Affixes().getFilterWrapped(x -> x.type == Affix.Type.implicit && x.meetsRequirements(new GearRequestedFor(gear)));
        if (!opt.list.isEmpty()) {
            this.imp = ((Affix)opt.random()).GUID();
        }
        this.p = this.getMinMax(gear).random();
    }

    @Override
    public void RerollNumbers(GearItemData gear) {
        this.RerollFully(gear);
    }

    @Override
    public List<Component> GetTooltipString(StatRangeInfo info, GearItemData gear) {
        ArrayList<Component> list = new ArrayList<Component>();
        List<ExactStatData> stats = this.GetAllStats(gear);
        if (!stats.isEmpty()) {
            list.add((Component)Words.IMPLICIT_STATS.locName().m_130940_(ChatFormatting.BLUE));
            this.getAllStatsWithCtx(gear, info).forEach(x -> list.addAll(x.GetTooltipString()));
            list.add((Component)ExileText.ofText((String)"").get());
        }
        return list;
    }

    public Affix get() {
        return (Affix)ExileDB.Affixes().get(this.imp);
    }

    public boolean has() {
        return ExileDB.Affixes().isRegistered(this.imp);
    }

    @Override
    public IGearPart.Part getPart() {
        return IGearPart.Part.IMPLICIT_STATS;
    }

    public List<TooltipStatWithContext> getAllStatsWithCtx(GearItemData gear, StatRangeInfo info) {
        ArrayList<TooltipStatWithContext> list = new ArrayList<TooltipStatWithContext>();
        if (this.has()) {
            this.get().getStats().forEach(x -> {
                ExactStatData exact = x.ToExactStat(this.p, gear.getLevel());
                list.add(new TooltipStatWithContext(new TooltipStatInfo(exact, this.p, info), (StatMod)x, gear.getLevel()));
            });
        }
        return list;
    }

    @Override
    public List<ExactStatData> GetAllStats(GearItemData gear) {
        if (this.has()) {
            return this.get().getStats().stream().map(x -> x.ToExactStat(this.p, gear.lvl)).collect(Collectors.toList());
        }
        return Arrays.asList(new ExactStatData[0]);
    }
}

