/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.saveclasses.gearitem.gear_parts;

import com.robertx22.mine_and_slash.database.data.MinMax;
import com.robertx22.mine_and_slash.database.data.StatMod;
import com.robertx22.mine_and_slash.database.data.profession.ExplainedResult;
import com.robertx22.mine_and_slash.database.data.runewords.RuneWord;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.saveclasses.ExactStatData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.IGearPart;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.IGearPartTooltip;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.IStatsContainer;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.StatRangeInfo;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_parts.SocketData;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.uncommon.localization.Chats;
import com.robertx22.mine_and_slash.uncommon.localization.Itemtips;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;

public class GearSocketsData
implements IStatsContainer,
IGearPartTooltip {
    private List<SocketData> so = new ArrayList<SocketData>();
    private int sl = 0;
    private String rw = "";
    private int rp = 0;

    public boolean hasRuneWord() {
        return ExileDB.RuneWords().isRegistered(this.rw);
    }

    public RuneWord getRuneWord() {
        return (RuneWord)ExileDB.RuneWords().get(this.rw);
    }

    public void setRuneword(RuneWord r) {
        this.rw = r.GUID();
        this.rp = new MinMax(0, 100).random();
    }

    public void removeRuneword() {
        this.rw = "";
        this.rp = 0;
    }

    public List<SocketData> getSocketed() {
        return this.so;
    }

    public int getFirstGemIndex() {
        int i = 0;
        for (SocketData s : this.so) {
            if (s.isGem()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int lastFilledSocketIndex() {
        for (int i = this.so.size() - 1; i > -1; --i) {
            SocketData socket = this.so.get(i);
            if (!socket.isGem() && !socket.isRune()) continue;
            return i;
        }
        return -1;
    }

    public void addSocket() {
        ++this.sl;
    }

    public void removeRune() {
        this.so.removeIf(x -> x.isRune());
    }

    public ExplainedResult canAddSocket(GearItemData gear) {
        if (this.sl < gear.getRarity().sockets.max) {
            return ExplainedResult.success();
        }
        return ExplainedResult.failure((Component)Chats.ALREADY_MAX_SOCKETS.locName());
    }

    public int getTotalSockets() {
        return this.sl;
    }

    public int getSocketedGemsCount() {
        return this.so.size();
    }

    @Override
    public List<ExactStatData> GetAllStats(GearItemData gear) {
        ArrayList<ExactStatData> list = new ArrayList<ExactStatData>();
        for (SocketData s : this.getSocketed()) {
            list.addAll(s.GetAllStats(gear));
        }
        if (this.hasRuneWord()) {
            for (StatMod stat : this.getRuneWord().stats) {
                list.add(stat.ToExactStat(this.rp, gear.lvl));
            }
        }
        return list;
    }

    @Override
    public List<Component> GetTooltipString(StatRangeInfo info, GearItemData gear) {
        ArrayList<Component> list = new ArrayList<Component>();
        try {
            int i;
            for (i = 0; i < this.getSocketedGemsCount(); ++i) {
                SocketData data = this.so.get(i);
                if (!data.isGem() && !data.isRune()) continue;
                list.addAll(data.GetTooltipString(info, gear, true));
            }
            for (i = 0; i < gear.getEmptySockets(); ++i) {
                list.add((Component)Itemtips.EMPTY_SOCKET.locName().m_130940_(ChatFormatting.GRAY));
            }
            if (this.hasRuneWord()) {
                RuneWord r = this.getRuneWord();
                list.add((Component)Component.m_237119_());
                list.add((Component)r.locName().m_130940_(ChatFormatting.DARK_PURPLE).m_130946_(ChatFormatting.DARK_PURPLE + ": "));
                r.stats.stream().map(x -> x.ToExactStat(this.rp, gear.lvl)).forEach(x -> list.addAll(x.GetTooltipString()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    @Override
    public IGearPart.Part getPart() {
        return null;
    }
}

