/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases;

import com.robertx22.mine_and_slash.aoe_data.database.stats.old.DatapackStats;
import com.robertx22.mine_and_slash.capability.entity.EntityData;
import com.robertx22.mine_and_slash.database.data.stats.Stat;
import com.robertx22.mine_and_slash.database.data.stats.StatScaling;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.uncommon.enumclasses.PlayStyle;
import com.robertx22.mine_and_slash.uncommon.localization.Chats;
import com.robertx22.mine_and_slash.uncommon.localization.Itemtips;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;

public class StatRequirement {
    public static String CHECK_YES_ICON = "\u2714";
    public static String NO_ICON = "\u274c";
    public static StatRequirement EMPTY = new StatRequirement();
    public HashMap<String, Float> base_req = new HashMap();
    public HashMap<String, Float> scaling_req = new HashMap();

    public StatRequirement(StatRequirement r) {
        this.scaling_req = new HashMap<String, Float>(r.scaling_req);
    }

    public static StatRequirement of(PlayStyle ... styles) {
        StatRequirement r = new StatRequirement();
        float multi = 0.5f / (float)styles.length;
        for (PlayStyle style : styles) {
            r.setStyleReq(style, multi);
        }
        return r;
    }

    public StatRequirement() {
    }

    public boolean meetsReq(int lvl, EntityData data) {
        int num;
        Stat x;
        for (Map.Entry<String, Float> en : this.scaling_req.entrySet()) {
            x = (Stat)ExileDB.Stats().get(en.getKey());
            num = this.getScalingReq(x, lvl);
            if (!((float)num > data.getUnit().getCalculatedStat(x).getValue())) continue;
            return false;
        }
        for (Map.Entry<String, Float> en : this.base_req.entrySet()) {
            x = (Stat)ExileDB.Stats().get(en.getKey());
            num = this.getNonScalingReq(x, lvl);
            if (!((float)num > data.getUnit().getCalculatedStat(x).getValue())) continue;
            return false;
        }
        return true;
    }

    public List<Component> getReqDifference(int lvl, EntityData data) {
        float targetValue;
        int num;
        Stat x;
        ArrayList<Component> components = new ArrayList<Component>();
        for (Map.Entry<String, Float> en : this.scaling_req.entrySet()) {
            x = (Stat)ExileDB.Stats().get(en.getKey());
            num = this.getScalingReq(x, lvl);
            if (!((float)num > (targetValue = data.getUnit().getCalculatedStat(x).getValue()))) continue;
            components.add((Component)Chats.NOT_MEET_MAP_REQ.locName(x.locName(), Float.valueOf(targetValue), num).m_130940_(ChatFormatting.RED));
        }
        for (Map.Entry<String, Float> en : this.base_req.entrySet()) {
            x = (Stat)ExileDB.Stats().get(en.getKey());
            num = this.getNonScalingReq(x, lvl);
            if (!((float)num > (targetValue = data.getUnit().getCalculatedStat(x).getValue()))) continue;
            components.add((Component)Chats.NOT_MEET_MAP_REQ.locName(x.locName(), Float.valueOf(targetValue), num).m_130940_(ChatFormatting.RED));
        }
        return components;
    }

    public float getLackingResistNumber(int lvl, EntityData data) {
        int num;
        Stat x;
        float lacking = 0.0f;
        for (Map.Entry<String, Float> en : this.scaling_req.entrySet()) {
            x = (Stat)ExileDB.Stats().get(en.getKey());
            num = this.getScalingReq(x, lvl);
            if (!((float)num > data.getUnit().getCalculatedStat(x).getValue())) continue;
            lacking += Math.abs((float)num - data.getUnit().getCalculatedStat(x).getValue());
        }
        for (Map.Entry<String, Float> en : this.base_req.entrySet()) {
            x = (Stat)ExileDB.Stats().get(en.getKey());
            num = this.getNonScalingReq(x, lvl);
            if (!((float)num > data.getUnit().getCalculatedStat(x).getValue())) continue;
            lacking += Math.abs((float)num - data.getUnit().getCalculatedStat(x).getValue());
        }
        return lacking;
    }

    public List<Component> GetTooltipString(int lvl, EntityData data) {
        int num;
        Stat x;
        ArrayList<Component> list = new ArrayList<Component>();
        for (Map.Entry<String, Float> en : this.scaling_req.entrySet()) {
            x = (Stat)ExileDB.Stats().get(en.getKey());
            num = this.getScalingReq(x, lvl);
            if (num <= 0) continue;
            list.add(StatRequirement.getTooltip(num, x, data));
        }
        for (Map.Entry<String, Float> en : this.base_req.entrySet()) {
            x = (Stat)ExileDB.Stats().get(en.getKey());
            num = this.getNonScalingReq(x, lvl);
            if (num <= 0) continue;
            list.add(StatRequirement.getTooltip(num, x, data));
        }
        return list;
    }

    private int getScalingReq(Stat stat, int lvl) {
        return (int)StatScaling.STAT_REQ.scale(this.scaling_req.getOrDefault(stat.GUID(), Float.valueOf(0.0f)).floatValue(), lvl);
    }

    private int getNonScalingReq(Stat stat, int lvl) {
        return this.base_req.get(stat.GUID()).intValue();
    }

    public StatRequirement setStyleReq(PlayStyle style, float req) {
        this.scaling_req.put(style.getStat().GUID(), Float.valueOf(req));
        return this;
    }

    public StatRequirement setDex(float req) {
        this.scaling_req.put(DatapackStats.DEX.GUID(), Float.valueOf(req));
        return this;
    }

    public StatRequirement setInt(float req) {
        this.scaling_req.put(DatapackStats.INT.GUID(), Float.valueOf(req));
        return this;
    }

    public StatRequirement setStr(float req) {
        this.scaling_req.put(DatapackStats.STR.GUID(), Float.valueOf(req));
        return this;
    }

    public boolean isEmpty() {
        return this.scaling_req.isEmpty() && this.base_req.isEmpty();
    }

    static Component getTooltip(int req, Stat stat, EntityData data) {
        String perc = "";
        if (stat.is_perc) {
            perc = "%";
        }
        if (data.getUnit().getCalculatedStat(stat).getValue() >= (float)req) {
            return Component.m_237113_((String)(ChatFormatting.GREEN + ChatFormatting.BOLD + CHECK_YES_ICON + " ")).m_7220_((Component)Itemtips.Stat_Req.locName(stat.locName()).m_130940_(ChatFormatting.GRAY)).m_130946_(ChatFormatting.GRAY + req + perc + " ");
        }
        return Component.m_237113_((String)(ChatFormatting.RED + ChatFormatting.BOLD + NO_ICON + " ")).m_7220_((Component)Itemtips.Stat_Req.locName(stat.locName()).m_130940_(ChatFormatting.DARK_GRAY)).m_130946_(ChatFormatting.DARK_GRAY + req + perc + " ");
    }
}

