/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.prophecy;

import com.robertx22.library_of_exile.utils.RandomUtils;
import com.robertx22.mine_and_slash.database.data.prophecy.ProphecyModifier;
import com.robertx22.mine_and_slash.database.data.prophecy.ProphecyModifierType;
import com.robertx22.mine_and_slash.database.data.prophecy.ProphecyStart;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.loot.blueprints.ItemBlueprint;
import com.robertx22.mine_and_slash.maps.MapData;
import com.robertx22.mine_and_slash.prophecy.ProphecyData;
import com.robertx22.mine_and_slash.prophecy.ProphecyModifierData;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.minecraft.world.entity.player.Player;

public class ProphecyGeneration {
    public static ProphecyData generate(Player p) {
        MapData map = Load.mapAt(p.m_9236_(), p.m_20183_());
        int lvl = map.map.lvl;
        int tier = map.map.tier;
        float cost = 10.0f;
        List<ProphecyModifierType> modtypes = Arrays.stream(ProphecyModifierType.values()).toList();
        ProphecyData data = new ProphecyData();
        data.uuid = UUID.randomUUID().toString();
        data.amount = RandomUtils.RandomRange((int)1, (int)3);
        cost *= (float)data.amount;
        ProphecyStart start = (ProphecyStart)ExileDB.ProphecyStarts().random();
        data.start = start.GUID();
        ItemBlueprint b = start.create(lvl, tier);
        for (ProphecyModifierType type : modtypes) {
            if (!start.acceptsModifier(type) || !type.canApplyTo(start, b) || !RandomUtils.roll((float)type.chanceToSpawn())) continue;
            ProphecyModifier mod = (ProphecyModifier)ExileDB.ProphecyModifiers().getFilterWrapped(x -> x.modifier_type == type).of(x -> {
                if (x.tier_req > tier) {
                    return false;
                }
                return x.lvl_req <= lvl;
            }).random();
            ProphecyModifierData md = new ProphecyModifierData(mod.GUID());
            data.mods.add(md);
            cost *= mod.cost_multi;
        }
        data.cost = (int)cost;
        return data;
    }
}

