/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.mmorpg.event_registers;

import com.robertx22.library_of_exile.events.base.EventConsumer;
import com.robertx22.library_of_exile.events.base.ExileEvents;
import com.robertx22.mine_and_slash.capability.player.PlayerData;
import com.robertx22.mine_and_slash.database.data.stats.Stat;
import com.robertx22.mine_and_slash.database.data.stats.datapacks.stats.AttributeStat;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.event_hooks.damage_hooks.LivingHurtUtils;
import com.robertx22.mine_and_slash.event_hooks.damage_hooks.reworked.NewDamageMain;
import com.robertx22.mine_and_slash.event_hooks.entity.OnMobSpawn;
import com.robertx22.mine_and_slash.event_hooks.entity.OnTrackEntity;
import com.robertx22.mine_and_slash.event_hooks.my_events.OnEntityTick;
import com.robertx22.mine_and_slash.event_hooks.my_events.OnLootChestEvent;
import com.robertx22.mine_and_slash.event_hooks.my_events.OnMobDeathDrops;
import com.robertx22.mine_and_slash.event_hooks.my_events.OnPlayerDeath;
import com.robertx22.mine_and_slash.event_hooks.ontick.OnServerTick;
import com.robertx22.mine_and_slash.event_hooks.ontick.OnTickDungeonWorld;
import com.robertx22.mine_and_slash.event_hooks.player.OnLogin;
import com.robertx22.mine_and_slash.event_hooks.player.StopCastingIfInteract;
import com.robertx22.mine_and_slash.mixin_methods.OnItemInteract;
import com.robertx22.mine_and_slash.mmorpg.ForgeEvents;
import com.robertx22.mine_and_slash.mmorpg.ModErrors;
import com.robertx22.mine_and_slash.mmorpg.registers.common.SlashEntities;
import com.robertx22.mine_and_slash.mmorpg.registers.common.SlashPotions;
import com.robertx22.mine_and_slash.saveclasses.unit.ResourceType;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.effectdatas.DamageEvent;
import com.robertx22.mine_and_slash.uncommon.effectdatas.OnMobKilledByDamageEvent;
import com.robertx22.mine_and_slash.uncommon.error_checks.base.ErrorChecks;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.Cached;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.WorldUtils;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class CommonEvents {
    public static void register() {
        ForgeEvents.registerForgeEvent(EntityAttributeCreationEvent.class, x -> {
            x.put(SlashEntities.SPIRIT_WOLF.get(), Wolf.m_30425_().m_22268_(Attributes.f_22279_, 0.4).m_22265_());
            x.put(SlashEntities.SKELETON.get(), Skeleton.m_32166_().m_22268_(Attributes.f_22279_, 0.3).m_22265_());
            x.put(SlashEntities.SPIDER.get(), Spider.m_33815_().m_22268_(Attributes.f_22279_, 0.5).m_22265_());
            x.put(SlashEntities.ZOMBIE.get(), Zombie.m_34328_().m_22268_(Attributes.f_22279_, 0.4).m_22265_());
            x.put(SlashEntities.THORNY_MINION.get(), Zombie.m_34328_().m_22268_(Attributes.f_22279_, 0.2).m_22265_());
            x.put(SlashEntities.EXPLODE_MINION.get(), Zombie.m_34328_().m_22268_(Attributes.f_22279_, 0.3).m_22265_());
            x.put(SlashEntities.FIRE_GOLEM.get(), Zombie.m_34328_().m_22268_(Attributes.f_22279_, 0.45).m_22265_());
            x.put(SlashEntities.COLD_GOLEM.get(), Zombie.m_34328_().m_22268_(Attributes.f_22279_, 0.45).m_22265_());
            x.put(SlashEntities.LIGHTNING_GOLEM.get(), Zombie.m_34328_().m_22268_(Attributes.f_22279_, 0.45).m_22265_());
        });
        OnItemInteract.register();
        ForgeEvents.registerForgeEvent(ArrowLooseEvent.class, event -> {
            if (event.getEntity().m_21023_(SlashPotions.INSTANT_ARROWS.get())) {
                event.setCharge(100);
            }
        });
        ForgeEvents.registerForgeEvent(ArrowNockEvent.class, event -> {
            if (event.getEntity().m_21023_(SlashPotions.INSTANT_ARROWS.get())) {
                event.setAction(InteractionResultHolder.m_19098_((Object)event.getBow()));
                event.getBow().m_41674_(event.getLevel(), (LivingEntity)event.getEntity(), 2000);
                int cd = 20 - event.getEntity().m_21124_(SlashPotions.INSTANT_ARROWS.get()).m_19564_();
                if (cd < 3) {
                    cd = 3;
                }
                event.getEntity().m_36335_().m_41524_(event.getBow().m_41720_(), cd);
            }
        });
        ForgeEvents.registerForgeEvent(TickEvent.PlayerTickEvent.class, event -> {
            if (!event.player.m_9236_().f_46443_ && event.player.m_21023_(SlashPotions.INSTANT_ARROWS.get()) && event.player.m_21205_().m_41720_() instanceof BowItem) {
                event.player.m_21205_().m_41784_().m_128379_("instant", true);
            }
        });
        ForgeEvents.registerForgeEvent(LivingDeathEvent.class, event -> {
            Entity patt6098$temp;
            if (event.getEntity() != null && (patt6098$temp = event.getSource().m_7639_()) instanceof Player) {
                DamageEvent dmg;
                Player p = (Player)patt6098$temp;
                LivingEntity target = event.getEntity();
                if (!Load.Unit((Entity)target).getCooldowns().isOnCooldown("death") && (dmg = Load.Unit((Entity)target).lastDamageTaken) != null) {
                    Load.Unit((Entity)target).getCooldowns().setOnCooldown("death", Integer.MAX_VALUE);
                    OnMobKilledByDamageEvent e = new OnMobKilledByDamageEvent(dmg);
                    e.Activate();
                }
            }
        });
        ForgeEvents.registerForgeEvent(EntityJoinLevelEvent.class, event -> {
            Entity patt6932$temp = event.getEntity();
            if (patt6932$temp instanceof LivingEntity) {
                LivingEntity en = (LivingEntity)patt6932$temp;
                Load.Unit((Entity)en).gear.setDirty();
            }
            OnMobSpawn.onLoad(event.getEntity());
        });
        ForgeEvents.registerForgeEvent(EntityItemPickupEvent.class, event -> {
            Player patt7377$temp = event.getEntity();
            if (patt7377$temp instanceof ServerPlayer) {
                ItemStack stack;
                ServerPlayer player = (ServerPlayer)patt7377$temp;
                if (!(player.m_9236_().f_46443_ || (stack = event.getItem().m_32055_()).m_41619_() || player.m_9236_().f_46443_)) {
                    if (Load.player((Player)player).config.salvage.trySalvageOnPickup((Player)player, stack)) {
                        stack.m_41774_(100);
                    } else {
                        Load.backpacks((Player)player).getBackpacks().tryAutoPickup(event.getEntity(), stack);
                    }
                }
            }
        });
        ForgeEvents.registerForgeEvent(PlayerEvent.Clone.class, event -> {
            try {
                Player patt8207$temp = event.getEntity();
                if (patt8207$temp instanceof ServerPlayer) {
                    ServerPlayer p = (ServerPlayer)patt8207$temp;
                    if (!p.m_9236_().f_46443_) {
                        PlayerData data = Load.player((Player)p);
                        data.spellCastingData.cancelCast((LivingEntity)p);
                    }
                }
            }
            catch (Exception e) {
                ModErrors.print(e);
            }
        });
        ForgeEvents.registerForgeEvent(TickEvent.PlayerTickEvent.class, event -> {
            if (!event.player.m_9236_().f_46443_ && event.phase == TickEvent.Phase.END) {
                OnServerTick.onEndTick((ServerPlayer)event.player);
            }
        });
        ForgeEvents.registerForgeEvent(TickEvent.LevelTickEvent.class, event -> {
            if (event.phase == TickEvent.Phase.END && event.level instanceof ServerLevel) {
                OnTickDungeonWorld.onEndTick((ServerLevel)event.level);
            }
        });
        ForgeEvents.registerForgeEvent(AttackEntityEvent.class, event -> {
            if (event.getEntity() instanceof ServerPlayer) {
                StopCastingIfInteract.interact(event.getEntity());
            }
        });
        ForgeEvents.registerForgeEvent(PlayerEvent.StartTracking.class, event -> {
            if (event.getEntity() instanceof ServerPlayer) {
                OnTrackEntity.onPlayerStartTracking((ServerPlayer)event.getEntity(), event.getTarget());
            }
        });
        ExileEvents.ON_CHEST_LOOTED.register((EventConsumer)new OnLootChestEvent());
        ExileEvents.LIVING_ENTITY_TICK.register((EventConsumer)new OnEntityTick());
        ExileEvents.MOB_DEATH.register((EventConsumer)new OnMobDeathDrops());
        NewDamageMain.init();
        ExileEvents.PLAYER_DEATH.register((EventConsumer)new OnPlayerDeath());
        ForgeEvents.registerForgeEvent(LivingHurtEvent.class, event -> {
            try {
                if (!(event.getEntity() instanceof Player)) {
                    if (LivingHurtUtils.isEnviromentalDmg(event.getSource()) && WorldUtils.isMapWorldClass(event.getEntity().m_9236_())) {
                        event.setAmount(0.0f);
                        event.setCanceled(true);
                    }
                } else if (LivingHurtUtils.isEnviromentalDmg(event.getSource())) {
                    float dmg = event.getAmount();
                    float multi = dmg / event.getEntity().m_21233_();
                    float spend = Load.Unit((Entity)event.getEntity()).getUnit().magicShieldData().getValue() * multi;
                    Load.Unit((Entity)event.getEntity()).getResources().spend(event.getEntity(), ResourceType.magic_shield, spend);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        ExileEvents.PLAYER_DEATH.register((EventConsumer)new EventConsumer<ExileEvents.OnPlayerDeath>(){

            public void accept(ExileEvents.OnPlayerDeath event) {
                if (event.player instanceof ServerPlayer) {
                    try {
                        PlayerData data = Load.player(event.player);
                        data.deathStats.deathPos = event.player.m_20183_();
                        data.deathStats.deathDim = event.player.m_9236_().m_46472_().m_135782_().toString();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        ExileEvents.ON_PLAYER_LOGIN.register((EventConsumer)new EventConsumer<ExileEvents.OnPlayerLogin>(){

            public void accept(ExileEvents.OnPlayerLogin event) {
                OnLogin.onLoad(event.player);
            }
        });
        ExileEvents.AFTER_DATABASE_LOADED.register((EventConsumer)new EventConsumer<ExileEvents.AfterDatabaseLoaded>(){

            public void accept(ExileEvents.AfterDatabaseLoaded event) {
                Cached.reset();
                CommonEvents.setupStatsThatAffectVanillaStatsList();
                ErrorChecks.getAll().forEach(x -> x.check());
            }
        });
    }

    private static void setupStatsThatAffectVanillaStatsList() {
        Cached.VANILLA_STAT_UIDS_TO_CLEAR_EVERY_STAT_CALC = new ArrayList<ImmutablePair<Attribute, UUID>>();
        ExileDB.Stats().getFilterWrapped((Predicate<Stat>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$setupStatsThatAffectVanillaStatsList$13(com.robertx22.mine_and_slash.database.data.stats.Stat ), (Lcom/robertx22/mine_and_slash/database/data/stats/Stat;)Z)()).list.forEach(x -> {
            AttributeStat attri = (AttributeStat)x;
            Cached.VANILLA_STAT_UIDS_TO_CLEAR_EVERY_STAT_CALC.add((ImmutablePair<Attribute, UUID>)ImmutablePair.of((Object)attri.attribute, (Object)attri.uuid));
        });
    }

    private static /* synthetic */ boolean lambda$setupStatsThatAffectVanillaStatsList$13(Stat x) {
        return x instanceof AttributeStat;
    }
}

